<?php

Route::group(
    [
        'middleware' => [
            \Edwin404\Base\Support\BaseMiddleware::class,
            \App\Http\Middleware\MemberAuth::class,
        ]
    ],
    function () {

        Route::match(['get', 'post'], '', '\App\Http\Controllers\IndexController@index');
        Route::match(['get', 'post'], 'contact', '\App\Http\Controllers\PageController@contact');
        Route::match(['get', 'post'], 'about', '\App\Http\Controllers\PageController@about');

        Route::match(['get', 'post'], 'product', '\App\Http\Controllers\ProductController@index');
        Route::match(['get', 'post'], 'product/{id}', '\App\Http\Controllers\ProductController@view')->where(['id' => '[0-9]+']);
        Route::match(['get', 'post'], 'product/category/{id}', '\App\Http\Controllers\ProductController@category')->where(['id' => '[0-9]+']);

        Route::match(['get', 'post'], 'news', '\App\Http\Controllers\NewsController@index');
        Route::match(['get', 'post'], 'news/{id}', '\App\Http\Controllers\NewsController@view')->where(['id' => '[0-9]+']);

        Route::match(['get', 'post'], 'job', '\App\Http\Controllers\JobController@index');
        Route::match(['get', 'post'], 'job/{id}', '\App\Http\Controllers\JobController@view')->where(['id' => '[0-9]+']);

        Route::match(['get', 'post'], 'book', '\App\Http\Controllers\BookController@index');
        Route::match(['get', 'post'], 'message', '\App\Http\Controllers\MessageController@index');

        Route::match(['get', 'post'], 'p/{url}', '\App\Http\Controllers\SuperPageController@index');

    }
);

Route::match(['get', 'post'], 'install/ping', '\Edwin404\Tecmz\Controllers\InstallController@ping');
Route::match(['get', 'post'], 'install/execute', '\Edwin404\Tecmz\Controllers\InstallController@execute');
Route::match(['get', 'post'], 'install/lock', '\Edwin404\Tecmz\Controllers\InstallController@lock');

include __DIR__ . '/routes_admin.php';
