<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProduct extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('categoryId')->nullable()->comment('分类ID');

            $table->string('title', 100)->nullable()->comment('标题');
            $table->string('keywords', 100)->nullable()->comment('关键词');
            $table->string('description', 100)->nullable()->comment('描述');
            $table->string('cover', 100)->nullable()->comment('封面');

            $table->decimal('price', 20, 2)->nullable()->comment('价格');

            $table->text('content')->nullable()->comment('描述');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
