<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSuperPage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('super_page', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->string('url', 50)->nullable()->comment('');
            $table->string('title', 100)->nullable()->comment('');
            $table->string('keywords', 100)->nullable()->comment('');
            $table->string('description', 200)->nullable()->comment('');

            $table->unique(['url']);
        });

        Schema::create('super_page_item', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('pageId')->nullable()->comment('');
            $table->integer('sort')->nullable()->comment('');
            $table->string('type', 50)->nullable()->comment('');
            $table->text('content')->nullable()->comment('');

            $table->index(['pageId']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
