<?php

require_once __DIR__ . '/core.php';

// 取出请求参数
$lang = $con->request->get('lang');

if ($con->request->isAjax()) {
    $action = $con->request->post('action');
    switch ($action) {
        case 'list':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            // 查询数据
            $data = $con->db->table('banner')->find('id, b_type, b_image, b_text, b_sort, b_url')->where('b_lang = ?', [$lang])
                ->order('b_sort ASC')->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            // 处理数据
            $banners = [];
            foreach ($data as $index => $banner) {
                $banners[$index]['seq'] = $index + 1;
                $banners[$index]['id'] = $banner['id'];
                foreach (['text', 'sort', 'url'] as $key) {
                    $banners[$index][$key] = $banner['b_'.$key];
                }
                $banners[$index]['image'] = '<img src="'.loadImage($banner['b_image'], $hel).'" alt="横幅图片" height="27">';
                switch ($banner['b_type']) {
                    case 'product':$banners[$index]['type'] = '产品页';break;
                    case 'info':$banners[$index]['type'] = '信息页';break;
                    case 'gg':$banners[$index]['type'] = '广告';break;
                    default:$banners[$index]['type'] = '首页';break;
                }
            }
            unset($data);
            // 统计总数
            $count = $con->db->table('banner')->count();
            // 返回数据
            $data = [
                'msg'   => '',
                'code'  => 0,
                'count' => $count,
                'data'  => $banners
            ];
            $con->json($data);
            break;
        case 'edit':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 取出数据
            $data = $con->request->post(['type', 'image', 'text', 'url', 'sort']);
            // 处理数据
            $banner = verify_data($data);
            unset($data);
            if (!is_array($banner)) {
                $con->json(['code' => false, 'err' => $banner]);
                break;
            }
            // 更新数据库
            $row = $con->db->table('banner')->update($banner, 'id = ?', [$unique])->row();
            if (is_numeric($row)) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '修改失败']);
            }
            break;
        case 'drop':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('banner')->delete('id = ?', [$unique])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
        case 'insert':
            // 取出数据
            $data = $con->request->post(['type', 'image', 'text', 'url', 'sort']);
            // 处理数据
            $banner = verify_data($data);
            unset($data);
            if (!is_array($banner)) {
                $con->json(['code' => false, 'err' => $banner]);
                break;
            }
            $banner['b_lang'] = $lang;
            // 插入数据库
            $row = $con->db->table('banner')->insert($banner)->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '添加失败']);
            }
            break;
        case 'delete':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('banner')->delete('id IN ('.$unique.')')->row();
            $code = is_numeric($row);
            $con->json(['code' => $code]);
            break;
        case 'upload':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            $name = null;
            // 保存上传文件
            $image = new \sc\Upload();
            if ($image->isImage()) {
                $path = $image->save('file/banner', $name);
                if (!$path) {
                    $con->json(['code' => false, 'err' => '保存失败']);
                } else {
                    $con->json(['code' => true, 'path' => $path]);
                }
            } else {
                $con->json(['code' => false, 'err' => '请上传图片文件']);
            }
            break;
        default:break;
    }
} else {
    $con->render('banner', ['host' => $hel->url(), 'path' => $hel->path(), 'lang' => $lang, 'crumb' => $breadcrumb]);
}

/**
 * 数据验证方法
 *
 * @param array $data
 *
 * @return string|array
 */
function verify_data($data)
{
    foreach (['type', 'image', 'text', 'url'] as $index) {
        $banner['b_'.$index] = $data[$index];
    }
    if ($data['sort'] < 0) {
        return 'Banner排序不能小于0';
    }
    $banner['b_sort'] = $data['sort'];
    return $banner;
}