<?php

require_once __DIR__ . '/core.php';

if ($con->request->isAjax()) {
    // 取出操作
    $action = $con->request->post('action');
    switch ($action) {
        case 'upload':
            $type = $con->request->post('type');
            // 取出文件路径
            switch ($type) {
                case 'logo':
                    $name = $con->db->table('conf')->find('c_logo')->where('id = ?', ['sem-cms'])->one();
                    if (!$name) {
                        $name = 'file/logo.png';
                    } else {
                        $name = $name['c_logo'];
                    }
                    break;
                case 'icon':
                    $name = $con->db->table('conf')->find('c_icon')->where('id = ?', ['sem-cms'])->one();
                    if (!$name) {
                        $name = 'file/icon.ico';
                    } else {
                        $name = $name['c_icon'];
                    }
                    break;
                case 'image':
                    $name = $con->db->table('conf')->find('c_image')->where('id = ?', ['sem-cms'])->one();
                    if (!$name) {
                        $name = 'file/image.png';
                    } else {
                        $name = $name['c_image'];
                    }
                    break;
                default:$name = false;break;
            }
            if (!$name) {
                break;
            }
            // 保存上传文件
            $name = ltrim(strrchr($name, '/'));
            $image = new \sc\Upload();
            if ($image->isImage()) {
                $path = $image->save('file', $name);
                if (!$path) {
                    $con->json(['code' => false, 'err' => '保存失败']);
                } else {
                    $con->json(['code' => true, 'path' => $path]);
                }
            } else {
                $con->json(['code' => false, 'err' => '请上传图片文件']);
            }
            break;
	    case 'sitemap':
		    $sitemap = [
			    '<?xml version="1.0" encoding="UTF-8"?>',
			    '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">'
		    ];
		    $lang = $con->db->table('lang')->find('l_word, l_main')->where('l_on = ?', [1])->all();
		    foreach ($lang as $l) {
			    $la = $l['l_main'] == 1 ? '' : $l['l_word'] . '/';
			    $nav = $con->db->table('nav')->find('n_url')->where('n_lang = ?', [$l['l_word']])->all();
			    foreach ($nav as $v) {
				    $sitemap[] = "    <url>\r\n        <loc>".$hel->url($la.$v['n_url'])."</loc>\r\n        <changefreq>always</changefreq>\r\n        <priority>0.90</priority>\r\n    </url>";
			    }
			    $cate = $con->db->table('cate')->find('id, pid, c_url')->where('c_on = ? AND c_lang = ?', [1, $l['l_word']])->all();
			    $cate = $hel->listTree($cate, 1);
			    foreach ($cate as $v) {
				    $url = $v['c_url'] != '' ? $v['c_url'] : $v['id'];
				    $sitemap[] = "    <url>\r\n        <loc>".$hel->url($la.$url)."</loc>\r\n        <changefreq>always</changefreq>\r\n        <priority>0.90</priority>\r\n    </url>";
			    }
			    $product = $con->db->table('product')->find('id, p_url')->where('p_on = ? AND p_lang = ?', [1, $l['l_word']])->all();
			    foreach ($product as $v) {
				    $url = $v['p_url'] != '' ? $v['p_url'] : $v['id'];
				    $sitemap[] = "    <url>\r\n        <loc>".$hel->url($la.$url, false)."</loc>\r\n        <changefreq>always</changefreq>\r\n        <priority>0.90</priority>\r\n    </url>";
			    }
		    }
		    $sitemap[] = '</urlset>';
		    if (file_put_contents(PATH.'/sitemap.xml', implode("\r\n", $sitemap))) {
			    $con->json(['code' => true]);
		    } else {
			    $con->json(['code' => false, 'err' => '无写入权限，生成失败']);
		    }
		    break;
        default:
            // 取出数据
            $data = $con->request->post();
            $data['s_open'] = isset($data['s_open']) ? 1 : 0;
            $conf = [];
            foreach ($data as $index => $datum) {
                $conf['c_' . $index] = $datum;
            }
            if (isset($conf['c_price_l'])) {
                $conf['c_price_l'] = str_replace([' ', '，'], ['', ','], $conf['c_price_l']);
            }
            $conf['c_copy'] .= base64_decode(implode('', [
                "IC0gUG93ZXJlZCBieSA8",
                "c3Ryb25nPjxhIGhyZWY9",
                "aHR0cDovL3d3dy5zZW0t",
                "Y21zLmNvbS8+U0VNQ01T",
                "PC9hPjwvc3Ryb25nPg=="
            ]));
            // 修改数据
            $row = $con->db->table('conf')->update($conf, 'id = ?', ['sem-cms'])->row();
            // 返回结果
            $code = 1 == $row;
            $con->json(['code' => $code]);
            break;
    }
} else {
    // 查询数据
    $data = $con->db->table('conf')->find('*')->where('id = ?', ['sem-cms'])->one();
    $conf = [];
    foreach ($data as $index => $datum) {
        $conf[substr($index, 2)] = $datum;
    }
    $conf['copy'] = str_replace(base64_decode(implode('', [
        "IC0gUG93ZXJlZCBieSA8",
        "c3Ryb25nPjxhIGhyZWY9",
        "aHR0cDovL3d3dy5zZW0t",
        "Y21zLmNvbS8+U0VNQ01T",
        "PC9hPjwvc3Ryb25nPg=="
    ])), '', $conf['copy']);
    unset($data);
    // 显示页面
    $con->render('conf', [
        'crumb' => $breadcrumb,
        'host'  => $hel->url(),
        'path'  => $hel->path(),
        'conf'  => $conf,
        'hel'   => $hel
    ]);
}
