<?php

require_once __DIR__ . '/core.php';

// 取出请求参数
$lang = $con->request->get('lang');

if ($con->request->isAjax()) {
    $action = $con->request->post('action');
    switch ($action) {
        case 'list':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            // 查询数据
            $data = $con->db->table('down')->find('id, d_name, d_path, d_sort')->where('d_lang = ?', [$lang])
                ->order('d_sort ASC')->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            // 处理数据
            $downs = [];
            foreach ($data as $index => $down) {
                $downs[$index]['seq'] = $index + 1;
                $downs[$index]['id'] = $down['id'];
                foreach (['path', 'sort'] as $key) {
                    $downs[$index][$key] = $down['d_'.$key];
                }
            }
            unset($data);
            // 统计总数
            $count = $con->db->table('down')->count();
            // 返回数据
            $data = [
                'msg'   => '',
                'code'  => 0,
                'count' => $count,
                'data'  => $downs
            ];
            $con->json($data);
            break;
        case 'edit':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 取出数据
            $data = $con->request->post(['type', 'image', 'url', 'sort']);
            // 处理数据
            $down = verify_data($data);
            unset($data);
            if (!is_array($down)) {
                $con->json(['code' => false, 'err' => $down]);
                break;
            }
            // 更新数据库
            $row = $con->db->table('down')->update($down, 'id = ?', [$unique])->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '修改失败']);
            }
            break;
        case 'drop':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('down')->delete('id = ?', [$unique])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
        case 'insert':
            // 取出数据
            $data = $con->request->post(['type', 'image', 'url', 'sort']);
            // 处理数据
            $down = verify_data($data);
            unset($data);
            if (!is_array($down)) {
                $con->json(['code' => false, 'err' => $down]);
                break;
            }
            $down['d_lang'] = $lang;
            // 插入数据库
            $row = $con->db->table('down')->insert($down)->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '添加失败']);
            }
            break;
        case 'delete':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('down')->delete('id IN ('.$unique.')')->row();
            $code = is_numeric($row);
            $con->json(['code' => $code]);
            break;
        case 'upload':
            $image = new \sc\Upload();
            if ($image->isImage()) {
                $path = $image->save('file/attribute');
                if (!$path) {
                    $con->json(['code' => false, 'err' => '保存失败']);
                } else {
                    $con->json(['code' => true, 'path' => $path]);
                }
            } else {
                $con->json(['code' => false, 'err' => '请上传图片文件']);
            }
            break;
        default:break;
    }
} else {
    $con->render('down', ['host' => $hel->url(), 'path' => $hel->path(), 'lang' => $lang, 'crumb' => $breadcrumb]);
}

/**
 * 数据验证方法
 *
 * @param array $data
 *
 * @return string|array
 */
function verify_data($data)
{
    foreach (['type', 'image', 'sort'] as $index) {
        $down['d_'.$index] = $data[$index];
    }
    if ($data['sort'] < 0) {
        return 'Banner排序不能小于0';
    }
    $down['d_sort'] = $data['sort'];
    return $down;
}