<?php

require_once __DIR__ . '/core.php';

// 取出请求参数
$type = $con->request->get('type');
if ($con->request->isAjax()) {
    $action = $con->request->post('action');
    switch ($action) {
        case 'list':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            switch ($type) {
                case 'image':$type = 'I';break;
                case 'file':
                default:$type = 'F';break;
            }
            // 查询数据
            $data = $con->db->table('file')->find('id, f_name, f_path, f_time')
                ->where('f_type = ?', [$type])->order('f_time DESC')->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            // 处理数据
            $files = [];
            foreach ($data as $index => $file) {
                $files[$index]['seq'] = $index + 1;
                $files[$index]['id'] = $file['id'];
                foreach (['name', 'time'] as $key) {
                    $files[$index][$key] = $file['f_'.$key];
                }
                if ('I' == $type) {
                    $files[$index]['path'] = '<img src="'.loadImage($file['f_path'], $hel).'" alt="图片" height="27">';
                } else {
                    $files[$index]['path'] = $file['f_path'];
                }
            }
            unset($data);
            // 统计总数
	        $count = $con->db->table('file')->count('f_type = ?', [$type]);
            // 返回数据
            $data = [
                'msg'   => '',
                'code'  => 0,
                'count' => $count,
                'data'  => $files
            ];
            $con->json($data);
            break;
        case 'edit':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 取出数据
            $data = $con->request->post(['name', 'path']);
            // 处理数据
            $file = verify_data($data);
            unset($data);
            if (!is_array($file)) {
                $con->json(['code' => false, 'err' => $file]);
                break;
            }
            // 更新数据库
            $row = $con->db->table('file')->update($file, 'id = ?', [$unique])->row();
            if (is_numeric($row)) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '修改失败']);
            }
            break;
        case 'drop':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('file')->delete('id = ?', [$unique])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
        case 'insert':
            // 取出数据
            $data = $con->request->post(['name', 'path']);
            // 处理数据
            $file = verify_data($data);
            unset($data);
            if (!is_array($file)) {
                $con->json(['code' => false, 'err' => $file]);
                break;
            }
            switch ($type) {
                case 'image':$file['f_type'] = 'I';break;
                case 'file':
                default:$file['f_type'] = 'F';break;
            }
            // 插入数据库
            $row = $con->db->table('file')->insert($file)->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '添加失败']);
            }
            break;
        case 'delete':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('file')->delete('id IN ('.$unique.')')->row();
            $code = is_numeric($row);
            $con->json(['code' => $code]);
            break;
        case 'upload':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            $custom = $con->request->post('custom');
            if ($custom != null) {
	            $name = $custom;
            } else {
                $name = null;
            }
            // 保存上传文件
            $file = new \sc\Upload();
            if ($type == 'image') {
                $path = $file->save('file/image/'.date('YmdH'), $name);

                // 处理图片
                if ($path != false) {
                    $conf = $con->db->table('conf')->find('c_image, c_img_w, c_img_h, c_texts, c_txt_c, c_place, c_s_way')->where('id = ?', ['sem-cms'])->one();
                    if ($conf != false) {
                        $file->handle(PATH.'/'.$path, $conf);
                    }
                }
            } else {
                $path = $file->save('file/file', $name);
            }
            if (!$path) {
                $con->json(['code' => false, 'err' => '保存失败']);
            } else {
                $con->json(['code' => true, 'path' => $path]);
            }
            break;
        /** 外部请求 */
        case 'select':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            // 分类查找
            $type = $con->request->post('type');
            $data = $con->db->table('file')->find('f_name, f_path')->where('f_type = ?', [$type])
                ->order('f_time DESC')->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            $file = [];
            foreach ($data as $index => $datum) {
                $file[$index]['name'] = $datum['f_name'];
                $file[$index]['path'] = loadImage($datum['f_path'], $hel, false);
            }
            unset($data);
            // 返回数据
            $con->json($file);
            break;
        case 'number':
            $type = $con->request->post('type');
            $number = $con->db->table('file')->count('f_type = ?', [$type]);
            $con->json(['number' => $number]);
            break;
        default:break;
    }
} else {
    $con->render('file', ['host' => $hel->url(), 'path' => $hel->path(), 'type' => $type, 'crumb' => $breadcrumb]);
}

/**
 * 数据验证方法
 *
 * @param array $data
 *
 * @return string|array
 */
function verify_data($data)
{
    if ('' == $data['name']) {
        return '文件名称不能为空';
    }
    $file['f_name'] = $data['name'];
    if ('' == $data['path']) {
        return '请先上传文件';
    }
    $file['f_path'] = $data['path'];
    $file['f_time'] = date('Y-m-d H:i:s');
    return $file;
}