<?php

require_once __DIR__ . '/core.php';

// 取出请求参数
$lang = $con->request->get('lang');

if ($con->request->isAjax()) {
    $action = $con->request->post('action');
    switch ($action) {
        case 'list':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            // 查询数据
            $data = $con->db->table('link')->find('id, l_name, l_image, l_url, l_sort')->where('l_lang = ?', [$lang])
                ->order('l_sort ASC')->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            // 处理数据
            $links = [];
            foreach ($data as $index => $link) {
                $links[$index]['seq'] = $index + 1;
                $links[$index]['id'] = $link['id'];
                foreach (['name', 'sort', 'url'] as $key) {
                    $links[$index][$key] = $link['l_'.$key];
                }
                $links[$index]['image'] = '<img src="'.loadImage($link['l_image'], $hel).'" alt="链接图片" height="27">';
            }
            unset($data);
            // 统计总数
            $count = $con->db->table('link')->count();
            // 返回数据
            $data = [
                'msg'   => '',
                'code'  => 0,
                'count' => $count,
                'data'  => $links
            ];
            $con->json($data);
            break;
        case 'edit':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 取出数据
            $data = $con->request->post(['name', 'image', 'url', 'sort']);
            // 处理数据
            $link = verify_data($data);
            unset($data);
            if (!is_array($link)) {
                $con->json(['code' => false, 'err' => $link]);
                break;
            }
            // 更新数据库
            $row = $con->db->table('link')->update($link, 'id = ?', [$unique])->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '修改失败']);
            }
            break;
        case 'drop':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('link')->delete('id = ?', [$unique])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
        case 'insert':
            // 取出数据
            $data = $con->request->post(['name', 'image', 'url', 'sort']);
            // 处理数据
            $link = verify_data($data);
            unset($data);
            if (!is_array($link)) {
                $con->json(['code' => false, 'err' => $link]);
                break;
            }
            $link['l_lang'] = $lang;
            // 插入数据库
            $row = $con->db->table('link')->insert($link)->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '添加失败']);
            }
            break;
        case 'delete':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('link')->delete('id IN ('.$unique.')')->row();
            $code = is_numeric($row);
            $con->json(['code' => $code]);
            break;
        case 'upload':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 查找头像地址
            $name = null;
            // 保存上传文件
            $image = new \sc\Upload();
            if ($image->isImage()) {
                $path = $image->save('file/link', $name);
                if (!$path) {
                    $con->json(['code' => false, 'err' => '保存失败']);
                } else {
                    $con->json(['code' => true, 'path' => $path]);
                }
            } else {
                $con->json(['code' => false, 'err' => '请上传图片文件']);
            }
            break;
        default:break;
    }
} else {
    $con->render('link', ['host' => $hel->url(), 'path' => $hel->path(), 'lang' => $lang, 'crumb' => $breadcrumb]);
}

/**
 * 数据验证方法
 *
 * @param array $data
 *
 * @return string|array
 */
function verify_data($data)
{
    foreach (['name', 'image', 'url'] as $index) {
        $link['l_'.$index] = $data[$index];
    }
    if ($data['sort'] < 0) {
        return '友情链接排序不能小于0';
    }
    $link['l_sort'] = $data['sort'];
    return $link;
}