<?php

require_once __DIR__ . '/core.php';

$lang = $con->request->get('lang');

if ($lang == null) {
	$php_version = 'PHP/' . phpversion();

	if (function_exists('apache_get_version')) {
		$server_version = strchr(apache_get_version(), ' ', true);
	} else if ($con->request->server('SERVER_SOFTWARE')) {
		$server_version = strchr($con->request->server('SERVER_SOFTWARE'), ' ', true);
	} else {
		$server_version = 'nginx + fastcgi';
	}

	$mysql_version = 'MySQL/'.$con->db->table('conf')->find('VERSION() v')->one()['v'];

	$con->render('main', [
		'path'    => $hel->path(),
		'version' => [
			'php'    => $php_version,
			'server' => $server_version,
			'mysql'  => $mysql_version,
		]
	]);
} else {
	$con->render('main-order', ['path' => $hel->path()]);
}
