<?php

require_once __DIR__ . '/core.php';

// 取出请求参数
$lang = $con->request->get('lang');

if ($con->request->isAjax()) {
    $action = $con->request->post('action');
    switch ($action) {
        case 'list':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            // 查询数据
            $data = $con->db->table('nav')->find('id, n_name, n_url, n_sort')->where('n_lang = ?', [$lang])
                ->order('n_sort ASC')->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            // 处理数据
            $navs = [];
            foreach ($data as $index => $nav) {
                $navs[$index]['seq'] = $index + 1;
                $navs[$index]['id'] = $nav['id'];
                foreach (['name', 'url', 'sort'] as $key) {
                    $navs[$index][$key] = $nav['n_'.$key];
                }
            }
            unset($data);
            // 统计总数
            $count = $con->db->table('nav')->count();
            // 返回数据
            $data = [
                'msg'   => '',
                'code'  => 0,
                'count' => $count,
                'data'  => $navs
            ];
            $con->json($data);
            break;
        case 'edit':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 取出数据
            $data = $con->request->post(['name', 'url', 'sort']);
            // 处理数据
            $nav = verify_data($data);
            unset($data);
            if (!is_array($nav)) {
                $con->json(['code' => false, 'err' => $nav]);
                break;
            }
            // 更新数据库
            $row = $con->db->table('nav')->update($nav, 'id = ?', [$unique])->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '修改失败']);
            }
            break;
        case 'drop':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('nav')->delete('id = ?', [$unique])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
        case 'insert':
            // 取出数据
            $data = $con->request->post(['name', 'url', 'sort']);
            // 处理数据
            $nav = verify_data($data);
            unset($data);
            if (!is_array($nav)) {
                $con->json(['code' => false, 'err' => $nav]);
                break;
            }
            $nav['n_lang'] = $lang;
            // 插入数据库
            $row = $con->db->table('nav')->insert($nav)->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '添加失败']);
            }
            break;
        case 'delete':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('nav')->delete('id IN ('.$unique.')')->row();
            $code = is_numeric($row);
            $con->json(['code' => $code]);
            break;
        case 'upload':
            $image = new \sc\Upload();
            if ($image->isImage()) {
                $path = $image->save('file/attribute');
                if (!$path) {
                    $con->json(['code' => false, 'err' => '保存失败']);
                } else {
                    $con->json(['code' => true, 'path' => $path]);
                }
            } else {
                $con->json(['code' => false, 'err' => '请上传图片文件']);
            }
            break;
        default:break;
    }
} else {
    $con->render('nav', ['host' => $hel->url(), 'path' => $hel->path(), 'lang' => $lang, 'crumb' => $breadcrumb]);
}

/**
 * 数据验证方法
 *
 * @param array $data
 *
 * @return string|array
 */
function verify_data($data)
{
    foreach (['name', 'url'] as $index) {
        $nav['n_'.$index] = $data[$index];
    }
    if ($data['sort'] < 0) {
        return '导航排序不能小于0';
    }
    $nav['n_sort'] = $data['sort'];
    return $nav;
}