<?php

require_once __DIR__ . '/core.php';

// 取出请求参数
$lang = $con->request->get('lang');

if ($con->request->isAjax()) {
    // 取出操作
    $action = $con->request->post('action');
    switch ($action) {
        default:
            $data = $con->request->post(['h_til', 'h_kwd', 'h_des', 'p_til', 'p_kwd', 'p_des', 'i_til', 'i_kwd', 'i_des', 'c_des', 'h_tpl', 'p_tags'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $data['p_tags'] = json_encode($data['p_tags']);
            $row = $con->db->table('page')->update($data, 'p_lang = ?', [$lang])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
    }
} else {
    // 查询数据
    $data = $con->db->table('page')->find('*')->where('p_lang = ?', [$lang])->one();
    $data['p_tags'] = json_decode($data['p_tags'], true);
    // 显示页面
    $con->render('page', [
        'crumb' => $breadcrumb,
        'host'  => $hel->url(),
        'path'  => $hel->path(),
        'page'  => $data,
        'hel'   => $hel
    ]);
}
