<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $lang
 * @var string $type
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>分类管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 0 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 15px 20px;
    }
    .operation {
      height: 30px;
      margin: 10px 0;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
  <div class="operation">
    <button id="insert" class="layui-btn layui-btn-normal layui-btn-small">
      <i class="layui-icon">&#xe608;</i>添加
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/cate.php?lang=<?php echo $lang; ?>&type=<?php echo $type; ?>', method:'post', where:{action:'list'}, id:'cate'}" lay-filter="cate">
    <thead>
    <tr>
      <th lay-data="{field:'seq', width:70, sort:true}">序号</th>
      <th lay-data="{field:'id', width:60}">ID</th>
      <th lay-data="{field:'name', width:460}">名称</th>
      <th lay-data="{field:'url', width:120}">URL</th>
      <th lay-data="{field:'image', width:120}">标识图</th>
      <th lay-data="{field:'on', width:100, event:'open'}">启用</th>
      <th lay-data="{field:'re', width:60, event:'recommend'}">推荐</th>
      <th lay-data="{field:'sort', width:120, sort:true}">排序</th>
      <th lay-data="{fixed: 'right', width:190, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="edit"><i class="layui-icon">&#xe642;</i>编辑</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" lay-event="drop"><i class="layui-icon">&#xe640;</i>删除</a>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'layer', 'upload', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            table = layui.table,
            element = layui.element;

        // 监听表格工具条事件
        table.on('tool(cate)', function (o) {
            var data = o.data,
                tr = o.tr,
                e = o.event;

            switch (e) {
                case 'edit':
                    location.href = '<?php echo $path; ?>/cate.php?lang=<?php echo $lang; ?>&type=<?php echo $type; ?>&action=edit&unique=' + data.id;
                    break;
                case 'drop':
                    layer.confirm('确认删除？删除后无法恢复', function (id) {
                        layer.close(id);
                        $.ajax({
                            url:'<?php echo $path; ?>/cate.php?lang=<?php echo $lang; ?>&type=<?php echo $type; ?>',
                            data:{
                                action:'drop',
                                unique:data.id
                            },
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    o.del();
                                    layer.msg('删除成功', {icon:1});
                                } else {
                                    layer.msg('删除失败', {icon:2});
                                }
                            }
                        });
                    });
                    break;
                case 'open':
	            case 'recommend':
                    $.ajax({
                        url:'<?php echo $path; ?>/cate.php?lang=<?php echo $lang; ?>&type=<?php echo $type; ?>',
                        data:{
                            action:e,
                            unique:data.id
                        },
                        type:'POST',
                        dataType:'json',
                        success:function (data) {
	                        if (data.code) {
		                        location.reload();
	                        } else {
		                        layer.msg(data.err, {icon:2});
	                        }
                        }
                    });
                    break;
                default:break;
            }
        });

        $(document).on('click', '#insert', function () {
            location.href = '<?php echo $path; ?>/cate.php?lang=<?php echo $lang; ?>&type=<?php echo $type; ?>&action=insert';
        }).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            location.reload();
        });
    });
</script>
</body>
</html>