<?php
/**
 * 预定义变量
 *
 * @var string     $crumb
 * @var string     $host
 * @var string     $path
 * @var array      $conf
 * @var \sc\Helper $hel
 * @var string     $msg
 * @var string     $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>站点设置</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      height: 30px;
      margin: 25px 20px;
    }
    #operation {
      position: fixed;
      top: 15px;
      right: 15px;
      margin: 10px 15px;
      z-index: 666;
    }
    .table-head {
      background: url('<?php echo $path; ?>/img/table.jpg');
      width: 100%;
      height: 30px;
    }
    .table-head > label {
      padding-left: 20px;
      line-height: 30px;
      text-align: left;
      font-size: 14px;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
</div>
<div id="operation" class="layui-btn-group">
  <a class="layui-btn layui-btn-primary layui-btn-small" href="#site">站点设置</a>
  <a class="layui-btn layui-btn-primary layui-btn-small" href="#contact">联系方式</a>
  <a class="layui-btn layui-btn-primary layui-btn-small" href="#email">邮箱设置</a>
  <a class="layui-btn layui-btn-primary layui-btn-small" href="#config">参数设置</a>
  <a class="layui-btn layui-btn-primary layui-btn-small" href="#watermark">水印设置</a>
  <a class="layui-btn layui-btn-normal layui-btn-small" href="#head">返回顶部</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" href="javascript:location.reload();">刷新</a>
</div>
<div class="form">
  <form id="conf" class="layui-form layui-form-pane">
    <div id="site">
      <div class="table-head"><label><i class="layui-icon">&#xe631;</i>&nbsp;&nbsp;&nbsp;<b>站点设置</b></label></div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">名称</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="name" placeholder="网站名称" autocomplete="off" maxlength="60" value="<?php echo $conf['name']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">域名</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="host" placeholder="网站域名" autocomplete="off" maxlength="120" value="<?php echo $conf['host'] == '' ? str_replace(['http://', 'https://'], '', $host) : $conf['host']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">站点地图</label>
        <div class="layui-input-inline" style="width: 120px;">
          <button type="button" class="layui-btn" id="map" lay-submit lay-filter="map">生成</button>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">LOGO</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="hidden" name="logo" value="<?php echo $conf['logo']; ?>">
          <button type="button" id="logo" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传LOGO</button>
        </div>
        <div class="layui-form-mid layui-word-aux"><img id="logo-img" src="<?php echo $hel->to($conf['logo']); ?>" alt="LOGO"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">ICON</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="hidden" name="icon" value="<?php echo $conf['icon']; ?>">
          <button type="button" id="icon" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传ICON</button>
        </div>
        <div class="layui-form-mid layui-word-aux"><img id="icon-img" src="<?php echo $hel->to($conf['icon']); ?>" alt="ICON" height="22"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">版权</label>
        <div class="layui-input-inline" style="width:600px;">
          <textarea class="layui-textarea" name="copy" cols="30" rows="2" placeholder="网站版权信息" maxlength="240"><?php echo $conf['copy']; ?></textarea>
        </div>
        <div class="layui-form-mid layui-word-aux">可放置流量统计代码</div>
      </div>
    </div>
    <div id="contact">
      <div class="table-head"><label><i class="layui-icon">&#xe613;</i>&nbsp;&nbsp;<b>联系方式</b></label></div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">Skype</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="skype" placeholder="Skype账号" autocomplete="off" maxlength="120" value="<?php echo $conf['skype']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">What's App</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="whats" placeholder="What's App账号" autocomplete="off" maxlength="120" value="<?php echo $conf['whats']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">邮箱</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="email" placeholder="联系邮箱" autocomplete="off" maxlength="120" value="<?php echo $conf['email']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">电话</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="phone" placeholder="联系电话" autocomplete="off" maxlength="30" value="<?php echo $conf['phone']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">地址</label>
        <div class="layui-input-inline" style="width: 480px;">
          <textarea class="layui-textarea" name="local" cols="30" rows="5" placeholder="公司地址" maxlength="120"><?php echo $conf['local']; ?></textarea>
        </div>
      </div>
    </div>
    <div id="email">
      <div class="table-head"><label><i class="layui-icon">&#xe609;</i>&nbsp;&nbsp;&nbsp;<b>邮箱设置</b></label></div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">邮箱账号</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="account" placeholder="邮箱账号" autocomplete="off" maxlength="120" value="<?php echo $conf['account']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">邮箱密码</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="password" class="layui-input" name="ciphers" placeholder="邮箱密码" autocomplete="off" maxlength="120" value="<?php echo $conf['ciphers']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">邮箱授权码，非邮箱密码，需在邮箱设置中申请</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">邮箱SMTP</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="smtp" placeholder="邮箱SMTP" autocomplete="off" maxlength="120" value="<?php echo $conf['smtp']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">形式一般为smtp.xxx.com</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">邮箱端口</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="port" placeholder="邮箱端口" autocomplete="off" min="0" max="65535" value="<?php echo $conf['port']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">通常为25, 465, 578</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">邮箱地址</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="address" placeholder="邮箱地址" autocomplete="off" maxlength="120" value="<?php echo $conf['address']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">询盘邮箱</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="consult" placeholder="询盘邮箱" autocomplete="off" maxlength="120" value="<?php echo $conf['consult']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">用于接收询盘信息，最好与主邮箱不同</div>
      </div>
    </div>
    <div id="config">
      <div class="table-head"><label><i class="layui-icon">&#xe614;</i>&nbsp;&nbsp;&nbsp;<b>参数设置</b></label></div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">开启站点</label>
        <div class="layui-input-block">
          <input class="layui-form-switch" type="checkbox" name="s_open" title="点击开启/关闭网站" lay-skin="switch" lay-text="开启|关闭" <?php echo 1 == $conf['s_open'] ? 'checked' : ''; ?>>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">重量单位</label>
        <div class="layui-input-inline">
          <input type="radio" name="weight" value="G" title="克" <?php echo 'G' == $conf['weight'] ? 'checked' : ''; ?>>
          <input type="radio" name="weight" value="KG" title="千克" <?php echo 'G' != $conf['weight'] ? 'checked' : ''; ?>>
        </div>
        <div class="layui-form-mid layui-word-aux">商品重量单位</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">产品条目</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="p_list" placeholder="产品条目" autocomplete="off" min="1" max="255" value="<?php echo $conf['p_list']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">产品列表页面每页显示产品数量</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">信息条目</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="i_list" placeholder="信息条目" autocomplete="off" min="1" max="255" value="<?php echo $conf['i_list']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">信息列表页面每页显示产品数量</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">META标签</label>
        <div class="layui-input-inline" style="width: 480px;">
          <textarea class="layui-textarea" name="v_meta" cols="30" rows="5" placeholder="站点验证meta标签" maxlength="2000"><?php echo $conf['v_meta']; ?></textarea>
        </div>
        <div class="layui-form-mid layui-word-aux">站点验证meta标签</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">Google代码</label>
        <div class="layui-input-inline" style="width: 480px;">
          <textarea class="layui-textarea" name="google" cols="30" rows="5" placeholder="Google分析代码" maxlength="2000"><?php echo $conf['google']; ?></textarea>
        </div>
        <div class="layui-form-mid layui-word-aux">Google分析代码</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">分享代码</label>
        <div class="layui-input-inline" style="width: 480px;">
          <textarea class="layui-textarea" name="shares" cols="30" rows="5" placeholder="分享代码" maxlength="2000"><?php echo $conf['shares']; ?></textarea>
        </div>
        <div class="layui-form-mid layui-word-aux">分享代码</div>
      </div>
    </div>
    <div id="watermark">
      <div class="table-head"><label><i class="layui-icon">&#xe64a;</i>&nbsp;&nbsp;&nbsp;<b>水印设置</b></label></div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">图片宽度</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="img_w" placeholder="图片宽度" autocomplete="off" min="0" max="65535" value="<?php echo $conf['img_w']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">处理后图片宽度</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">图片高度</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="img_h" placeholder="图片高度" autocomplete="off" min="0" max="65535" value="<?php echo $conf['img_h']; ?>">
        </div>
        <div class="layui-form-mid layui-word-aux">处理后图片高度</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">水印位置</label>
        <div class="layui-input-inline">
          <input type="radio" name="place" value="LT" title="左上" <?php echo 'LT' == $conf['place'] ? 'checked' : ''; ?>>
          <input type="radio" name="place" value="LB" title="左下" <?php echo 'LB' == $conf['place'] ? 'checked' : ''; ?>>
          <input type="radio" name="place" value="RT" title="右上" <?php echo 'RT' == $conf['place'] ? 'checked' : ''; ?>>
          <input type="radio" name="place" value="RB" title="右下" <?php echo 'RB' == $conf['place'] ? 'checked' : ''; ?>>
          <input type="radio" name="place" value="C" title="中间" <?php echo 'C' == $conf['place'] ? 'checked' : ''; ?>>
        </div>
        <div class="layui-form-mid layui-word-aux">附加水印位置</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">附加类型</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="radio" name="s_way" value="none" title="不加" <?php echo 'none' == $conf['s_way'] ? 'checked' : ''; ?>>
          <input type="radio" name="s_way" value="texts" title="文字" <?php echo 'texts' == $conf['s_way'] ? 'checked' : ''; ?>>
          <input type="radio" name="s_way" value="image" title="图片" <?php echo 'image' == $conf['s_way'] ? 'checked' : ''; ?>>
        </div>
        <div class="layui-form-mid layui-word-aux">附加水印类型</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">文字颜色</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="radio" name="txt_c" value="#FFFFFF" title="<font color='#000000'>白</font>" <?php echo '#FFFFFF' == $conf['txt_c'] ? 'checked' : ''; ?>>
          <input type="radio" name="txt_c" value="#000000" title="<font color='#000000'>黑</font>" <?php echo '#000000' == $conf['txt_c'] ? 'checked' : ''; ?>>
          <input type="radio" name="txt_c" value="#FF0000" title="<font color='#FF0000'>红</font>" <?php echo '#FF0000' == $conf['txt_c'] ? 'checked' : ''; ?>>
          <input type="radio" name="txt_c" value="#00FF00" title="<font color='#00FF00'>绿</font>" <?php echo '#00FF00' == $conf['txt_c'] ? 'checked' : ''; ?>>
          <input type="radio" name="txt_c" value="#0000FF" title="<font color='#0000FF'>蓝</font>" <?php echo '#0000FF' == $conf['txt_c'] ? 'checked' : ''; ?>>
          <input type="radio" name="txt_c" value="#FFFF00" title="<font color='#FFFF00'>黄</font>" <?php echo '#FFFF00' == $conf['txt_c'] ? 'checked' : ''; ?>>
          <input type="radio" name="txt_c" value="#FF00FF" title="<font color='#FF00FF'>粉</font>" <?php echo '#FF00FF' == $conf['txt_c'] ? 'checked' : ''; ?>>
          <input type="radio" name="txt_c" value="#CCCCCC" title="<font color='#CCCCCC'>灰</font>" <?php echo '#CCCCCC' == $conf['txt_c'] ? 'checked' : ''; ?>>
        </div>
        <div class="layui-form-mid layui-word-aux">附加水印文字颜色</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">水印文字</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="texts" placeholder="附加水印文字内容" autocomplete="off" maxlength="240" value="<?php echo $conf['texts']; ?>">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">水印图片</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="hidden" name="image" value="<?php echo $conf['image']; ?>">
          <button type="button" id="image" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传图片</button>
        </div>
        <div class="layui-form-mid layui-word-aux"><img id="image-img" src="<?php echo $hel->to($conf['image']); ?>" alt="水印图片"></div>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label"></label>
      <div class="layui-input-inline" style="width: 120px;">
        <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="conf">提交</button>
      </div>
    </div>
  </form>
</div>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'layer', 'upload', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            upload = layui.upload,
            element = layui.element;

        // 异步提交
        form.on('submit(conf)', function (el) {
            $.ajax({
                url:el.form.action,
                data:$('#conf').serialize(),
                type:'POST',
                dataType:'json',
                success:function (data) {
                    if (data.code) {
                        layer.msg('修改成功', {icon:1});
                        setTimeout(function () {
                            location.reload();
                        }, 3000);
                    } else {
                        layer.msg('修改失败', {icon:2});
                    }
                }
            });
            return false;
        });

        $(document).on('click', '#map', function () {
        	$.ajax({
              url:'<?php echo $path; ?>/conf.php',
              data:{action:'sitemap'},
              type:'POST',
              dataType:'json',
              success:function (data) {
	              if (data.code) {
		              layer.msg('生成成功', {icon:1})
	              } else {
		              layer.msg(data.err, {icon:2});
	              }
              }
          })
        });

        // 渲染上传图片按钮
        uploadRender('logo');
        uploadRender('icon');
        uploadRender('image');

        // 图片上传渲染函数
        function uploadRender(type) {
            upload.render({
                elem:'#' + type,
                url:'<?php echo $path; ?>/conf.php',
                data:{
                    action:'upload',
                    type:type
                },
                accept:'file',
                size:2000,
                done:function (data) {
                    if (data.code) {
                        $('input[name=' + type + ']').val(data.path);
                        $('#' + type + '-img').attr('src', '<?php echo $host; ?>/' + data.path + '?rand=' + Math.random());
                        layer.msg('上传成功', {icon: 1});
                    } else {
                        layer.msg(data.err, {icon: 2});
                    }
                }
            });
        }
    });
</script>
</body>
</html>