<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $lang
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>产品属性管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 15px;
    }
    .breadcrumb {
      padding: 10px;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 20px 15px;
    }
    .operation {
      height: 30px;
      margin: 10px 15px;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
  <div class="operation">
    <button id="delete" class="layui-btn layui-btn-danger layui-btn-small">
      <i class="layui-icon">&#xe640;</i>批量删除
    </button>
    <button id="insert" class="layui-btn layui-btn-normal layui-btn-small">
      <i class="layui-icon">&#xe608;</i>添加
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/down.php?lang=<?php echo $lang; ?>', method:'post', where:{action:'list'}, page:true, limit:10, id:'down'}" lay-filter="down">
    <thead>
    <tr>
      <th lay-data="{field:'id', checkbox:true}">选择</th>
      <th lay-data="{field:'seq', width:60, sort:true}">ID</th>
      <th lay-data="{field:'name', width:100}">名称</th>
      <th lay-data="{field:'path', width:100}">路径</th>
      <th lay-data="{field:'sort', width:100, sort:true}">排序</th>
      <th lay-data="{fixed: 'right', width:250, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="edit"><i class="layui-icon">&#xe642;</i>编辑</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" lay-event="drop"><i class="layui-icon">&#xe640;</i>删除</a>
</script>
<!-- 增加/修改页面 -->
<script type="text/html" id="update">
  <div class="form">
    <form id="down" class="layui-form layui-form-pane">
      <div class="layui-form-item" pane>
        <label class="layui-form-label">分类</label>
        <div class="layui-input-inline" style="width: 240px;">
          <select name="type" lay-filter="type">
            <option value="home">首页</option>
            <option value="product">产品页</option>
            <option value="info">信息页</option>
          </select>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">图片</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="hidden" name="image">
          <button type="button" id="upload" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传图片</button>
        </div>
        <div class="layui-form-mid layui-word-aux"><img id="img" src="" alt="Banner图片" height="64"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">链接地址</label>
        <div class="layui-input-inline" style="width: 480px;">
          <input type="text" class="layui-input" name="url" placeholder="Banner链接地址" autocomplete="off" maxlength="120">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">排序</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="sort" placeholder="Banner排序" autocomplete="off" min="0" max="65535">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label"></label>
        <div class="layui-input-inline" style="width: 360px;">
          <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="down">提交</button>
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
    </form>
  </div>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'layer', 'upload', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            table = layui.table,
            upload = layui.upload,
            element = layui.element;

        // 监听表格工具条事件
        table.on('tool(down)', function (o) {
            var data = o.data,
                e = o.event;

            switch (e) {
                case 'edit':
                    layer.open({
                        type:1,
                        skin:'layui-layer-molv',
                        area:['760px', '500px'],
                        title:'修改',
                        content:$('#update').html(),
                        success:function (el, id) {
                            $('option').each(function () {
                                if (data.type === $(this).text()) {
                                    $(this).prop('selected', true);
                                }
                            });
                            $('input[name=sort]').val(data.sort);
                            $('input[name=image]').val(data.image);
                            $('#img').attr('src', '<?php echo $host; ?>/' + data.image);
                            $('#submit').text('修改');
                            uploadRender();
                            form.render().on('submit(down)', function (o) {
                                var c = check(o.field);
                                if (true !== c) {
                                    layer.msg(c, {icon:2, anim:6});
                                    return false;
                                }
                                $.ajax({
                                    url:'<?php echo $path; ?>/down.php',
                                    data:$('#down').serialize() + '&action=edit&unique=' + data.id,
                                    type:'POST',
                                    dataType:'json',
                                    success:function (data) {
                                        if (data.code) {
                                            layer.close(id);
                                            $('.layui-laypage-btn').click();
                                            layer.msg('修改成功', {icon:1});
                                        } else {
                                            layer.msg(data.err, {icon:2});
                                        }
                                    }
                                });
                                return false;
                            });
                        }
                    });
                    break;
                case 'drop':
                    layer.confirm('确认删除？删除后无法恢复', function (id) {
                        layer.close(id);
                        $.ajax({
                            url:'<?php echo $path; ?>/down.php',
                            data:'action=drop&unique=' + data.id,
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    o.del();
                                    layer.msg('删除成功', {icon:1});
                                } else {
                                    layer.msg('删除失败', {icon:2});
                                }
                            }
                        });
                    });
                    break;
                case 'show':
                case 'on':
                    $.ajax({
                        url:'<?php echo $path; ?>/down.php',
                        data:{
                            action:e,
                            unique:data.id
                        },
                        type:'POST',
                        dataType:'json',
                        success:function (data) {
                            var el = o.tr.find('td[data-field=' + e + ']').find('input:checkbox');
                            if (data.stat !== el.prop('checked')) {
                                el.click();
                            }
                            if (!data.code) {
                                layer.msg(data.err, {icon:2});
                            }
                        }
                    });
                default:break;
            }
        });

        $(document).on('click', '#insert', function () {
            // 添加
            layer.open({
                type:1,
                skin:'layui-layer-lan',
                area:['760px', '500px'],
                title:'添加',
                content:$('#update').html(),
                success:function (el, id) {
                    $('input[name=sort]').val('65535');
                    $('#submit').text('添加');
                    form.render().on('submit(down)', function (o) {
                        var c = check(o.field);
                        if (true !== c) {
                            layer.msg(c, {icon:2, anim:6});
                            return false;
                        }
                        uploadRender();
                        $.ajax({
                            url:o.form.action,
                            data:$('#down').serialize() + '&action=insert',
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    layer.close(id);
                                    $('.layui-laypage-btn').click();
                                    layer.msg('添加成功', {icon:1});
                                } else {
                                    layer.msg(data.err, {icon:2});
                                }
                            }
                        });
                        return false;
                    });
                }
            });
        }).on('click', '#delete', function () {
            // 批量删除
            layer.confirm('确认批量删除？请仔细确认，删除后无法还原', function (id) {
                layer.close(id);
                var data = table.checkStatus('down').data,
                    unique = [];
                for (var i in data) {
                    if (data.hasOwnProperty(i)) {
                        unique[i] = data[i].id;
                    }
                }
                $.ajax({
                    url:location.href,
                    data:'unique=' + unique.join(', ') + '&action=delete',
                    type:'POST',
                    dataType:'json',
                    success: function (data) {
                        if (data.code) {
                            $('.layui-laypage-btn').click();
                            layer.msg('批量删除成功', {icon: 1});
                        } else {
                            layer.msg('批量删除失败', {icon: 2});
                        }
                    }
                });
            });
        }).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            $('.layui-laypage-btn').click();
        });

        // 渲染上传按钮
        function uploadRender() {
            upload.render({
                elem:'#upload',
                url:'<?php echo $path; ?>/down.php',
                data:{action:'upload'},
                accept:'images',
                size:2000,
                done:function (data) {
                    if (data.code) {
                        $('input[name=img]').val(data.path);
                        $('#img').down('src', '<?php echo $host; ?>/' + data.path + '?rand=' + Math.random());
                        layer.msg('上传成功', {icon: 1});
                    } else {
                        layer.msg(data.err, {icon: 2});
                    }
                }
            });
        }

        // 提交检查
        function check(f) {
            if ('' === f.type) {
                return '属性类别不能为空';
            }
            if ('' === f.name) {
                return '属性名称不能为空';
            }
            if (parseInt(f.sort) < 0) {
                return '属性排序不能小于0';
            }
            return true;
        }
    });
</script>
</body>
</html>