<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $slide
 * @var string $host
 * @var string $path
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>后台管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    .info {
      text-align: center;
    }
    .body {
      position: relative;
      top: 6px;
      left: 42%;
      height: 54px;
      width: 210px;
      overflow: hidden;
      box-sizing: border-box;
    }
    iframe {
      border: none;
      width: 100%;
      height: 100%;
      position: absolute;
      top: 0;
      bottom: 0;
      left: 0;
      right: 0;
    }
  </style>
</head>
<body>
<div class="layui-layout layui-layout-admin">
  <!-- 头部 -->
  <div class="layui-header">
    <!-- 系统logo -->
    <div class="layui-logo">
      <a href="javascript:location.reload();"><img src="<?php echo $path; ?>/img/logo-m.png" alt="黑蚂蚁内容管理系统"></a>
    </div>
    <!-- 头部左侧导航 -->
    <div class="body">
      <iframe src="http://www.sem-cms.com/authorization/"></iframe>
    </div>
    <!-- 头部右侧导航 -->
    <ul class="layui-nav layui-layout-right">

      <li class="layui-nav-item">
        <a href="javascript:">当前登录地点: [<span id="city"></span>]</a>
        <dl class="layui-nav-child">
          <dd><a href="javascript:">当前登录IP: [<span id="ip"></span>]</a></dd>
        </dl>
      </li>
      <li class="layui-nav-item">
        <a href="javascript:"><img class="layui-nav-img" src="<?php echo $host; ?>/file/profile/administrator.jpg" alt="用户头像">SEM-CMS管理员</a>
        <dl class="layui-nav-child">
          <dd class="info"><a href="<?php echo $host; ?>">查看前台</a></dd>
          <dd class="info"><a href="http://www.sem-cms.com/help/">帮助文档</a></dd>
          <dd class="info"><a href="<?php echo $path; ?>/logout.php">退出登录</a></dd>
        </dl>
      </li>
    </ul>
  </div>

  <!-- 菜单 -->
  <div class="layui-side layui-bg-cyan">
    <div class="layui-side-scroll">
      <?php echo $slide; ?>
    </div>
  </div>

  <!-- 内容 -->
  <div class="layui-body">
    <iframe id="body" src="<?php echo $path; ?>/main.php"></iframe>
  </div>

  <!-- 底部 -->
  <div class="layui-footer">
    <span id="copyright">&copy;黑蚂蚁SEMCMS - V<?php echo $version; ?></span>
  </div>
</div>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script src="http://pv.sohu.com/cityjson?ie=utf-8"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'layer', 'element'], function () {
        var $ = layui.$,
            layer = layui.layer;

        <?php if (null != $err): ?>
        // 显示提示
        layer.msg('<?php echo $err; ?>', {icon: 2});
        <?php endif; ?>

        // 登录地点
	    try {
		    $('#city').text(returnCitySN.cname);
		    $('#ip').text(returnCitySN.cip);
		    returnCitySN = undefined;
	    } catch (e) {}

        // 二级菜单
        $('.layui-side').on('click', 'a', function (e) {
            // 阻止默认行为
            e.preventDefault();
        }).on('click', '.layui-nav-child dd', function () {
            // 选中样式互斥
            $('.layui-nav-child dd').removeClass('layui-this');
            $(this).addClass('layui-this');

            // 点击变更内容
            $('#body').prop('src', $(this).children().prop('href'));
        });

        // 登出
        $('#logout').click(function () {
            $.ajax({
                url: '<?php echo $path; ?>',
                data: {action: 'logout'},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    layer.msg(data.msg, {icon: 2});
                },
                error: function () {
                    layer.msg('退出失败', {icon: 2});
                }
            });
            return false;
        })
    });
</script>
</body>
</html>