<?php
/**
 * 预定义变量
 *
 * @var string     $crumb
 * @var string     $host
 * @var string     $path
 * @var string     $select
 * @var array      $info
 * @var \sc\Helper $hel
 * @var string     $msg
 * @var string     $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>信息管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      height: 30px;
      margin: 10px;
    }
    .breadcrumb {
      margin: 10px;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 5px 15px;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
</div>
<div class="form">
  <form id="info" class="layui-form">
    <div class="layui-form-item" pane>
      <label class="layui-form-label">分类</label>
      <div class="layui-input-inline" style="min-width: 240px;">
        <?php echo $select; ?>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">标题<span style="color:#FF0000;">*</span></label>
      <div class="layui-input-inline" style="width: 360px;">
        <input type="text" class="layui-input" name="name" placeholder="信息标题" autocomplete="off" maxlength="240" value="<?php echo $info ? $info['name'] : ''; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">URL</label>
      <div class="layui-input-inline" style="width: 360px;">
        <input type="text" class="layui-input" name="url" placeholder="自定义URL" autocomplete="off" maxlength="240" value="<?php echo $info ? $info['url'] : ''; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">关键字</label>
      <div class="layui-input-inline" style="width: 480px;">
        <input type="text" class="layui-input" name="kwd" placeholder="页面关键字(keyword标签)" autocomplete="off" maxlength="500" value="<?php echo $info ? $info['kwd'] : ''; ?>">
      </div>
      <div class="layui-form-mid layui-word-aux">多条使用英文逗号(,)分割</div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">描述</label>
      <div class="layui-input-inline" style="width: 480px;">
        <textarea class="layui-textarea" name="des" cols="30" rows="2" placeholder="网页描述(description标签)" maxlength="1000"><?php echo $info ? $info['des'] : ''; ?></textarea>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">标识图</label>
      <div class="layui-input-inline" style="width: 120px;">
        <input type="hidden" name="img" value="<?php echo $info ? $info['img'] : ''; ?>">
        <button type="button" id="upload" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传标识图</button>
      </div>
      <div class="layui-form-mid layui-word-aux"><img id="img" src="<?php echo $info && $info['img'] != '' ? $hel->to($info['img']) : 'img/w.gif'; ?>" alt="信息标识图" height="82"></div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">详细内容</label>
      <div class="layui-input-inline" style="width: 1000px;">
        <textarea class="ckeditor" name="details" cols="30" rows="15" placeholder="信息页面详细内容"><?php echo $info ? $info['details'] : ''; ?></textarea>
      </div>
    </div>
	  <div class="layui-form-item" pane>
		  <label class="layui-form-label">发布人<span style="color:#FF0000;">*</span></label>
		  <div class="layui-input-inline" style="width: 240px;">
			  <input type="text" class="layui-input" name="auth" placeholder="发布人" autocomplete="off" maxlength="240" value="<?php echo $info ? $info['auth'] : ''; ?>">
		  </div>
	  </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">显示信息</label>
      <div class="layui-input-block">
        <input class="layui-form-switch" type="checkbox" name="on" title="点击启用/停用信息" lay-skin="switch" lay-text="显示|关闭" <?php echo $info ? (1 == $info['on'] ? 'checked' : '') : 'checked' ?>>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">排序</label>
      <div class="layui-input-inline" style="width: 120px;">
        <input type="number" class="layui-input" name="sort" placeholder="分类排序序号" autocomplete="off" min="0" max="65535" value="<?php echo $info ? $info['sort'] : '65535'; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label"></label>
      <div class="layui-input-inline" style="width: 120px;">
        <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="info">提交</button>
      </div>
    </div>
  </form>
</div>
<script src="<?php echo $path; ?>/vendor/ckeditor/ckeditor.js"></script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'layer', 'upload', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            upload = layui.upload,
            element = layui.element;

        // 异步提交
        form.on('submit(info)', function (o) {
            // 检查提交内容
            var f = o.field;
            if ('' === f.name) {
                layer.msg('信息标题不能为空', {icon:2, anim:6});
                return false;
            }
            if (/^[\d.]+$/.test(f.url)) {
                layer.msg('信息URL不能为纯数字', {icon:2, anim:6});
                return false;
            }
            f.sort = parseInt(f.sort);
            if (f.sort < 0) {
                layer.msg('信息排序必须大于0', {icon:2, anim:6});
                return false;
            }
            // 禁用提交按钮
            if ('layui-btn layui-btn-disabled' !== o.elem.className) {
                o.elem.className = 'layui-btn layui-btn-disabled';
            } else {
                return false;
            }
            // 异步更新CKEditor内容
            for (var instance in CKEDITOR.instances) {
                if (CKEDITOR.instances.hasOwnProperty(instance)) {
                    CKEDITOR.instances[instance].updateElement();
                }
            }
            $.ajax({
                url:'<?php echo $path; ?>/info.php?lang=<?php echo $lang; ?>',
                data:$('#info').serialize() + '&action=<?php echo $info ? 'edit' : 'insert'; ?>&unique=<?php echo $info ? $info['id'] : -1; ?>',
                type:'POST',
                dataType:'json',
                success:function (data) {
                    if (data.code) {
                        layer.msg('<?php echo $info ? '修改' : '添加'; ?>成功', {icon:1});
                        setTimeout(function () {
                            location.href = data.path;
                        }, 3000);
                    } else {
                        layer.msg(data.err, {icon:2});
                        o.elem.className = 'layui-btn';
                    }
                }
            });
            return false;
        });

        $(document).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            location.reload();
        });

        // 渲染上传按钮
        upload.render({
            elem:'#upload',
            url:'<?php echo $path; ?>/info.php?lang=<?php echo $lang; ?>',
            data:{
                action:'upload',
                unique:<?php echo $info ? $info['id'] : -1; ?>
            },
            accept:'images',
            size:2000,
            done:function (data) {
                if (data.code) {
                    $('input[name=img]').val(data.path);
                    $('#img').attr('src', '<?php echo $host; ?>/' + data.path + '?rand=' + Math.random());
                    layer.msg('上传成功', {icon: 1});
                } else {
                    layer.msg(data.err, {icon: 2});
                }
            }
        });
    });
</script>
</body>
</html>