<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $select
 * @var string $host
 * @var string $path
 * @var string $lang
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="icon" type="image/png" sizes="192x192" href="<?php echo $host; ?>/file/icon.ico">
  <title>信息管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 0 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 5px 20px;
    }
    .operation {
      width: 30%;
      height: 30px;
      margin: 10px 0;
    }
    .search {
      position: absolute;
      top: 50px;
      right: 0;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
  <div class="operation">
    <button id="delete" class="layui-btn layui-btn-danger layui-btn-small">
      <i class="layui-icon">&#xe640;</i>批量删除
    </button>
    <button id="insert" class="layui-btn layui-btn-normal layui-btn-small">
      <i class="layui-icon">&#xe608;</i>添加
    </button>
  </div>
  <div class="search">
    <form id="search" class="layui-form layui-form-pane">
      <div class="layui-input-inline" style="width: 240px;">
          <?php echo $select; ?>
      </div>
      <div class="layui-input-inline" style="width: 360px;">
        <input type="text" class="layui-input" name="keyword" placeholder="信息标题" autocomplete="off" maxlength="500">
      </div>
      <div class="layui-input-inline" style="width: 120px;">
        <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="search">筛选</button>
      </div>
    </form>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/info.php?lang=<?php echo $lang; ?>', method:'post', where:{action:'list'}, page:true, limit:10, id:'info'}" lay-filter="info">
    <thead>
    <tr>
      <th lay-data="{field:'id', checkbox:true}">选择</th>
      <th lay-data="{field:'seq', width:80, sort:true}">ID</th>
      <th lay-data="{field:'name', width:160}">名称</th>
      <th lay-data="{field:'on', width:100, event:'on'}">显示</th>
      <th lay-data="{field:'time', width:160, sort:true}">修改时间</th>
      <th lay-data="{field:'sort', width:120, sort:true}">排序</th>
      <th lay-data="{fixed: 'right', width:190, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="edit"><i class="layui-icon">&#xe642;</i>编辑</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" lay-event="drop"><i class="layui-icon">&#xe640;</i>删除</a>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'layer', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            table = layui.table,
            element = layui.element;

        // 监听表格工具条事件
        table.on('tool(info)', function (o) {
            var data = o.data,
                tr = o.tr,
                e = o.event;

            switch (e) {
                case 'edit':
                    location.href = '<?php echo $path; ?>/info.php?lang=<?php echo $lang; ?>&action=edit&unique=' + data.id;
                    break;
                case 'drop':
                    layer.confirm('确认删除？删除后无法恢复', function (id) {
                        layer.close(id);
                        $.ajax({
                            url:'<?php echo $path; ?>/info.php?lang=<?php echo $lang; ?>',
                            data:{
                                action:'drop',
                                unique:data.id
                            },
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    o.del();
                                    layer.msg('删除成功', {icon:1});
                                } else {
                                    layer.msg('删除失败', {icon:2});
                                }
                            }
                        });
                    });
                    break;
                case 'on':
                    $.ajax({
                        url:'<?php echo $path; ?>/info.php?lang=<?php echo $lang; ?>',
                        data:{
                            action:'on',
                            unique:data.id
                        },
                        type:'POST',
                        dataType:'json',
                        success:function (data) {
                            var el = tr.find('td[data-field=on]').find('input:checkbox');
                            if (data.stat !== el.prop('checked')) {
                                el.click();
                            }
                            if (!data.code) {
                                layer.msg(data.err, {icon:2});
                            }
                        }
                    });
                    break;
                default:break;
            }
        });

        // 监听查找点击
        form.on('submit(search)', function (o) {
            table.reload('info', {
                url:'<?php echo $path ?>/info.php?lang=<?php echo $lang; ?>&'+$('#search').serialize(),
                method:'post',
                where:{action:'list'},
                page:true,
                limit:10,
                id:'info'
            });
            return false;
        });

        $(document).on('click', '#insert', function () {
            location.href = '<?php echo $path; ?>/info.php?lang=<?php echo $lang; ?>&action=insert';
        }).on('click', '#delete', function () {
            // 批量删除
            layer.confirm('确认批量删除？请仔细确认，删除后无法还原', function (id) {
                layer.close(id);
                var data = table.checkStatus('info').data,
                    unique = [];
                for (var i in data) {
                    if (data.hasOwnProperty(i)) {
                        unique[i] = data[i].id;
                    }
                }
                $.ajax({
                    url: '<?php echo $path; ?>/info.php?lang=<?php echo $lang; ?>',
                    data: {
                        action:'delete',
                        unique:unique.join(', ')
                    },
                    type: 'POST',
                    dataType: 'json',
                    success: function (data) {
                        if (data.code) {
                            $('.layui-laypage-btn').click();
                            layer.msg('批量删除成功', {icon: 1});
                        } else {
                            layer.msg('批量删除失败', {icon: 2});
                        }
                    }
                });
            });
        }).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            location.reload();
        });
    });
</script>
</body>
</html>