<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>折扣管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 15px 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 25px 20px;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/lang.php', method:'post', where:{action:'list'}, page:true, limit:10, id:'lang'}" lay-filter="lang">
    <thead>
    <tr>
      <th lay-data="{checkbox:true}">选择</th>
      <th lay-data="{field:'seq', width:80, sort:true}">ID</th>
      <th lay-data="{field:'name', width:120}">名称</th>
      <th lay-data="{field:'title', width:120}">翻译</th>
      <th lay-data="{field:'word', width:60}">缩写</th>
      <th lay-data="{field:'flag', width:120}">国旗</th>
      <th lay-data="{field:'host', width:160}">域名</th>
      <th lay-data="{field:'main', width:100, event:'main'}">主目录</th>
      <th lay-data="{field:'on', width:100, event:'on'}">显示</th>
      <th lay-data="{field:'sort', width:100}">排序</th>
      <th lay-data="{fixed: 'right', width:220, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="edit"><i class="layui-icon">&#xe642;</i>编辑</a>
</script>
<!-- 增加/修改页面 -->
<script type="text/html" id="update">
  <div class="form">
    <form id="lang" class="layui-form layui-form-pane">
      <div class="layui-form-item" pane>
        <label class="layui-form-label">名称<span style="color:#FF0000;">*</span></label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="name" placeholder="语言名称" autocomplete="off" maxlength="30">
        </div>
        <div class="layui-form-mid layui-word-aux">名称长度请勿超过30个字符</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">翻译<span style="color:#FF0000;">*</span></label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="title" placeholder="语言对应原文翻译" autocomplete="off" maxlength="30">
        </div>
        <div class="layui-form-mid layui-word-aux">翻译长度请勿超过30个字符</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">缩写<span style="color:#FF0000;">*</span></label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="text" class="layui-input" name="word" placeholder="国家缩写" autocomplete="off" maxlength="3">
        </div>
        <div class="layui-form-mid layui-word-aux">国家缩写请使用标准二位/三位码</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">国旗</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="hidden" name="flag">
          <button type="button" id="upload" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传图片</button>
        </div>
        <div class="layui-form-mid layui-word-aux"><img id="img" src="" alt="产品属性图片"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">域名</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="host" placeholder="绑定域名" autocomplete="off" maxlength="127">
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">排序</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="sort" placeholder="语言排序" autocomplete="off" min="0" max="65535">
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">主目录</label>
        <div class="layui-input-block" style="width: 120px;">
          <input class="layui-form-switch" type="checkbox" name="main" title="点击切换主目录" lay-skin="switch" lay-text="启用|关闭">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">显示</label>
        <div class="layui-input-block" style="width: 120px;">
          <input class="layui-form-switch" type="checkbox" name="on" title="点击显示语种" lay-skin="switch" lay-text="显示|关闭">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label"></label>
        <div class="layui-input-inline" style="width: 360px;">
          <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="lang">提交</button>
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
    </form>
  </div>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'layer', 'upload', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            table = layui.table,
            upload = layui.upload,
            element = layui.element;

        // 监听表格工具条事件
        table.on('tool(lang)', function (o) {
            var data = o.data,
                tr = o.tr,
                e = o.event;

            switch (e) {
                case 'edit':
                    layer.open({
                        type:1,
                        skin:'layui-layer-molv',
                        area:['760px', '500px'],
                        title:'修改',
                        content:$('#update').html(),
                        success:function (el, id) {
                            $('input[name=name]').val(data.name);
                            $('input[name=title]').val(data.title);
                            $('input[name=word]').val(data.word);
                            $('input[name=host]').val(data.host);
                            $('input[name=sort]').val(data.sort);
                            var src = tr.find('img').attr('src');
                            $('#img').attr('src', src);
                            $('input[name=flag]').val(src.substr(<?php echo strlen($host)+1; ?>));
                            $('input[name=main]').prop('checked', tr.find('input:checkbox:eq(1)').prop('checked'));
                            $('input[name=on]').prop('checked', tr.find('input:checkbox:eq(2)').prop('checked'));
                            $('#upload').val(data.word);
                            $('#submit').text('修改');
                            uploadRender();
                            form.render().on('submit(lang)', function (o) {
                                var c = check(o.field);
                                if (true !== c) {
                                    layer.msg(c, {icon:2, anim:6});
                                    return false;
                                }
                                $.ajax({
                                    url:'<?php echo $path; ?>/lang.php',
                                    data:$('#lang').serialize() + '&action=edit&unique=' + data.word,
                                    type:'POST',
                                    dataType:'json',
                                    success:function (data) {
                                        if (data.code) {
                                            layer.close(id);
                                            $('.layui-laypage-btn').click();
                                            layer.msg('修改成功', {icon:1});
                                        } else {
                                            layer.msg(data.err, {icon:2});
                                        }
                                    }
                                });
                                return false;
                            });
                        }
                    });
                    break;
                case 'main':
                    $.ajax({
                        url:'<?php echo $path; ?>/lang.php',
                        data:{
                            action:'main',
                            unique:data.word
                        },
                        type:'POST',
                        dataType:'json',
                        success:function (data) {console.log(data);
                            if (data.code) {
                                $('#refresh').click();
                            } else {
                                layer.msg(data.err, {icon:2});
                            }
                        }
                    });
                    break;
	            case 'on':
		            $.ajax({
			            url:'<?php echo $path; ?>/lang.php',
			            data:{
				            action:e,
				            unique:data.word
			            },
			            type:'POST',
			            dataType:'json',
			            success:function (data) {
				            var el = o.tr.find('td[data-field=' + e + ']').find('input:checkbox');
				            if (data.stat !== el.prop('checked')) {
					            el.click();
				            }
				            if (data.code) {
					            $('.layui-laypage-btn').click();
				            } else {
					            layer.msg(data.err, {icon:2});
				            }
			            }
		            });
		            break;
                default:break;
            }
        });

        $(document).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            $('.layui-laypage-btn').click();
        });

        // 渲染上传按钮
        function uploadRender() {
            upload.render({
                elem:'#upload',
                url:'<?php echo $path; ?>/lang.php',
                data:{
                    action:'upload',
                    unique:$('#upload').val()
                },
                size:2000,
                done:function (data) {
                    if (data.code) {
                        $('input[name=flag]').val(data.path);
                        $('#img').attr('src', '<?php echo $host; ?>/' + data.path + '?rand=' + Math.random());
                        layer.msg('上传成功', {icon: 1});
                    } else {
                        layer.msg(data.err, {icon: 2});
                    }
                }
            });
        }

        // 提交检查
        function check(f) {
            if ('' === f.name) {
                return '语言名称不能为空';
            }
            if ('' === f.word) {
                return '国家缩写不能为空';
            }
            if (parseInt(f.sort) < 0) {
                return '语言排序必须大于0';
            }
            return true;
        }
    });
</script>
</body>
</html>