<?php
/**
 * 预定义变量
 *
 * @var string $path
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>后台登录</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    body {
      background: url('<?php echo $path; ?>/img/background.jpg');
    }

    .head {
      background: url('<?php echo $path; ?>/img/logo-b.png') center no-repeat;
      width: 100%;
      height: 200px;
      text-align: center;
    }

    .form {
      width: 400px;
      margin: 100px auto;
    }

    #remember {
      width: 100%;
      text-align: right;
    }

    #submit {
      width: 100%;
      text-align: center;
    }
  </style>
</head>
<body>
<div class="head"></div>
<div class="form">
  <form id="login" class="layui-form layui-form-pane">
    <div class="layui-form-item" pane  id="login_pan_1">
      <label class="layui-form-label " id="account">账号</label>
      <div class="layui-input-block" id="layui-input-block-1">
        <input type="text" class="layui-input" name="username" placeholder="管理员账号" autocomplete="off" lay-verify="required">
      </div>
    </div>
    <div class="layui-form-item" pane id="login_pan_2">
      <label class="layui-form-label" id="a_pwd">密码</label>
      <div class="layui-input-block" id="layui-input-block-2">
        <input type="password" class="layui-input" name="password" placeholder="管理员密码" autocomplete="off" lay-verify="required">
      </div>
    </div>
    <div class="layui-form-item">
      <div id="remember" class="layui-input-inline">
        <input type="checkbox" name="remember" title="记住我" value="1">
      </div>
    </div>
    <div class="layui-form-item">
      <div id="submit" class="layui-input-inline">
        <button class="layui-btn layui-btn-warm" lay-submit lay-filter="login">登录</button>
      </div>
    </div>
  </form>
</div>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'layer'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer;

        <?php if (null != $msg): ?>
        // 显示提示
        layer.msg('<?php echo $msg; ?>', {icon: 1});
        <?php endif; ?>
        <?php if (null != $err): ?>
        // 显示错误
        layer.msg('<?php echo $err; ?>', {icon: 2});
        <?php endif; ?>

        // 异步登录提交
        form.on('submit(login)', function (el) {
            $.ajax({
                url: el.form.action,
                data: $('#login').serialize(),
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    if (undefined === data.url) {
                        // 登录失败
                        layer.msg(data.err, {icon: 2});
                    } else {
                        // 登录成功
                        location.href = data.url;
                    }
                }
            });
            return false;
        });
    });
</script>
</body>
</html>