<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $lang
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>媒体管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 0 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 15px 20px;
    }
    .operation {
      height: 30px;
      margin: 10px 0;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
  <div class="operation">
    <button id="delete" class="layui-btn layui-btn-danger layui-btn-small">
      <i class="layui-icon">&#xe640;</i>批量删除
    </button>
    <button id="insert" class="layui-btn layui-btn-normal layui-btn-small">
      <i class="layui-icon">&#xe608;</i>添加
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/media.php?lang=<?php echo $lang; ?>', method:'post', where:{action:'list'}, page:true, limit:10, id:'media'}" lay-filter="media">
    <thead>
    <tr>
      <th lay-data="{field:'id', checkbox:true}">选择</th>
      <th lay-data="{field:'seq', width:80, sort:true}">ID</th>
      <th lay-data="{field:'name', width:140}">标题</th>
      <th lay-data="{field:'type', width:80}">类型</th>
      <th lay-data="{field:'cont', width:180}">内容</th>
      <th lay-data="{field:'on', width:100, event:'on'}">显示</th>
      <th lay-data="{field:'sort', width:80, sort:true}">排序</th>
      <th lay-data="{fixed: 'right', width:190, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="edit"><i class="layui-icon">&#xe642;</i>编辑</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" lay-event="drop"><i class="layui-icon">&#xe640;</i>删除</a>
</script>
<!-- 增加/修改页面 -->
<script type="text/html" id="update">
  <div class="form">
    <form id="media" class="layui-form layui-form-pane">
      <div class="layui-form-item" pane>
        <label class="layui-form-label">分类</label>
        <div id="category" class="layui-input-inline" style="min-width: 360px;">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">标题<span style="color:#FF0000;">*</span></label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="name" placeholder="文件标题" autocomplete="off" maxlength="120">
        </div>
        <div class="layui-form-mid layui-word-aux">标题长度请勿超过240个字符</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">类型</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="radio" name="type" value="F" title="文件" lay-filter="media">
          <input type="radio" name="type" value="I" title="图片" lay-filter="media">
          <input type="radio" name="type" value="V" title="视频" lay-filter="media">
        </div>
        <div class="layui-form-mid layui-word-aux">请先选择类型再上传文件</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label"></label>
        <div id="content" class="layui-input-inline">
        </div>
        <div class="layui-form-mid layui-word-aux"><img id="image" src="" alt="图片" height="182"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">显示</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="checkbox" name="on" title="点击显示/关闭文件" lay-skin="switch" lay-text="显示|关闭">
        </div>
        <div class="layui-form-mid layui-word-aux">点击开启/关闭文件显示</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">排序</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="sort" placeholder="文件排序" autocomplete="off" min="0" max="65535">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label"></label>
        <div class="layui-input-inline" style="width: 360px;">
          <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="media">提交</button>
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
    </form>
  </div>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'layer', 'upload', 'element', 'laypage'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            table = layui.table,
            upload = layui.upload,
            element = layui.element,
            laypage = layui.laypage;

        // 监听表格工具条事件
        table.on('tool(media)', function (o) {
            var data = o.data,
                tr = o.tr,
                e = o.event;

            switch (e) {
                case 'edit':
                    layer.open({
                        type:1,
                        skin:'layui-layer-molv',
                        area:['760px', '500px'],
                        title:'修改',
                        content:$('#update').html(),
                        success:function (el, id) {
                            $.ajax({
                                url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                                data:{action:'cate'},
                                type:'POST',
                                async:false,
                                dataType:'json',
                                success:function (data) {
                                    $('#category').html(data.html);
                                }
                            });
                            $('option[value='+data.cate+']').prop('selected', true);
                            $('input[name=name]').val(data.name);
                            if ('文件' === data.type) {
                                $('input:radio[value=F]').click();
	                            updateFile('F', $(data.cont).attr('href').substr(<?php echo strlen($host)+1; ?>));
                            } else if ('视频' === data.type) {
	                            $('input:radio[value=V]').click();
                                updateFile('V', $(data.cont).text());
                            } else {
	                            $('input:radio[value=I]').click();
                                updateFile('I', $(data.cont).attr('src').substr(<?php echo strlen($host)+1; ?>));
                            }
                            if (data.on) {
                                $('input[name=on]').prop('checked', true);
                            }
                            $('input[name=sort]').val(data.sort);
                            $('#submit').text('修改');
                            form.render().on('radio(media)', function (o) {
                                updateFile(o.value);
                            }).on('submit(media)', function (o) {
                                var f = o.field;
                                if ('' === f.name) {
                                    layer.msg('文件标题不能为空', {icon:2, anim:6});
                                    return false;
                                }
                                f.sort = parseInt(f.sort);
                                if (f.sort < 0) {
                                    layer.msg('文件排序必须大于0', {icon:2, anim:6});
                                    return false;
                                }
                                $.ajax({
                                    url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                                    data:$('#media').serialize() + '&action=edit&unique=' + data.id,
                                    type:'POST',
                                    dataType:'json',
                                    success:function (data) {
                                        if (data.code) {
                                            layer.close(id);
                                            $('.layui-laypage-btn').click();
                                            layer.msg('修改成功', {icon:1});
                                        } else {
                                            layer.msg(data.err, {icon:2});
                                        }
                                    }
                                });
                                return false;
                            });
                        }
                    });
                    break;
                case 'drop':
                    layer.confirm('确认删除？删除后无法恢复', function (id) {
                        layer.close(id);
                        $.ajax({
                            url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                            data:'action=drop&unique=' + data.id,
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    o.del();
                                    layer.msg('删除成功', {icon:1});
                                } else {
                                    layer.msg('删除失败', {icon:2});
                                }
                            }
                        });
                    });
                    break;
                case 'on':
                    $.ajax({
                        url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                        data:{
                            action:'on',
                            unique:data.id
                        },
                        type:'POST',
                        dataType:'json',
                        success:function (data) {
                            var el = tr.find('td[data-field=on]').find('input:checkbox');
                            if (data.stat !== el.prop('checked')) {
                                el.click();
                            }
                            if (!data.code) {
                                layer.msg(data.err, {icon:2});
                            }
                        }
                    });
                    break;
                default:break;
            }
        });

        $(document).on('click', '#insert', function () {
            // 添加
            layer.open({
                type:1,
                skin:'layui-layer-lan',
                area:['760px', '500px'],
                title:'添加',
                content:$('#update').html(),
                success:function (el, id) {
                    $.ajax({
                        url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                        data:{action:'cate'},
                        type:'POST',
                        async:false,
                        dataType:'json',
                        success:function (data) {
                            $('#category').html(data.html);
                        }
                    });
                    $('input[name=on]').prop('checked', true);
                    $('input[name=sort]').val(65535);
                    updateFile('I');
                    $('#submit').text('修改');
                    // 渲染上传按钮
                    uploadRender('image');
                    form.render().on('radio(media)', function (o) {
                        updateFile(o.value);
                    }).on('submit(media)', function (o) {
                        var f = o.field;
                        if ('' === f.name) {
                            layer.msg('文件标题不能为空', {icon:2, anim:6});
                            return false;
                        }
                        f.sort = parseInt(f.sort);
                        if (f.sort < 0) {
                            layer.msg('文件排序必须大于0', {icon:2, anim:6});
                            return false;
                        }
                        $.ajax({
                            url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                            data:$('#media').serialize() + '&action=insert',
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    layer.close(id);
                                    $('.layui-laypage-btn').click();
                                    layer.msg('添加成功', {icon:1});
                                } else {
                                    layer.msg(data.err, {icon:2});
                                }
                            }
                        });
                        return false;
                    });
                }
            });
        }).on('click', '#delete', function () {
            // 批量删除
            layer.confirm('确认批量删除？请仔细确认，删除后无法还原', function (id) {
                layer.close(id);
                var data = table.checkStatus('media').data,
                    unique = [];
                for (var i in data) {
                    if (data.hasOwnProperty(i)) {
                        unique[i] = data[i].id;
                    }
                }
                $.ajax({
                    url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                    data:'unique=' + unique.join(', ') + '&action=delete',
                    type:'POST',
                    dataType:'json',
                    success:function (data) {
                        if (data.code) {
                            $('.layui-laypage-btn').click();
                            layer.msg('批量删除成功', {icon: 1});
                        } else {
                            layer.msg('批量删除失败', {icon: 2});
                        }
                    }
                });
            });
        }).on('click', '#file-select,#image-select', function () {
            var type;
            if ('#file-select' === $(this).prop('id')) {
                type = 'file';
            } else {
                type = 'image';
            }
            layer.open({
                type:1,
                skin:'layui-layer-lan',
                area:['760px', '500px'],
                title:'选择' + 'file' === type ? '文件' : '图片',
                content:$('#window').html(),
                success:function (id, el) {
                    $.ajax({
                        url:'<?php echo $path; ?>/media.php?lang=<?php echo $lang; ?>',
                        data:{action:'number'},
                        type:'POST',
                        dataType:'json',
                        success:function (data) {
                            laypage.render({
                                elem:'window-page',
                                count:data.number,
                                limit:10,
                                jump:function (o) {
                                    $('#window-select').html('');
                                    $.ajax({
                                        url:'<?php echo $path; ?>/file.php',
                                        data:{
                                            action:'select',
                                            limit:10,
                                            page:o.curr,
                                            type:'file' === type ? 'F' : 'I'
                                        },
                                        type:'POST',
                                        dataType:'json',
                                        success:function (data) {
                                            if ('file' === type) {
                                                for (var i in data) {
                                                    if (data.hasOwnProperty(i)) {
                                                        $('#window-select').append('<div class="window-file-select"><span title="' + data[i].path + '">' + data[i].path.substr(data[i].path.lastIndexOf('/') + 1) + '</span></div>');
                                                    }
                                                }
                                            } else {
                                                for (var i in data) {
                                                    if (data.hasOwnProperty(i)) {
                                                        $('#window-select').append('<div><img src="<?php echo $host; ?>/' + data[i].path + '" alt="图片" title="' + data[i].name + '"></div>');
                                                    }
                                                }
                                            }
                                        }
                                    })
                                }
                            })
                        }
                    });
                }
            });
        }).on('click', '#window-file-select,#window-image-select', function () {
        }).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            $('.layui-laypage-btn').click();
        });

        // 更新文件方法
        function updateFile(type, content = '')
        {
            var cont = $('#content');
            switch (type) {
                case 'F':
                    cont.html('<input type="hidden" name="cont" value="'+content+'"><button type="button" id="file-upload" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传文件</button><!--br><br><button type="button" id="file-select" class="layui-btn layui-btn-small layui-btn-normal"><i class="layui-icon">&#xe61f;</i>选取文件</button-->').css('width', '120px');
                    cont.prev().text('文件');
                    cont.next().html('<span id="file" title="' + content + '" style="overflow: hidden;text-overflow: ellipsis;">' + content.substr(content.lastIndexOf('/')+1) + '</span>');
                    // 渲染上传按钮
                    uploadRender('file');
                    break;
                case 'V':
                    cont.html('<textarea class="layui-textarea" name="cont" cols="30" rows="5" placeholder="视频分享链接" maxlength="1000">'+content+'</textarea>').css('width', '480px');
                    cont.prev().text('视频');
	                cont.next().html('');
                    break;
                case 'I':
                default:
                    cont.html('<input type="hidden" name="cont" value="'+content+'"><button type="button" id="image-upload" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传图片</button><!--br><br></span><button type="button" id="image-select" class="layui-btn layui-btn-small layui-btn-normal"><i class="layui-icon">&#xe61f;</i>选取图片</button-->').css('width', '120px');
                    cont.prev().text('图片');
                    content = 'w.gif';
                    cont.next().html('<img id="image" src="<?php echo $host; ?>/' + content + '" alt="图片" height="182">');
                    // 渲染上传按钮
                    uploadRender('image');
                    break;
            }
        }

        // 渲染上传方法
        function uploadRender(type) {
            upload.render({
                elem:'#' + type + '-upload',
                url:'<?php echo $path; ?>/media.php?type='+type,
                data:{action:'upload'},
                accept:'file',
                size:2000,
                done:function (data) {
                    if (data.code) {
                        $('input[name=cont]').val(data.path);
                        if ('file' === type) {
                            $('#file').attr('title', '<?php echo $host; ?>/' + data.path).text(data.path.substr(data.path.lastIndexOf('/') + 1));
                        } else {
                            $('#image').attr('src', '<?php echo $host; ?>/' + data.path);
                        }
                    } else {
                        layer.msg(data.err, {icon: 2});
                    }
                }
            });
        }
    });
</script>
</body>
</html>