<?php
/**
 * 预定义变量
 *
 * @var string     $crumb
 * @var string     $host
 * @var string     $path
 * @var array      $page
 * @var \sc\Helper $hel
 * @var string     $msg
 * @var string     $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>页面设置</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin:0 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0 0 0;
    }
    #operation {
        position: fixed;
        top: 15px;
        right: 15px;
        margin: 10px 15px;
        z-index: 666;
    }
    .operation {
      height: 30px;
      margin: 10px 0;
    }
	.tags {
	  padding: 10px 20px;
	  font-size: 16px;
	}
	.tags > input {
	  margin-top: 5px;
	}
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
    <div id="operation" class="layui-btn-group">
        <a class="layui-btn layui-btn-primary layui-btn-small" href="#navigation">导航页面</a>
        <a class="layui-btn layui-btn-primary layui-btn-small" href="#news">新闻页面</a>
        <a class="layui-btn layui-btn-primary layui-btn-small" href="#product">产品页面</a>
        <a class="layui-btn layui-btn-primary layui-btn-small" href="#cart">结算页面</a>
        <a class="layui-btn layui-btn-primary layui-btn-small" href="#form">表单页面</a>
        <a class="layui-btn layui-btn-primary layui-btn-small" href="#member">会员页面</a>
        <a class="layui-btn layui-btn-normal layui-btn-small" href="#head">返回顶部</a>
        <a class="layui-btn layui-btn-normal layui-btn-small" href="#submit">直达底部</a>
        <a class="layui-btn layui-btn-normal layui-btn-small" href="javascript:" id="refresh">刷新</a>
        <a class="layui-btn layui-btn-danger layui-btn-small" href="javascript:" id="go-back">返回</a>
    </div>
</div>
<div class="form">
  <form id="page" class="layui-form layui-form-pane">
    <div id="head">
    <div class="layui-form-item" pane>
      <label class="layui-form-label">首页标题</label>
      <div class="layui-input-inline" style="width: 580px;">
        <input type="text" class="layui-input" name="h_til" placeholder="首页标题" autocomplete="off" maxlength="60" value="<?php echo $page['h_til']; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">首页关键字</label>
      <div class="layui-input-inline" style="width: 580px;">
        <input type="text" class="layui-input" name="h_kwd" placeholder="首页关键字(keyword标签)" autocomplete="off" maxlength="60" value="<?php echo $page['h_kwd']; ?>">
      </div>
      <div class="layui-form-mid layui-word-aux">多条使用英文逗号(,)分割</div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">首页描述</label>
      <div class="layui-input-inline" style="width: 700px;">
        <textarea class="layui-textarea" name="h_des" cols="30" rows="2" placeholder="首页描述(description)" maxlength="240"><?php echo $page['h_des']; ?></textarea>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">产品页标题</label>
      <div class="layui-input-inline" style="width:580px;">
        <input type="text" class="layui-input" name="p_til" placeholder="产品页标题" autocomplete="off" maxlength="60" value="<?php echo $page['p_til']; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">产品页关键字</label>
      <div class="layui-input-inline" style="width:580px;">
        <input type="text" class="layui-input" name="p_kwd" placeholder="产品页关键字(keyword标签)" autocomplete="off" maxlength="60" value="<?php echo $page['p_kwd']; ?>">
      </div>
      <div class="layui-form-mid layui-word-aux">多条使用英文逗号(,)分割</div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">产品页描述</label>
      <div class="layui-input-inline" style="width: 700px;">
        <textarea class="layui-textarea" name="p_des" cols="30" rows="2" placeholder="产品页描述(description)" maxlength="240"><?php echo $page['p_des']; ?></textarea>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">信息页标题</label>
      <div class="layui-input-inline" style="width: 580px;">
        <input type="text" class="layui-input" name="i_til" placeholder="信息页标题" autocomplete="off" maxlength="60" value="<?php echo $page['i_til']; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">信息页关键字</label>
      <div class="layui-input-inline" style="width: 580px;">
        <input type="text" class="layui-input" name="i_kwd" placeholder="信息页关键字(keyword标签)" autocomplete="off" maxlength="60" value="<?php echo $page['i_kwd']; ?>">
      </div>
      <div class="layui-form-mid layui-word-aux">多条使用英文逗号(,)分割</div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">信息页描述</label>
      <div class="layui-input-inline" style="width: 700px;">
        <textarea class="layui-textarea" name="i_des" cols="30" rows="2" placeholder="信息页描述(description)" maxlength="240"><?php echo $page['i_des']; ?></textarea>
      </div>
    </div>
    <div class="layui-form-item" pane>
	    <label class="layui-form-label">联系我们</label>
	    <div class="layui-input-inline" style="width: 840px;">
		    <textarea class="ckeditor" name="c_des" cols="30" rows="5" placeholder="联系我们页面信息" maxlength="2047"><?php echo $page['c_des']; ?></textarea>
	    </div>
    </div>
    <div class="layui-form-item" pane>
	    <label class="layui-form-label">侧栏按钮</label>
	    <div class="layui-input-inline" style="width: 580px;">
		    <textarea class="layui-textarea" name="h_tpl" cols="30" rows="5" placeholder="侧栏按钮" maxlength="2047"><?php echo $page['h_tpl']; ?></textarea>
	    </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">文字标签翻译</label>
      <div class="layui-input-inline" style="width: 50%;"><?php include __DIR__.'/tags.php'; ?></div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label"></label>
      <div class="layui-input-inline" style="width: 120px;">
        <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="page">更新</button>
      </div>
    </div>
    </div>
  </form>
</div>
<script src="<?php echo $path; ?>/vendor/ckeditor/ckeditor.js"></script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'layer', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            element = layui.element;

        // 异步提交
        form.on('submit(page)', function (el) {
	        // 异步更新CKEditor内容
	        for (var instance in CKEDITOR.instances) {
		        if (CKEDITOR.instances.hasOwnProperty(instance)) {
			        CKEDITOR.instances[instance].updateElement();
		        }
	        }
            $.ajax({
                url:el.form.action,
                data:$('#page').serialize(),
                type:'POST',
                dataType:'json',
                success:function (data) {
                    if (data.code) {
                        layer.msg('修改成功', {icon:1});
                        setTimeout(function () {
                            location.reload();
                        }, 3000);
                    } else {
                        layer.msg('修改失败', {icon:2});
                    }
                }
            });
            return false;
        });

        $(document).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            location.reload();
        });
    });
</script>
</body>
</html>