<?php
/**
 * 预定义变量
 *
 * @var string     $crumb
 * @var string     $host
 * @var string     $path
 * @var string     $lang
 * @var string     $select
 * @var string     $attribute
 * @var string     $model
 * @var array      $product
 * @var \sc\Helper $hel
 * @var string     $msg
 * @var string     $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>产品管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      height: 30px;
      margin: 10px;
    }
    .breadcrumb {
      margin: 10px;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 5px 15px;
    }
    .image {
      float: left;
      width: 52px;
      height: 52px;
      margin-left: 15px;
    }
    .image > .sha {
      position: absolute;
      text-align: center;
      line-height: 52px;
      width: 52px;
      height: 52px;
      opacity: 0;
      z-index: 233;
    }
    .image > .img {
      position: absolute;
      width: 52px;
      overflow: hidden;
    }
    .image > .img > img {
      display: block;
      margin: 0 auto;
    }
    .related {
      float: left;
      width: 112px;
      height: 142px;
      margin-left: 15px;
      overflow: hidden;
      text-align: center;
    }
    .related > .sha {
      position: absolute;
      text-align: center;
      line-height: 112px;
      width: 112px;
      height: 112px;
      opacity: 0;
      z-index: 233;
    }
    .related > .img {
      position: absolute;
      height: 112px;
      overflow: hidden;
    }
    .related > .img img {
      display: block;
      margin: 5px auto;
    }
    .related > span {
      position: absolute;
      width: 112px;
      bottom: 5px;
      display: block;
      margin: 5px auto;
      overflow: hidden;
      text-overflow: ellipsis;
    }
    .sha:hover {
      color: #000000;
      background: #888888;
      opacity: 0.8;
    }
    #window-select {}
    #window-select > div {
      float: left;
      margin: 10px;
      width: 120px;
      height: 120px;
      overflow: hidden;
      text-align: center;
    }
    #window-select img {
      display: block;
      margin: 5px auto;
      height: 80px;
    }
    #window-page {
      position: absolute;
      bottom: 25px;
      left: 0;
      right: 0;
      text-align: center;
    }
	.attribute,.model {
	  margin: 10px;
	}
	.attribute > b {
	}
	.count {
	  display: inline-block;
	  width: 160px;
	}
	#sale > div > input:first-child {
		display: inline-block;
		width: 160px;
		height: 30px;
		margin-top: 8px;
	}
    #sale > div > input:nth-child(2) {
	    display: inline-block;
	    width: 100px;
	    height: 30px;
	    margin-top: 8px;
	    margin-left: 20px;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
</div>
<div class="form">
  <form id="cate" class="layui-form">
    <div class="layui-form-item" pane>
      <label class="layui-form-label">分类<span style="color:#FF0000;">*</span></label>
      <div class="layui-input-inline" style="min-width: 1000px;">
        <?php echo $select; ?>
      </div>
      <div class="layui-form-mid layui-word-aux">分类可以选取多条</div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">名称<span style="color:#FF0000;">*</span></label>
      <div class="layui-input-inline" style="width: 600px;">
        <input type="text" class="layui-input" name="name" placeholder="产品名称" autocomplete="off" maxlength="500" value="<?php echo $product ? $product['name'] : ''; ?>">
      </div>
    </div>
      <div class="layui-form-item" pane>
          <label class="layui-form-label">metatitle<span style="color:#FF0000;">*</span></label>
          <div class="layui-input-inline" style="width: 600px;">
              <input type="text" class="layui-input" name="metatitle" placeholder="metatitle" autocomplete="off" maxlength="500" value="<?php echo $product ? $product['metatitle'] : ''; ?>">
          </div>
      </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">型号</label>
      <div class="layui-input-inline" style="width: 360px;">
        <input type="text" class="layui-input" name="type" placeholder="产品型号" autocomplete="off" maxlength="240" value="<?php echo $product ? $product['type'] : ''; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">SKU</label>
      <div class="layui-input-inline" style="width: 360px;">
        <input type="text" class="layui-input" name="sku" placeholder="产品SKU" autocomplete="off" maxlength="240" value="<?php echo $product ? $product['sku'] : ''; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">URL</label>
      <div class="layui-input-inline" style="width: 360px;">
        <input type="text" class="layui-input" name="url" placeholder="自定义URL" autocomplete="off" maxlength="240" value="<?php echo $product ? $product['url'] : ''; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">图片</label>
      <div class="layui-input-inline" style="width: 240px;">
        <input type="text" class="layui-input" id="custom" placeholder="上传图片文件名(不填则随机)" autocomplete="off" maxlength="100">
        <span style="margin:20px;"></span><br>
        <button type="button" id="upload" class="layui-btn layui-btn-small"><i class="layui-icon">&#xe62f;</i>上传图片</button>&nbsp;&nbsp;&nbsp;&nbsp;
        <button type="button" id="select" class="layui-btn layui-btn-small layui-btn-normal"><i class="layui-icon">&#xe61f;</i>选取图片</button>
      </div>
      <div id="img" class="layui-form-mid layui-word-aux">
      <?php if ($product && [] != $product['img']):foreach ($product['img'] as $img): ?>
        <div class="image">
          <div class="sha">删除</div>
          <div class="img">
            <input type="hidden" name="img[]" value="<?php echo $img; ?>">
            <img src="<?php echo $img != '' ? $hel->to($img) : 'img/w.gif'; ?>" alt="产品图片" height="52">
          </div>
        </div>
      <?php endforeach;endif; ?>
        点击图片删除
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">关联产品</label>
      <div class="layui-input-inline" style="width: 80px;">
        <button type="button" id="relate" class="layui-btn layui-btn-small layui-btn-warm"><i class="layui-icon">&#xe657;</i>关联产品</button>
      </div>
      <div id="related" class="layui-form-mid layui-word-aux">
          <?php if ($product && [] != $product['related']):foreach ($product['related'] as $rel): ?>
            <div class="related">
              <div class="sha">删除</div>
              <div class="img">
                <input type="hidden" name="related[]" value="<?php echo $rel['id']; ?>">
                <img src="<?php echo $rel['img'] != '' ? $hel->to($rel['img']) : 'img/w.gif'; ?>" alt="产品图片" height="112">
              </div>
              <span title="<?php echo $rel['name']; ?>"><?php echo $rel['name']; ?></span>
            </div>
          <?php endforeach;endif; ?>
        点击图片删除
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">关键字</label>
      <div class="layui-input-inline" style="width: 600px;">
        <input type="text" class="layui-input" name="kwd" placeholder="页面关键字(keyword标签)" autocomplete="off" maxlength="500" value="<?php echo $product ? $product['kwd'] : ''; ?>">
      </div>
      <div class="layui-form-mid layui-word-aux">多条使用英文逗号(,)分割</div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">描述</label>
      <div class="layui-input-inline" style="width: 480px;">
        <textarea class="layui-textarea" name="des" cols="30" rows="2" placeholder="页面描述(description标签)" maxlength="1000"><?php echo $product ? $product['des'] : ''; ?></textarea>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">详细内容</label>
      <div class="layui-input-inline" style="width: 1000px;">
        <textarea class="ckeditor" name="details" cols="30" rows="15" placeholder="产品页面详细内容"><?php echo $product ? $product['details'] : ''; ?></textarea>
      </div>
    </div>
    <!--<div class="layui-form-item" pane>
      <label class="layui-form-label">库存</label>
      <div class="layui-input-inline" style="width: 480px;">
        <input type="radio" name="stock" value="IS" title="有货" <?php /*echo $product ? ('IS' == $product['stock'] ? 'checked' : '') : 'checked'; */?>>
        <input type="radio" name="stock" value="OS" title="缺货" <?php /*echo $product ? ('OS' == $product['stock'] ? 'checked' : '') : ''; */?>>
        <input type="radio" name="stock" value="PO" title="备货中" <?php /*echo $product ? ('PO' == $product['stock'] ? 'checked' : '') : ''; */?>>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">重量</label>
      <div class="layui-input-inline" style="width: 120px;">
        <input type="number" class="layui-input" name="weight" placeholder="产品重量" autocomplete="off" min="0" max="999999" value="<?php /*echo $product ? $product['weight'] : '0.00'; */?>">
      </div>
      <div class="layui-form-mid layui-word-aux">重量单位在综合管理 - 站点设置中设置</div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">折扣模板</label>
      <div class="layui-input-inline" style="width: 360px;">
	    <?php /*echo $model; */?>
	    <div id="sale"><?php /*echo $product ? $product['sale'] : ''; */?></div>
      </div>
      <div class="layui-form-mid layui-word-aux">折扣模板可自行调节</div>
    </div>-->
    <div class="layui-form-item" pane>
      <label class="layui-form-label">状态</label>
      <div class="layui-input-block">
        <input type="checkbox" name="on" title="点击上架/下架产品" lay-skin="switch" lay-text="上架|下架" <?php echo $product ? (1 == $product['on'] ? 'checked' : '') : 'checked' ?>>
        <input type="checkbox" name="sa" title="点击启用/关闭促销态" lay-skin="switch" lay-text="促销|原价" <?php echo $product ? (1 == $product['sa'] ? 'checked' : '') : '' ?>>
        <input type="checkbox" name="re" title="点击启用/关闭推荐状态" lay-skin="switch" lay-text="推荐|不推" <?php echo $product ? (1 == $product['re'] ? 'checked' : '') : '' ?>>
        <input type="checkbox" name="hot" title="点击启用/关闭热门状态" lay-skin="switch" lay-text="热门|不热" <?php echo $product ? (1 == $product['hot'] ? 'checked' : '') : '' ?>>
        <input type="checkbox" name="new" title="点击启用/关闭新品状态" lay-skin="switch" lay-text="新品|不新" <?php echo $product ? (1 == $product['new'] ? 'checked' : '') : '' ?>>
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">排序</label>
      <div class="layui-input-inline" style="width: 120px;">
        <input type="number" class="layui-input" name="sort" placeholder="产品排序序号" autocomplete="off" min="0" max="65535" value="<?php echo $product ? $product['sort'] : '65535'; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label"></label>
      <div class="layui-input-inline" style="width: 120px;">
        <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="product">提交</button>
      </div>
    </div>
  </form>
</div>
<!-- 图片选取页面 -->
<script type="text/html" id="window">
  <div id="window-select"></div>
  <div id="window-page"></div>
</script>
<script src="<?php echo $path; ?>/vendor/ckeditor/ckeditor.js"></script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script src="<?php echo $path; ?>/vendor/layui/multiple.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'upload', 'layer', 'element', 'laypage'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            upload = layui.upload,
            element = layui.element,
            laypage = layui.laypage;

        // 下拉菜单多选
        layui.multiple($);

        // 异步提交
        form.on('submit(product)', function (o) {
            // 检查提交内容
            var f = o.field;
            if ('' === f.p_cate) {
                layer.msg('请至少选择一个产品分类', {icon:2, anim:6});
                return false;
            }
            if ('' === f.name) {
                layer.msg('产品名称不能为空', {icon:2, anim:6});
                return false;
            }
            if ('' === f.type && '' === f.sku) {
                layer.msg('产品类型与SKU请至少填写一项', {icon:2, anim:6});
                return false;
            }
            if (/^[\d.]+$/.test(f.url)) {
                layer.msg('产品URL不能为纯数字', {icon:2, anim:6});
                return false;
            }
            f.price = parseFloat(f.price);
            if (f.price < 0) {
                layer.msg('产品售价必须大于0', {icon:2, anim:6});
                return false;
            }
            f.sales = parseFloat(f.sales);
            if (f.sales < 0) {
                layer.msg('折扣价格必须大于0', {icon:2, anim:6});
                return false;
            }
            f.weight = parseFloat(f.weight);
            if (f.weight < 0) {
                layer.msg('产品重量必须大于0', {icon:2, anim:6});
                return false;
            }
            f.sort = parseInt(f.sort);
            if (f.sort < 0) {
                layer.msg('信息排序必须大于0', {icon:2, anim:6});
                return false;
            }
            // 禁用提交按钮
            if ('layui-btn layui-btn-disabled' !== o.elem.className) {
                o.elem.className = 'layui-btn layui-btn-disabled';
            } else {
                return false;
            }
            // 异步更新CKEditor内容
            for (var instance in CKEDITOR.instances) {
                if (CKEDITOR.instances.hasOwnProperty(instance)) {
                    CKEDITOR.instances[instance].updateElement();
                }
            }
            $.ajax({
                url:'<?php echo $path; ?>/product.php?lang=<?php echo $lang; ?>',
                data:$('#cate').serialize() + '&action=<?php echo $product ? 'edit' : 'insert'; ?>&unique=<?php echo $product ? $product['id'] : -1; ?>',
                type:'POST',
                dataType:'json',
                success:function (data) {
                    if (data.code) {
                        layer.msg('<?php echo $product ? '修改' : '添加'; ?>成功', {icon:1});
                        setTimeout(function () {
                            location.href = data.path;
                        }, 3000);
                    } else {
                        layer.msg(data.err, {icon:2});
                        o.elem.className = 'layui-btn';
                    }
                }
            });
            return false;
        }).on('select(attr)', function (o) {
        	var e = o.othis,
		        el = o.elem,
		        data = o.value;
        	$.ajax({
		        url:'<?php echo $path; ?>/product.php?lang=<?php echo $lang; ?>',
		        data:{
		        	action:'attr',
			        unique:data
		        },
		        method:'POST',
		        dataType:'json',
		        success:function (data) {
		        	if (data.code) {
		        		$('#attr').html(data.html);
				        form.render('checkbox');
			        } else {
				        layer.msg('发生错误，请重试', {icon:2});
			        }
		        }
	        })
        }).on('select(sale)', function (o) {
	        var e = o.othis,
		        el = o.elem,
		        data = o.value;
	        $.ajax({
		        url:'<?php echo $path; ?>/product.php?lang=<?php echo $lang; ?>',
		        data:{
			        action:'sale',
			        unique:data
		        },
		        method:'POST',
		        dataType:'json',
		        success:function (data) {console.log('111');
			        if (data.code) {
				        $('#sale').html(data.html);
				        form.render();
			        } else {
				        layer.msg('发生错误，请重试', {icon:2});
			        }
		        }
	        })
        });

        $(document).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            location.reload();
        }).on('click', '#select', function () {
            layer.open({
                type:1,
                skin:'layui-layer-lan',
                area:['760px', '500px'],
                title:'选择图片',
                content:$('#window').html(),
                success:function () {
                    $.ajax({
                        url:'<?php echo $path; ?>/file.php',
                        data:{
                            action:'number',
                            type:'I'
                        },
                        type:'POST',
                        dataType:'json',
                        success:function (data) {
                            laypage.render({
                                elem:'window-page',
                                count:data.number,
                                limit:10,
                                jump:function (o) {
                                    $('#window-select').html('');
                                    $.ajax({
                                        url:'<?php echo $path; ?>/file.php',
                                        data:{
                                            action:'select',
                                            limit:10,
                                            page:o.curr,
                                            type:'I'
                                        },
                                        type:'POST',
                                        dataType:'json',
                                        success:function (data) {
                                            for (var i in data) {
                                                if (data.hasOwnProperty(i)) {
                                                    $('#window-select').append('<div><img src="<?php echo $host; ?>/' + data[i].path + '" alt="图片" title="' + data[i].name + '"><button class="layui-btn layui-btn-small layui-btn-normal select" value="' + data[i].path + '">选择</button></div>');
                                                }
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
        }).on('click', '#relate', function () {
            layer.open({
                type:1,
                skin:'layui-layer-molv',
                area:['760px', '500px'],
                title:'选择图片',
                content:$('#window').html(),
                success:function () {
                    $.ajax({
                        url:'<?php echo $path; ?>/product.php?lang=<?php echo $lang; ?>',
                        data:{action:'number'},
                        type:'POST',
                        dataType:'json',
                        success:function (data) {
                            laypage.render({
                                elem:'window-page',
                                count:data.number,
                                limit:10,
                                jump:function (o) {
                                    $('#window-select').html('');
                                    $.ajax({
                                        url:'<?php echo $path; ?>/product.php?lang=<?php echo $lang; ?>',
                                        data:{
                                            action:'relate',
                                            limit: 10,
                                            page: o.curr
                                        },
                                        type: 'POST',
                                        dataType: 'json',
                                        success: function (data) {
                                            console.log(data);
                                            for (var i in data) {
                                                if (data.hasOwnProperty(i)) {
                                                    $('#window-select').append('<div><img src="<?php echo $host; ?>/' + data[i].img + '" alt="图片" title="' + data[i].name + '"><button class="layui-btn layui-btn-small layui-btn-normal relate" value="' + data[i].id + '">选择</button></div>')
                                                }
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
        }).on('click', '#window-select button.select', function () {
            $('#img').prepend('<div class="image"><div class="sha">删除</div><div class="img"><input type="hidden" name="img[]" value="' + $(this).val() + '"><img src="<?php echo $host; ?>/' + $(this).val() + '" alt="产品图片" height="52"></div></div>');
        }).on('click', '#window-select button.relate', function () {
            $('#related').prepend('<div class="related"><div class="sha">删除</div><div class="img"><input type="hidden" name="related[]" value="' + $(this).val() + '"><img src="' + $(this).prev().attr('src') + '" alt="产品图片" height="112"></div><span title="' + $(this).prev().attr('title') + '">' + $(this).prev().attr('title') + '</span></div>');
        }).on('click', '.sha', function () {
            $(this).parent().remove();
        }).on('blur', 'input[name=name]', function () {
            var url = $('input[name=url]');
            if ('' === url.val()) {
                url.val($(this).val().replace(/[^0-9A-Za-z-]+/g, '-'));
            }
        });

        // 渲染上传按钮
        upload.render({
            elem:'#upload',
            url:'<?php echo $path; ?>/product.php?lang=<?php echo $lang; ?>',
            before:function () {
              this.data['custom'] = $('#custom').val();
            },
            data:{action:'upload'},
            accept:'images',
            size:2000,
            done:function (data) {
                if (data.code) {
                    $('#img').prepend('<div class="image"><div class="sha">删除</div><div class="img"><input type="hidden" name="img[]" value="' + data.path + '"><img src="<?php echo $host; ?>/' + data.path + '" alt="产品图片" height="52"></div></div>');
                    layer.msg('上传成功', {icon: 1});
                } else {
                    layer.msg(data.err, {icon: 2});
                }
            }
        });
    });
</script>
</body>
</html>