<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>产品属性管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 15px 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 25px 20px;
    }
    .operation {
      height: 30px;
      margin: 10px 0;
    }
    .layui-input-block > span {
      margin-left: 20px;
      line-height: 36px;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
  <div class="operation">
    <button id="delete" class="layui-btn layui-btn-danger layui-btn-small">
      <i class="layui-icon">&#xe640;</i>批量删除
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/query.php', method:'post', where:{action:'list'}, page:true, limit:10, id:'query'}" lay-filter="query">
    <thead>
    <tr>
      <th lay-data="{field:'id', checkbox:true}">选择</th>
      <th lay-data="{field:'seq', width:80, sort:true}">ID</th>
      <th lay-data="{field:'qid', width:120}">产品ID</th>
      <th lay-data="{field:'sku', width:120}">产品SKU</th>
      <th lay-data="{field:'name', width:120}">产品名</th>
      <th lay-data="{field:'email', width:240}">邮箱</th>
      <th lay-data="{field:'phone', width:160}">电话</th>
      <th lay-data="{field:'time', width:160}">时间</th>
      <th lay-data="{field:'ip', width:120}">IP</th>
      <th lay-data="{fixed: 'right', width:260, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-normal layui-btn-small" lay-event="info"><i class="layui-icon">&#xe60a;</i>详细</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" lay-event="drop"><i class="layui-icon">&#xe640;</i>删除</a>
</script>
<!-- 增加/修改页面 -->
<script type="text/html" id="information">
  <div class="form">
    <form id="query" class="layui-form layui-form-pane">
      <div class="layui-form-item" pane>
        <label class="layui-form-label">产品ID</label>
        <div class="layui-input-block">
          <span data-field="qid"></span>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">产品SKU</label>
        <div class="layui-input-block">
          <span data-field="sku"></span>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">产品名称</label>
        <div class="layui-input-block">
          <span data-field="name"></span>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">预留邮箱</label>
        <div class="layui-input-block">
          <span data-field="email"></span>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">预留电话</label>
        <div class="layui-input-block">
          <span data-field="phone"></span>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">留言</label>
        <div class="layui-input-block">
          <span data-field="cont"></span>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">留言时间</label>
        <div class="layui-input-block">
          <span data-field="time"></span>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">留言IP</label>
        <div class="layui-input-block">
          <span data-field="ip"></span>
        </div>
      </div>
    </form>
  </div>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            table = layui.table;

        // 监听表格工具条事件
        table.on('tool(query)', function (o) {
            var data = o.data,
                e = o.event;

            switch (e) {
                case 'info':
                    layer.open({
                        type:1,
                        skin:'layui-layer-molv',
                        area:['760px', '500px'],
                        title:'修改',
                        content:$('#information').html(),
                        success:function (el, id) {
                            for (var f in data) {
                                if (data.hasOwnProperty(f)) {
                                    $('span[data-field=' + f + ']').text(data[f]);
                                }
                            }
                            form.render();
                        }
                    });
                    break;
                case 'drop':
                    layer.confirm('确认删除？删除后无法恢复', function (id) {
                        layer.close(id);
                        $.ajax({
                            url:'<?php echo $path; ?>/query.php',
                            data:'action=drop&unique=' + data.id,
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    o.del();
                                    layer.msg('删除成功', {icon:1});
                                } else {
                                    layer.msg('删除失败', {icon:2});
                                }
                            }
                        });
                    });
                    break;
                default:break;
            }
        });

        $(document).on('click', '#delete', function () {
            // 批量删除
            layer.confirm('确认批量删除？请仔细确认，删除后无法还原', function (id) {
                layer.close(id);
                var data = table.checkStatus('query').data,
                    unique = [];
                for (var i in data) {
                    if (data.hasOwnProperty(i)) {
                        unique[i] = data[i].id;
                    }
                }
                $.ajax({
                    url:location.href,
                    data:'unique=' + unique.join(', ') + '&action=delete',
                    type:'POST',
                    dataType:'json',
                    success: function (data) {
                        if (data.code) {
                            $('.layui-laypage-btn').click();
                            layer.msg('批量删除成功', {icon: 1});
                        } else {
                            layer.msg('批量删除失败', {icon: 2});
                        }
                    }
                });
            });
        }).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            $('.layui-laypage-btn').click();
        });
    });
</script>
</body>
</html>