<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>折扣管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 15px 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 25px 20px;
    }
    .operation {
      height: 30px;
      margin: 10px 0;
    }
	.item {
		height: 38px;
	}
	.count {
		position: absolute;
		left: auto;
		height: 30px;
	}
	.ratio {
		position: absolute;
		left: 130px;
		height: 30px;
	}
	.delete {
		position: absolute;
		left: 260px;
	}
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
  <div class="operation">
    <button id="delete" class="layui-btn layui-btn-danger layui-btn-small">
      <i class="layui-icon">&#xe640;</i>批量删除
    </button>
    <button id="insert" class="layui-btn layui-btn-normal layui-btn-small">
      <i class="layui-icon">&#xe608;</i>添加
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/sale.php', method:'post', where:{action:'list'}, page:true, limit:10, id:'sale'}" lay-filter="sale">
    <thead>
    <tr>
      <th lay-data="{field:'id', checkbox:true}">选择</th>
      <th lay-data="{field:'seq', width:80, sort:true}">ID</th>
      <th lay-data="{field:'name', width:140}">模板名称</th>
      <th lay-data="{field:'sort', width:100, sort:true}">排序</th>
      <th lay-data="{fixed: 'right', width:260, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="edit"><i class="layui-icon">&#xe642;</i>编辑</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" lay-event="drop"><i class="layui-icon">&#xe640;</i>删除</a>
</script>
<!-- 增加/修改页面 -->
<script type="text/html" id="update">
  <div class="form">
    <form id="sale" class="layui-form layui-form-pane">
      <div class="layui-form-item" pane>
        <label class="layui-form-label">名称<span style="color:#FF0000;">*</span></label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="name" placeholder="折扣模板名称" autocomplete="off" maxlength="120">
        </div>
        <div class="layui-form-mid layui-word-aux">名称长度请勿超过120个字符</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">模板</label>
        <div class="layui-input-inline model" style="width: 120px;">
	      <div>
		    <button type="button" class="layui-btn layui-btn-small create">添加</button>
	      </div>
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">排序</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="number" class="layui-input" name="sort" placeholder="折扣排序" autocomplete="off" min="0" max="65535">
        </div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label"></label>
        <div class="layui-input-inline" style="width: 360px;">
          <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="sale">提交</button>
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
    </form>
  </div>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'layer', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            table = layui.table,
            element = layui.element;

        // 监听表格工具条事件
        table.on('tool(sale)', function (o) {
            var data = o.data,
                e = o.event;

            switch (e) {
                case 'edit':
                    layer.open({
                        type:1,
                        skin:'layui-layer-molv',
                        area:['740px', '500px'],
                        title:'修改',
                        content:$('#update').html(),
                        success:function (el, id) {
                            $('input[name=name]').val(data.name);
                            $('input[name=sort]').val(data.sort);
                            try {
	                            JSON.parse(data.model).forEach(function (model) {
		                            $('.create').parent().before('<div class="item"><input type="text" class="layui-input count" name="count[]" placeholder="订货区间" value="' + model.count + '"><input type="number" class="layui-input ratio" name="ratio[]" placeholder="折扣比例" value="' + model.ratio + '"><button class="layui-btn layui-btn-small layui-btn-danger delete">删除</button></div>');
	                            });
                            } catch (e) {}
                            $('#submit').text('修改');
                            form.on('submit(sale)', function (o) {
                                var c = check(o.field);
                                if (true !== c) {
                                    layer.msg(c, {icon:2, anim:6});
                                    return false;
                                }
                                $.ajax({
                                    url:'<?php echo $path; ?>/sale.php',
                                    data:$('#sale').serialize() + '&action=edit&unique=' + data.id,
                                    type:'POST',
                                    dataType:'json',
                                    success:function (data) {
                                        if (data.code) {
                                            layer.close(id);
                                            $('.layui-laypage-btn').click();
                                            layer.msg('修改成功', {icon:1});
                                        } else {
                                            layer.msg(data.err, {icon:2});
                                        }
                                    }
                                });
                                return false;
                            });
                        }
                    });
                    break;
                case 'drop':
                    layer.confirm('确认删除？删除后无法恢复', function (id) {
                        layer.close(id);
                        $.ajax({
                            url:'<?php echo $path; ?>/sale.php',
                            data:'action=drop&unique=' + data.id,
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    o.del();
                                    layer.msg('删除成功', {icon:1});
                                } else {
                                    layer.msg('删除失败', {icon:2});
                                }
                            }
                        });
                    });
                    break;
                default:break;
            }
        });

        $(document).on('click', '#insert', function () {
            // 添加
            layer.open({
                type:1,
                skin:'layui-layer-lan',
                area:['740px', '500px'],
                title:'添加',
                content:$('#update').html(),
                success:function (el, id) {
                    $('input[name=count],input[name=sort]').val('65535');
                    $('input[name=ratio]').val('1.00');
                    $('#submit').text('添加');
                    form.on('submit(sale)', function (o) {
                        var c = check(o.field);
                        if (true !== c) {
                            layer.msg(c, {icon:2, anim:6});
                            return false;
                        }
                        $.ajax({
                            url:o.form.action,
                            data:$('#sale').serialize() + '&action=insert',
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    layer.close(id);
                                    $('.layui-laypage-btn').click();
                                    layer.msg('添加成功', {icon:1});
                                } else {
                                    layer.msg(data.err, {icon:2});
                                }
                            }
                        });
                        return false;
                    });
                }
            });
        }).on('click', '#delete', function () {
            // 批量删除
            layer.confirm('确认批量删除？请仔细确认，删除后无法还原', function (id) {
                layer.close(id);
                var data = table.checkStatus('sale').data,
                    unique = [];
                for (var i in data) {
                    if (data.hasOwnProperty(i)) {
                        unique[i] = data[i].id;
                    }
                }
                $.ajax({
                    url:location.href,
                    data:'unique=' + unique.join(', ') + '&action=delete',
                    type:'POST',
                    dataType:'json',
                    success: function (data) {
                        if (data.code) {
                            $('.layui-laypage-btn').click();
                            layer.msg('批量删除成功', {icon: 1});
                        } else {
                            layer.msg('批量删除失败', {icon: 2});
                        }
                    }
                });
            });
        }).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            $('.layui-laypage-btn').click();
        }).on('click', '.create', function () {
	        $(this).parent().before('<div class="item"><input type="text" class="layui-input count" name="count[]" placeholder="订货区间"><input type="number" class="layui-input ratio" name="ratio[]" placeholder="折扣比例"><button class="layui-btn layui-btn-small layui-btn-danger delete">删除</button></div>');
        }).on('click', '.delete', function () {
        	$(this).parent().remove();
        });

        // 提交检查
        function check(f) {
            if ('' === f.name) {
                return '模板名称不能为空';
            }
            if (parseInt(f.count) < 0) {
                return '最低订货数量不能小于0';
            }
            if (parseFloat(f.ratio) < 0 || parseFloat(f.ratio) > 1) {
                return '折扣比例必须在0 - 1之间';
            }
            if (parseInt(f.sort) < 0) {
                return '折扣排序不能小于0';
            }
            return true;
        }
    });
</script>
</body>
</html>