<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>模板管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 15px 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 25px 20px;
    }
  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/tpl.php', method:'post', where:{action:'list'}, id:'tpl'}" lay-filter="tpl">
    <thead>
    <tr>
      <th lay-data="{field:'name', width:240}">模板名称</th>
      <th lay-data="{field:'image', width:120}">预览图片</th>
	    <th lay-data="{field:'current', width:120}">应用状态</th>
      <th lay-data="{fixed: 'right', width:260, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="use"><i class="layui-icon">&#xe642;</i>应用模板</a>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'table', 'layer', 'element'], function () {
        var $ = layui.$,
            layer = layui.layer,
            table = layui.table,
            element = layui.element;

        // 监听表格工具条事件
        table.on('tool(tpl)', function (o) {
            var data = o.data,
                e = o.event;

            switch (e) {
	            case 'use':
	            	$.ajax({
			            url:'<?php echo $path; ?>/tpl.php',
			            data:{
			            	action:'use',
			            	unique:data.name
			            },
			            type:'POST',
			            dataType:'json',
			            success:function (data) {
			            	if (data.code) {
					            layer.msg('修改成功', {icon:1});
					            setTimeout(function () {location.reload()}, 3000);
				            } else {
					            layer.msg(data.err, {icon:2});
				            }
			            }
		            });
                    break;
                default:break;
            }
        });

        $(document).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
	        location.reload();
        });
    });
</script>
</body>
</html>