<?php
/**
 * 预定义变量
 *
 * @var string $crumb
 * @var string $host
 * @var string $path
 * @var string $msg
 * @var string $err
 */
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>用户管理</title>
  <link rel="stylesheet" href="<?php echo $path; ?>/vendor/layui/css/layui.css">
  <style>
    #head {
      margin: 15px 20px 25px;
    }
    .breadcrumb {
      padding: 10px 0;
    }
    .page {
      position: absolute;
      top: 0;
      right: 10px;
      margin: 25px 20px;
    }
    .operation {
      height: 30px;
      margin: 10px 0;
    }
    #role div.role {
      width: 125px;
      height: 100%;
      padding-top: 15px;
      padding-left: 15px;
      float: left;
    }
    #role ul.role {
      display: block;
      padding-left: 10px;
    }
    #role ul.role li{margin:3px 0;}
    #give {
      position: absolute;
      bottom: 15px;
      left: 0;
      right: 0;
      text-align: center;
    }

  </style>
</head>
<body>
<!-- 头部 -->
<div id="head">
  <div class="breadcrumb">
    <span class="layui-breadcrumb">
      <?php echo $crumb; ?>
    </span>
  </div>
  <div class="page">
    <button id="go-back" class="layui-btn layui-btn-danger layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#xe603;</i>返回
    </button>
    <button id="refresh" class="layui-btn layui-btn-normal layui-btn-radius layui-btn-small">
      <i class="layui-icon">&#x1002;</i>刷新
    </button>
  </div>
  <div class="operation">
    <button id="delete" class="layui-btn layui-btn-danger layui-btn-small">
      <i class="layui-icon">&#xe640;</i>批量删除
    </button>
    <button id="insert" class="layui-btn layui-btn-normal layui-btn-small">
      <i class="layui-icon">&#xe608;</i>添加
    </button>
  </div>
</div>
<!-- 内容 -->
<div id="body" style="padding:0 20px;">
  <!-- 数据表格 -->
  <table class="layui-table" lay-data="{url:'<?php echo $path ?>/user.php', method:'post', where:{action:'list'}, page:true, limit:10, id:'user'}" lay-filter="user">
    <thead>
    <tr>
      <th lay-data="{field:'id', checkbox:true}">选择</th>
      <th lay-data="{field:'seq', width:80, sort:true}">ID</th>
      <th lay-data="{field:'name', width:140}">昵称</th>
      <th lay-data="{field:'username', width:120, sort:true}">账号</th>
      <th lay-data="{field:'image', width:80}">头像</th>
      <th lay-data="{field:'email', width:180}">邮箱</th>
      <th lay-data="{field:'phone', width:120}">电话</th>
      <th lay-data="{field:'date', width:160, sort: true}">最后登录时间</th>
      <th lay-data="{field:'ip', width:140}">最后登录IP</th>
      <th lay-data="{fixed: 'right', width:260, align:'center', toolbar:'#operation'}">操作</th>
    </tr>
    </thead>
  </table>
</div>
<!-- 底部 -->
<div id="foot"></div>
<!-- 操作按钮 -->
<script type="text/html" id="operation">
  <a class="layui-btn layui-btn-small" lay-event="edit"><i class="layui-icon">&#xe642;</i>编辑</a>
  <a class="layui-btn layui-btn-small" lay-event="role">权限分配</a>
  <a class="layui-btn layui-btn-danger layui-btn-small" lay-event="drop"><i class="layui-icon">&#xe640;</i>删除</a>
</script>
<!-- 增加/修改页面 -->
<script type="text/html" id="update">
  <div class="form">
    <form id="user" class="layui-form layui-form-pane">
      <div class="layui-form-item" pane>
        <label class="layui-form-label">账号<span style="color:#FF0000;">*</span></label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="username" placeholder="登录账号" autocomplete="off" maxlength="120" lay-verify="required">
        </div>
        <div class="layui-form-mid layui-word-aux">账号长度请勿超过120个字符</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">密码<span style="color:#FF0000;">*</span></label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="password" class="layui-input" name="password" placeholder="登录密码" autocomplete="off">
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">昵称</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="name" placeholder="昵称" autocomplete="off" maxlength="60">
        </div>
        <div class="layui-form-mid layui-word-aux">昵称长度请勿超过60个字符</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">邮箱</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="email" placeholder="邮箱" autocomplete="off" maxlength="120">
        </div>
        <div class="layui-form-mid layui-word-aux">邮箱长度请勿超过120个字符</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">电话</label>
        <div class="layui-input-inline" style="width: 360px;">
          <input type="text" class="layui-input" name="phone" placeholder="电话" autocomplete="off" maxlength="15">
        </div>
        <div class="layui-form-mid layui-word-aux">只接受中国大陆手机号码</div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label">头像</label>
        <div class="layui-input-inline" style="width: 120px;">
          <input type="hidden" name="image">
          <button type="button" id="upload" class="layui-btn"><i class="layui-icon">&#xe67c;</i>上传头像</button>
        </div>
        <div class="layui-form-mid layui-word-aux"><img id="image" src="" alt="头像" width="80"></div>
      </div>
      <div class="layui-form-item" pane>
        <label class="layui-form-label"></label>
        <div class="layui-input-inline" style="width: 360px;">
          <button type="button" class="layui-btn" id="submit" lay-submit lay-filter="user">提交</button>
        </div>
        <div class="layui-form-mid layui-word-aux"></div>
      </div>
    </form>
  </div>
</script>
<script type="text/html" id="access">
  <div>
    <form id="role" class="layui-form"></form>
  </div>
</script>
<script src="<?php echo $path; ?>/vendor/layui/layui.js"></script>
<script>
    /** 引入组件 */
    layui.use(['jquery', 'form', 'table', 'layer', 'upload', 'element'], function () {
        var $ = layui.$,
            form = layui.form,
            layer = layui.layer,
            table = layui.table,
            upload = layui.upload,
            element = layui.element;

        // 监听表格工具条事件
        table.on('tool(user)', function (o) {
            var data = o.data,
                e = o.event;

            switch (e) {
                case 'edit':
                    layer.open({
                        type:1,
                        skin:'layui-layer-molv',
                        area:['800px', '500px'],
                        title:'修改',
                        content:$('#update').html(),
                        success:function (el, id) {
                            $('input[name=username]').val(data.username);
                            $('input[name=password]').parent().next().text('此项不填则不修改密码');
                            $('input[name=name]').val(data.name);
                            $('#upload').val(data.id);
                            uploadRender();
                            var src = $('#image-' + data.seq).attr('src');
                            $('#image').attr('src', src);
// IE不支持                    $('input[name=image]').val(src.substr(location.origin.length + 1));
                            $('input[name=image]').val(src.substr(<?php echo strlen($host)+1; ?>));
                            $('input[name=email]').val(data.email);
                            $('input[name=phone]').val(data.phone);
                            $('#submit').text('修改').parent().next().text('若仅修改头像上传即可');
                            form.on('submit(user)', function (el) {
                                $.ajax({
                                    url:el.form.action,
                                    data:$('#user').serialize() + '&action=edit&unique=' + data.id,
                                    type:'POST',
                                    dataType:'json',
                                    success:function (data) {
                                        if (data.code) {
                                            layer.close(id);
                                            layer.msg('修改成功', {icon:1});
                                            if (data.refresh) {
	                                            setTimeout(function () {
		                                            top.location.reload();
	                                            }, 3000);
                                            } else {
	                                            $('.layui-laypage-btn').click();
                                            }
                                        } else {
                                            layer.msg(data.err, {icon:2});
                                        }
                                    }
                                });
                                return false;
                            });
                        }
                    });
                    break;
                case 'drop':
                    layer.confirm('确认删除？删除后无法恢复', function (id) {
                        layer.close(id);
                        $.ajax({
                            url:'<?php echo $path; ?>/user.php',
                            data:'action=drop&unique=' + data.id,
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    o.del();
                                    layer.msg('删除成功', {icon:1});
                                } else {
                                    layer.msg('删除失败', {icon:2});
                                }
                            }
                        });
                    });
                    break;
                case 'role':
                    layer.open({
                        type:1,
                        skin:'layui-layer-molv',
                        area:['760px', '500px'],
                        title:'权限分配(分配上级权限，下级权限自动获得，无需分配)',
                        content:$('#access').html(),
                        success:function (el, id) {
                            $('#role').html('');
                            $.ajax({
                                url:'<?php echo $path; ?>/user.php',
                                data:{
                                    action:'access',
                                    unique:data.id
                                },
                                type:'POST',
                                dataType:'json',
                                success:function (d) {
                                    $('#role').append(d.html).append('<div id="give"><button type="button" class="layui-btn layui-btn-normal layui-btn-small" lay-submit lay-filter="role">分配</button></div>');
                                    form.render().on('checkbox(role)', function (o) {
//                                        $(o.elem).next().find('input:checkbox:checked').prop('checked', false);
                                    }).on('submit(role)', function () {
                                        if ('' === $('input[name=username]').val()) {
                                            layer.msg('账号不能为空', {icon:2, anim:6});
                                            return false;
                                        }
                                        if ('' === $('input[name=password]').val()) {
                                            layer.msg('密码不能为空', {icon:2, anim:6});
                                            return false;
                                        }
                                        $.ajax({
                                            url:'<?php echo $path; ?>/user.php',
                                            data:$('#role').serialize() + '&action=role&unique=' + data.id,
                                            type:'POST',
                                            dataType:'json',
                                            success:function (data) {
                                                if (data.code) {
                                                    layer.close(id);
                                                    layer.msg('权限分配成功', {icon:1});
//                                                    setTimeout(top.window.reload(), 3000);
                                                } else {
                                                    layer.msg(data.err, {icon:2});
                                                }
                                            }
                                        });
                                        return false;
                                    });
                                }
                            });
                        }
                    });
                    break;
                default:break;
            }
        });

        $(document).on('click', '#insert', function () {
            // 添加
            layer.open({
                type:1,
                skin:'layui-layer-lan',
                area:['800px', '500px'],
                title:'添加',
                content:$('#update').html(),
                success:function (el, id) {
                    $('#upload').val('0');
                    $('#image').attr('src', '<?php echo $host; ?>/file/w.gif');
                    uploadRender();
                    $('#submit').text('添加');
                    form.on('submit(user)', function (o) {
                        if ('' === $('input[name=username]').val()) {
                            layer.msg('账号不能为空', {icon:2, anim:6});
                            return false;
                        }
                        if ('' === $('input[name=password]').val()) {
                            layer.msg('密码不能为空', {icon:2, anim:6});
                            return false;
                        }
                        $.ajax({
                            url:o.form.action,
                            data:$('#user').serialize() + '&action=insert',
                            type:'POST',
                            dataType:'json',
                            success:function (data) {
                                if (data.code) {
                                    layer.close(id);
                                    $('.layui-laypage-btn').click();
                                    layer.msg('添加成功', {icon:1});
                                } else {
                                    layer.msg(data.err, {icon:2});
                                }
                            }
                        });
                        return false;
                    });
                }
            });
        }).on('click', '#delete', function () {
            // 批量删除
            layer.confirm('确认批量删除？请仔细确认，删除后无法还原', function (id) {
                layer.close(id);
                var data = table.checkStatus('user').data,
                    unique = [];
                for (var i in data) {
                    if (data.hasOwnProperty(i)) {
                        unique[i] = data[i].id;
                    }
                }
                $.ajax({
                    url: location.href,
                    data: 'unique=' + unique.join(', ') + '&action=delete',
                    type: 'POST',
                    dataType: 'json',
                    success: function (data) {
                        if (data.code) {
                            $('.layui-laypage-btn').click();
                            layer.msg('批量删除成功', {icon: 1});
                        } else {
                            layer.msg('批量删除失败', {icon: 2});
                        }
                    }
                });
            });
        }).on('click', '#go-back', function () {
            history.go(-1);
        }).on('click', '#refresh', function () {
            $('.layui-laypage-btn').click();
        });

        // 渲染上传按钮
        function uploadRender() {
            // 头像上传
            upload.render({
                elem:'#upload',
                url:'<?php echo $path; ?>/user.php',
                data:{
                    action:'image',
                    unique:$('#upload').val()
                }, accept:'images',
                size:2000,
                done:function (data) {
                    if (data.code) {
                        $('input[name=image]').val(data.path);
                        $('#image').attr('src', '<?php echo $host; ?>/' + data.path + '?rand=' + Math.random());
                        layer.msg('上传成功', {icon:1});
                    } else {
                        layer.msg(data.err, {icon:2});
                    }
                }
            });
        }
    });
</script>
</body>
</html>