<?php

require_once __DIR__ . '/core.php';

if ($con->request->isAjax()) {
    $action = $con->request->post('action');
    switch ($action) {
        case 'list':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            // 查询数据
            $data = $con->db->table('query')->find('id, q_id, q_sku, q_name, q_email, q_phone, q_cont, q_time, q_ip')
                ->order('q_time DESC')->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            // 处理数据
            $queries = [];
            foreach ($data as $index => $query) {
                $queries[$index]['seq'] = $index + 1;
                $queries[$index]['id'] = $query['id'];
                $queries[$index]['qid'] = $query['id'];
                foreach (['sku', 'name', 'email', 'phone', 'time', 'cont'] as $key) {
                    $queries[$index][$key] = $query['q_' . $key];
                }
                $queries[$index]['ip'] = long2ip($query['q_ip']);
            }
            // 统计总数
            $count = $con->db->table('query')->count();
            // 返回数据
            $data = [
                'msg'   => '',
                'code'  => 0,
                'count' => $count,
                'data'  => $queries
            ];
            $con->json($data);
            break;
        case 'drop':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('query')->delete('id = ?', [$unique])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
        case 'delete':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('query')->delete('id IN ('.$unique.')')->row();
            $code = is_numeric($row);
            $con->json(['code' => $code]);
            break;
        default:break;
    }
} else {
    $con->render('query', ['host' => $hel->url(), 'path' => $hel->path(), 'crumb' => $breadcrumb]);
}