<?php

require_once __DIR__ . '/core.php';

if ($con->request->isAjax()) {
    $action = $con->request->post('action');
    switch ($action) {
        case 'list':
            // 获取分页
            $limit = $con->request->post(['page', 'limit'], FILTER_VALIDATE_INT);
            // 查询数据
            $data = $con->db->table('sale')->find('id, s_name, s_model, s_sort')
                ->limit(($limit['page'] - 1) * $limit['limit'], $limit['limit'])->all();
            // 处理数据
            $sales = [];
            foreach ($data as $index => $sale) {
                $sales[$index]['seq'] = $index + 1;
                $sales[$index]['id'] = $sale['id'];
                foreach (['name', 'model', 'sort'] as $key) {
                    $sales[$index][$key] = $sale['s_'.$key];
                }
            }
            unset($data);
            // 统计总数
            $count = $con->db->table('sale')->count();
            // 返回数据
            $data = [
                'msg'   => '',
                'code'  => 0,
                'count' => $count,
                'data'  => $sales
            ];
            $con->json($data);
            break;
        case 'edit':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 取出数据
            $data = $con->request->post(['name', 'count', 'ratio', 'sort']);
            // 处理数据
            $sale = verify_data($data);
            unset($data);
            if (!is_array($sale)) {
                $con->json(['code' => false, 'err' => $sale]);
                break;
            }
            // 更新数据库
            $row = $con->db->table('sale')->update($sale, 'id = ?', [$unique])->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '修改失败']);
            }
            break;
        case 'drop':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('sale')->delete('id = ?', [$unique])->row();
            $code = 1 === $row;
            $con->json(['code' => $code]);
            break;
        case 'insert':
            // 取出数据
            $data = $con->request->post(['name', 'count', 'ratio', 'sort']);
            // 处理数据
            $sale = verify_data($data);
            unset($data);
            if (!is_array($sale)) {
                $con->json(['code' => false, 'err' => $sale]);
                break;
            }
            // 插入数据库
            $row = $con->db->table('sale')->insert($sale)->row();
            if (1 === $row) {
                $con->json(['code' => true]);
            } else {
                $con->json(['code' => false, 'err' => '添加失败']);
            }
            break;
        case 'delete':
            // 获取唯一标识
            $unique = $con->request->post('unique');
            // 删除数据
            $row = $con->db->table('sale')->delete('id IN ('.$unique.')')->row();
            $code = is_numeric($row);
            $con->json(['code' => $code]);
            break;
        default:break;
    }
} else {
    $con->render('sale', ['host' => $hel->url(), 'path' => $hel->path(), 'crumb' => $breadcrumb]);
}

/**
 * 数据验证方法
 *
 * @param array $data
 *
 * @return string|array
 */
function verify_data($data)
{
    if ('' == $data['name']) {
        return '模板名称不能为空';
    }
    $sale['s_name'] = $data['name'];
    if ('' == $data['count']) {
    	return '至少需要一个模板';
    }
    $model = [];
    foreach ($data['ratio'] as $index => $datum) {
    	$model[$index] = [
		    'count' => $data['count'][$index],
    		'ratio' => $datum
	    ];
    }
    $sale['s_model'] = json_encode($model);
    if ((int)$data['sort'] < 0) {
        return '折扣排序不能小于0';
    }
    $sale['s_sort'] = $data['sort'];
    return $sale;
}