<?php namespace sc;

class App
{
    /**
     * 运行程序
     *
     * @param string $path
     */
    public function run($path)
    {
        // 分割路径
        $path = explode('/', $path);

        // 实例化DB对象
        $conf = include CONF . '/conf.php';
        $db = new DB($conf['database']);

        // 查询站点开启状态
        $on = $db->table('conf')->find('c_s_open')->where('id = ?', ['sem-cms'])->one()['c_s_open'];
        if ($on !== '1') {
            header('Content-Type:text/html; charset=UTF-8');
            die('网站开发中...');
        }

        // 查询语种
        $request = new Request();

        $word = $db->table('lang')->find('l_word')->where('l_on = ? AND l_host = ?', [1, $request->server('HTTP_HOST')])->one()['l_word'];
        if ($word == false) {
            $word = $db->table('lang')->find('l_word')->where('l_on = ? AND l_word = ?', [1, $path[0]])->one()['l_word'];

            if ($word != false) {
                define('LANG', $word);
                array_shift($path);
            } else {
                $word = $db->table('lang')->find('l_word')->where('l_on = ? AND l_main = ?', [1, 1])->one()['l_word'];
                if ($word == false) {
                	header('Content-Type:text/html; charset=UTF8');
                	die('主语种未启用');
                }
                define('LANG', $word);
            }
        } else {
            define('LANG', $word);
        }

        // 解析路由
        (new Router())->parse($path);
    }
}