<?php namespace sc;


class Router
{
    /**
     * 解析请求路径
     *
     * @param array $path
     */
    public function parse($path)
    {
        switch (sizeof($path)) {
            case 1:
                if (false !== strpos($path[0], '_')) {
                    $params = explode('_', $path[0]);
                    $path[0] = array_shift($params);
                } else {
                    $params = [];
                }

                if (false !== strpos($path[0], '-')) {
                    $name = ucfirst(preg_replace_callback('/(-)([a-z])/', function ($matches) {
                        return strtoupper($matches[2]);
                    }, $path[0]));
                } else {
                    $name = ucfirst($path[0]);
                }

                $class = 'app\controllers\\' . $name . 'Controller';
                if (class_exists($class)) {
                    $controller = $class;
                    $action = 'actionIndex';
                    unset($path, $name, $class);
                } else {
                    $controller = 'app\controllers\IndexController';

                    $method = 'action' . $name;
                    if (method_exists(new $controller(), $method)) {
                        $action = $method;
                    } else {
                        $action = 'actionIndex';
                        array_unshift($params, $path[0]);
                    }
                    unset($path, $name, $class, $method);
                }
                break;
            case 2:
                if (false !== strpos($path[1], '_')) {
                    $params = explode('_', $path[1]);
                    $path[1] = array_shift($params);
                } else {
                    $params = [];
                }

                if (false !== strpos($path[0], '-')) {
                    $name = ucfirst(preg_replace_callback('/(-)([a-z])/', function ($matches) {
                        return strtoupper($matches[2]);
                    }, $path[0]));
                } else {
                    $name = ucfirst($path[0]);
                }

                $class = 'app\controllers\\' . $name . 'Controller';
                if (class_exists($class)) {
                    $controller = $class;
                    if (false !== strpos($path[1], '-')) {
                        $name = ucfirst(preg_replace_callback('/(-)([a-z])/', function ($matches) {
                            return strtoupper($matches[2]);
                        }, $path[1]));
                    } else {
                        $name = ucfirst($path[1]);
                    }
                    $action = 'action' . $name;
                    unset($path, $name, $class);
                } else {
                    $controller = 'app\controllers\IndexController';

                    $method = 'action' . $name;
                    if (method_exists(new $controller(), $method)) {
                        $action = $method;
                        array_unshift($params, $path[1]);
                    } else {
                        $action = 'actionError';
                    }
                    unset($path, $name, $class, $method);
                }
                break;
            case 3:
                if (false !== strpos($path[0], '-')) {
                    $name = ucfirst(preg_replace_callback('/(-)([a-z])/', function ($matches) {
                        return strtoupper($matches[2]);
                    }, $path[0]));
                } else {
                    $name = ucfirst($path[0]);
                }

                $class = 'app\controllers\\' . $name . 'Controller';
                if (class_exists($class)) {
                    $controller = $class;
                    if (false !== strpos($path[1], '-')) {
                        $name = ucfirst(preg_replace_callback('/(-)([a-z])/', function ($matches) {
                            return strtoupper($matches[2]);
                        }, $path[1]));
                    } else {
                        $name = ucfirst($path[1]);
                    }
                    $action = 'action' . $name;
                    $params = explode('_', $path[2]);
                    unset($path, $name, $class);
                } else {
                    $controller = 'app\controllers\IndexController';
                    $action = 'actionError';
                    $params = [];
                }
                break;
            case 0:
                $controller = 'app\controllers\IndexController';
                $action = 'actionIndex';
                $params = [];
                break;
            default:
                $controller = 'app\controllers\IndexController';
                $action = 'actionError';
                $params = [];
                break;
        }

        if (!class_exists($controller)) {
            $controller = 'app\controllers\IndexController';
        }

        if (!method_exists(new $controller(), $action)) {
            $action = 'actionIndex';
        }

        if (empty($params)) {
            $params = [];
        }

        call_user_func_array([new $controller, $action], $params);
    }
}