<?php namespace sc;

use Grafika\Grafika;
use Grafika\Color;

class Upload
{
    /** @var array 上传文件信息 */
    private $file;

    /**
     * 取出上传文件
     *
     * @param string $name
     */
    public function __construct($name = null)
    {
        if (null != $name && isset($_FILES[$name])) {
            $this->file = $_FILES[$name];
        } else {
            list(, $this->file) = each($_FILES);
        }
    }

    /**
     * 保存文件
     *
     * @param string $path
     * @param string $name
     *
     * @return string|false
     */
    public function save($path, $name = null)
    {
        $path = trim($path, '/');
        if (!is_dir(PATH . '/' . $path)) {
            // 创建文件夹
            $dirs = explode('/', $path);
            for ($i = 0; $i < count($dirs); $i++) {
                $dir = PATH;
                for ($j = 0; $j <= $i; $j++) {
                    $dir .= '/' . $dirs[$j];
                }
                if (!is_dir($dir)) {
                    mkdir($dir);
                }
            }
        }

        // 生成文件名
        if (null == $name) {
            $name = substr(sha1($this->file['name']), (int)substr(time(), -1, 1), 16).strrchr($this->file['name'], '.');
        } else {
            $name = trim($name, '/');
            $pos = strpos($name, '.');
            if (false === $pos) {
                $name .= strrchr($this->file['name'], '.');
            }
        }

        // 保存至本地
        $success = move_uploaded_file($this->file['tmp_name'], PATH . '/' . $path . '/' . $name);

        if ($success) {
            // 返回保存地址
            return $path . '/' . $name;
        } else {
            return false;
        }
    }

    public function handle($path, $conf) {
        if (extension_loaded('gd')) {
            $suffix = strrchr($path, '.');
            $filename = substr($path, 0, -strlen($suffix));
            $original = $filename.'-o'.$suffix;
            $thumbnail = $filename.'-t'.$suffix;
            $watermark = $path;

            // 保存原图
            copy($watermark, $original);
            $editor = Grafika::createEditor();

            // 生成缩略图
            $editor->open($image, $original);
            $editor->resizeExactWidth($image, $conf['c_img_w']);
            $editor->save($image, $thumbnail);
            unset($image);

            // 图片附加水印
            switch ($conf['c_s_way']) {
                case 'texts':
                    $editor->open($image, $thumbnail);
                    switch ($conf['c_place']) {
                        case 'LT':$x = 2;$y = 18;break;
                        case 'CT':$x = 2;$y = 18;break;
                        case 'RT':$x = 2;$y = 18;break;
                        case 'LC':$x = 2;$y = 18;break;
                        case 'C':$x = 2;$y = 18;break;
                        case 'RC':$x = 2;$y = 18;break;
                        case 'LB':$x = 2;$y = 18;break;
                        case 'CB':$x = 2;$y = 18;break;
                        case 'RB':$x = 2;$y = 18;break;
                        default:$x = 2;$y = 18;break;
                    }
                    $editor->text($image, $conf['c_texts'], 16, $x, $y, new Color($conf['c_txt_c']));
                    $editor->save($image, $watermark);
                    break;
                case 'image':
                    $editor->open($image, $thumbnail);
                    $editor->open($water_image, __DIR__.'/../'.$conf['c_image']);
                    switch ($conf['c_place']) {
                        case 'LT':$place = 'top-left';break;
                        case 'CT':$place = 'top-center';break;
                        case 'RT':$place = 'top-right';break;
                        case 'LC':$place = 'center-left';break;
                        case 'C':$place = 'center';break;
                        case 'RC':$place = 'center-right';break;
                        case 'LB':$place = 'bottom-left';break;
                        case 'CB':$place = 'bottom-center';break;
                        case 'RB':$place = 'bottom-right';break;
                        default:$place = 'smart';break;
                    }
                    $editor->blend($image, $water_image, 'normal', 0.6, $place);
                    $editor->save($image, $watermark);
                    break;
                case 'none':
                default:break;
            }
            return true;
        }
        return false;
    }

    /**
     * 取出上传文件MIME
     *
     * @return string
     */
    public function mime()
    {
        return $this->file['type'];
    }

    /**
     * 检查文件是否为图片
     *
     * @return bool
     */
    public function isImage()
    {
        return 'image' == strtolower(strchr($this->mime(), '/', true));
    }
}