<?php

// 定义程序目录
define('PATH', __DIR__ . '/..');

// 定义配置目录
define('CONF', PATH . '/conf');

// 注册自动加载
spl_autoload_register(function ($class) {
    $namespace_map = [
        'app' => PATH,
        'sc'  => PATH . '/core'
    ];

    if (false === strpos($class, '\\')) {
        return;
    }

    foreach ($namespace_map as $namespace => $directory) {
        if (0 === strncmp($namespace, $class, strlen($namespace))) {
            $file = str_replace($namespace, '', str_replace('\\', '/', $class)) . '.php';
            if (file_exists($class_file = implode('/', [$directory, ltrim($file, '/')]))) {
                include_once $class_file;
            }
        }
    }

    return;
}, true, true);

// 引入类库
require_once PATH.'/vendor/autoload.php';
