<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>安装向导 - 数据库导入</title>
  <link rel="stylesheet" href="assets/layui.css">
  <style>
    body {background: url('assets/background.jpg');}
    .head {background: url('assets/logo-b.png') center no-repeat;width: 100%;height: 200px;text-align: center;}
    .form {width: 400px;margin: 100px auto;}
    #remember {width: 100%;text-align: right;}
    #submit {width: 100%;text-align: center;}
  </style>
</head>
<body>
<div class="head"></div>
<div class="form">
  <form id="login" class="layui-form layui-form-pane">
    <div class="layui-form-item" pane>
      <label class="layui-form-label ">数据库账号</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="username" placeholder="数据库账号">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">数据库密码</label>
      <div class="layui-input-block">
        <input type="password" class="layui-input" name="password" placeholder="数据库密码">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">数据库名称</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="dbname" placeholder="数据库名称">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">主机IP</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="host" placeholder="主机IP" value="localhost">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label">主机端口</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="port" placeholder="主机端口" value="3306">
      </div>
    </div>
<!--     <div class="layui-form-item" pane>
      <label class="layui-form-label">数据表前缀</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="prefix" placeholder="数据表前缀" value="sc_">
      </div>
    </div> -->
    <div class="layui-form-item">
      <div id="submit" class="layui-input-inline">
        <button class="layui-btn layui-btn-warm">导入数据库</button>
      </div>
    </div>
  </form>
</div>
<script src="assets/jquery.min.js"></script>
<script>
  $(document).ready(function () {
    $('form').submit(function () {
      var flag = true;
      $('input').each(function () {
          if($(this).attr('name')!=='password'){
              if ($(this).val() === '') {
                  flag = false;
                  alert($(this).attr('placeholder')+'不能为空');
              } 
          }
        
      });
      if (!flag) {
      	return false;
      }
      $('button').addClass('layui-btn-disabled');
      $.ajax({
        url:'install.php',
        data:$(this).serialize()+'&action=db',
        method:'POST',
        dataType:'json'
      }).done(function (data) {
        if (data.code) {
          alert('数据库导入成功，点击进行站点设置');
          location.href=data.href;
        } else {
          alert(data.error);
        }
      }).always(function () {
	      $('button').removeClass('layui-btn-disabled');
      });
      return false;
    })
  })
</script>
</body>
</html>