<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>安装向导 - 管理员设置</title>
  <link rel="stylesheet" href="assets/layui.css">
  <style>
    body {background: url('assets/background.jpg');}
    .head {background: url('assets/logo-b.png') center no-repeat;width: 100%;height: 200px;text-align: center;}
    .form {width: 400px;margin: 100px auto;}
    #remember {width: 100%;text-align: right;}
    #submit {width: 100%;text-align: center;}
  </style>
</head>
<body>
<div class="head"></div>
<div class="form">
  <form id="login" class="layui-form layui-form-pane">
    <div class="layui-form-item" pane>
      <label class="layui-form-label ">账号</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="username" placeholder="管理员账号">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label ">密码</label>
      <div class="layui-input-block">
        <input type="password" class="layui-input" name="password" placeholder="管理员密码" value="">
      </div>
    </div
    <div class="layui-form-item">
      <div id="submit" class="layui-input-inline">
        <button class="layui-btn layui-btn-warm">确定</button>
      </div>
    </div>
  </form>
</div>
<script src="assets/jquery.min.js"></script>
<script>
  $(document).ready(function () {
    alert('此处设置的账号为最高权限账号，无法查看/修改/删除，请谨慎设置并记住账号密码');
    $('form').submit(function () {
      $('input').each(function () {
        if ($(this).val() === '') {
          alert($(this).attr('placeholder')+'不能为空');
          return false;
        }
      });
      $.ajax({
        url:'install.php',
        data:$(this).serialize()+'&action=user',
        method:'POST',
        dataType:'json'
      }).done(function (data) {
        if (data.code) {
          alert('管理员设置完成，将跳转至后台登录页面，请确认已删除 install 文件夹');
          location.href=data.href;
        } else {
          alert(data.error);
        }
      });
      return false;
    })
  })
</script>
</body>
</html>