<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>安装向导 - 域名设置</title>
  <link rel="stylesheet" href="assets/layui.css">
  <style>
    body {background: url('assets/background.jpg');}
    .head {background: url('assets/logo-b.png') center no-repeat;width: 100%;height: 200px;text-align: center;}
    .form {width: 400px;margin: 100px auto;}
    #remember {width: 100%;text-align: right;}
    #submit {width: 100%;text-align: center;}
  </style>
</head>
<body>
<div class="head"></div>
<div class="form">
  <form id="login" class="layui-form layui-form-pane">
    <div class="layui-form-item" pane>
      <label class="layui-form-label ">网站协议</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="protocol" placeholder="网站协议" value="<?php echo strpos($_SERVER["SERVER_PROTOCOL"], 'HTTP') == 0 ? 'http' : 'https'; ?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label ">网站网址</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="hostname" placeholder="网站网址" value="<?php echo $_SERVER['HTTP_HOST'].(trim(strrchr(dirname(realpath(__DIR__)), DIRECTORY_SEPARATOR), DIRECTORY_SEPARATOR) == strchr(ltrim($_SERVER['REQUEST_URI'], '/'), '/', true) ? '/'.strchr(ltrim($_SERVER['REQUEST_URI'], '/'), '/', true) : '');?>">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label ">网址后缀</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="suffix" placeholder="网址后缀" value=".html">
      </div>
    </div>
    <div class="layui-form-item" pane>
      <label class="layui-form-label ">后台路径</label>
      <div class="layui-input-block">
        <input type="text" class="layui-input" name="admin" placeholder="后台路径" value="admin">
      </div>
    </div>
    <div class="layui-form-item">
      <div id="submit" class="layui-input-inline">
        <button class="layui-btn layui-btn-warm">配置网站</button>
      </div>
    </div>
  </form>
</div>
<script src="assets/jquery.min.js"></script>
<script>
  $(document).ready(function () {
    $('form').submit(function () {
      $('input').each(function () {
        if ($(this).val() === '') {
          alert($(this).attr('placeholder')+'不能为空');
          return false;
        }
      });
      $.ajax({
        url:'install.php',
        data:$(this).serialize()+'&action=set',
        method:'POST',
        dataType:'json'
      }).done(function (data) {
        if (data.code) {
          alert('站点设置完成，点击进行管理员设置');
          location.href=data.href;
        } else {
          alert(data.error);
        }
      });
      return false;
    })
  })
</script>
</body>
</html>