<?php namespace app\controllers;

use PHPMailer\PHPMailer\PHPMailer;
use sc\Controller;
use sc\Helper;

class IndexController extends Controller
{
    private $helper;

    public function __construct($template = null)
    {
        parent::__construct($template);

        $this->helper = new Helper();
        $this->helper->pageNumberStyle = [
            'tags'   => [
                'home' => '',
                'last' => '',
                'prev' => '&laquo;',
                'next' => '&raquo;',
                'jump' => ''
            ],
            'class'  => [
                'normal' => '',
                'active' => 'active',
                'home'   => '',
                'last'   => '',
                'prev'   => 'sc_pre',
                'next'   => 'sc_pre',
            ],
            'length' => 5
        ];
    }


    /*导航下拉菜单产品*/
    protected function getNavProTree($data, $clear = true)
    {
        if (!isset($prohtml)) {
            static $prohtml = '';
        }
        foreach ($data as $datum) {


                if ($datum['c_url'] != '') {
                    $url = $this->helper->url($datum['c_url']);

                } else {
                    $url = $this->helper->url($datum['id']);

                }


            if (isset($datum['sub'])) {
                $prohtml .= '<li><a href="' . $url . '">' . $datum['c_name'] . '</a><span></span><ul>';
                $this->getNavProTree($datum['sub']);
                $prohtml .= '</ul></li>';
            } else {
                $prohtml .= '<li><a href="' . $url . '">' . $datum['c_name'] . '</a></li>';
            }
        }
        return $prohtml;
    }

    /*导航下拉菜单新闻*/
    protected function getNavNewTree($data)
    {
        if (!isset($newhtml)) {
            static $newhtml = '';
        }
        foreach ($data as $datum) {

            if ($datum['c_url'] != '') {
                $url = $this->helper->url('news/' . $datum['c_url']);

            } else {
                $url = $this->helper->url('news/' . $datum['id']);

            }

            if (isset($datum['sub'])) {
                $newhtml .= '<li ><a href="' . $url . '">' . $datum['c_name'] . '</a><ul>';
                $this->getNavNewTree($datum['sub']);
                $newhtml .= '</ul></li>';
            } else {
                $newhtml .= '<li><a href="' . $url . '">' . $datum['c_name'] . '</a></li>';
            }
        }
        return $newhtml;
    }



    /*产品页面的分类*/
    protected function getProducts($data, $clear = true)
    {
        if (!isset($Prohtml)) {
            static $Prohtml = '';
        }
        foreach ($data as $datum) {
            if ($datum['c_url'] != '') {
                $listurl = $this->helper->url($datum['c_url']);

            } else {
                $listurl = $this->helper->url($datum['id']);

            }


            if (isset($datum['sub'])) {
                if($datum['pid']==1){
                    $Prohtml .= '<li><a href="'.$listurl.'"><span>'.$datum['c_name'].'</span><img src="'.$this->helper->to($datum['c_img']).'" alt=""></a><ul>';

                }else{
                    $Prohtml .= '<li class="yj_xiala"> <span><a href="'.$listurl.'">'.$datum['c_name'].'</a><b class="yjt_xiala sc_p_jia"></b></span><ul>';

                }
                $this->getProducts($datum['sub']);
                $Prohtml .= '</ul></li>';
            } else {
                if($datum['pid']==1){
                    $Prohtml .= '<li><a href="'.$listurl.'"><span>'.$datum['c_name'].'</span><img src="'.$this->helper->to($datum['c_img']).'" alt=""></a></li>';
                }else{
                    $Prohtml .= '<li> <span><a href="'.$listurl.'">'.$datum['c_name'].'</a></span> </li>';
                }
            }
        }
        return $Prohtml;
    }
    /*新闻分类*/
    /*产品页面的分类*/
    protected function getNews($data, $clear = true)
    {
        if (!isset($NewsHtml)) {
            static $NewsHtml = '';
        }
        foreach ($data as $datum) {
            if ($datum['c_url'] != '') {
                $listurl = $this->helper->url('news/'.$datum['c_url']);

            } else {
                $listurl = $this->helper->url('news/'.$datum['id']);

            }


            if (isset($datum['sub'])) {
                $NewsHtml.='<li><i></i><a href="'.$listurl.'">'.$datum['c_name'].'</a><ul>';
                $this->getNews($datum['sub']);
                $NewsHtml .= '</ul></li>';
            } else {
                if($datum['pid']==2){
                    $NewsHtml.='<li><i></i><a href="'.$listurl.'">'.$datum['c_name'].'</a></li>';
                }else{
                    $NewsHtml.='<li><a href="'.$listurl.'">'.$datum['c_name'].'</a></li>';
                }
            }
        }
        return $NewsHtml;
    }
    /*分类下所有产品*/
    protected function getProduct($data)
    {
        if (!isset($Pid)) {
            static $Pid = '';
        }
        foreach ($data as $value) {

            if (isset($value['sub'])) {
                $Pid .= $value['id'] . ',';
                $this->getProduct($value['sub']);
            } else {
                $Pid .= $value['id'] . ',';
            }
        }
        return $Pid;
    }
    //获取IP方法
    function getRealIp()
    {
        $ip=false;
        if(!empty($_SERVER["HTTP_CLIENT_IP"])){
            $ip = $_SERVER["HTTP_CLIENT_IP"];
        }
        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ips = explode (", ", $_SERVER['HTTP_X_FORWARDED_FOR']);
            if ($ip) { array_unshift($ips, $ip); $ip = FALSE; }
            for ($i = 0; $i < count($ips); $i++) {
                if (!eregi ("^(10│172.16│192.168).", $ips[$i])) {
                    $ip = $ips[$i];
                    break;
                }
            }
        }
        return ($ip ? $ip : $_SERVER['REMOTE_ADDR']);
    }
    /*共享参数*/
    protected function GetAll($url = null)
    {
        $GetAll = array();
        $NavigationHtml = '';//导航
        $html = '';//小购物车
        $id = '';//产品id
        $cookieHtml='';//小购物车显示
        $coinHtml = '';//货币设置
        $coinhtml = '';//货币设置
        $footerHtml = '';//尾部分类
        $total_price = '';//总价格
        $checkHtml = '';//支付路径
        $CrumbHtml = '';//新闻详细页面包屑
        $aboutlist = '';//about
        $aboutlists='';//weibu about
        $countryHtml = '';//国家下拉框
        /*cookie名字切换*/
        $GetAll['Name']='feng';
        /*获取当前时间*/
        $GetAll['time'] = date('Y-m-d H:i:s');
        /*获取当前IP*/
        $GetAll['ip'] = $this->getRealIp();
        /*文字标签*/
        $translates = $this->db->table('page')->find('p_tags')->where('p_lang=\'' . LANG . '\'')->one();
        $translates = json_decode($translates['p_tags'], true);
        $GetAll['translates'] = $translates;





        /*导航*/
        $NavigationOb = $this->db->table('nav')->find('n_name,n_url')->where('n_lang=\'' . LANG . '\' and n_sort!=0')->order('n_sort')->all();

        $productlist = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->order('c_sort')->all(), 1);

        $newslist = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->order('c_sort')->all(), 2);
        /*产品下拉显示*/
        $productlist = $this->getNavProTree($productlist);
        /*新闻下拉显示*/
        $newslist = $this->getNavNewTree($newslist);
        if ($NavigationOb !== false) {
            foreach ($NavigationOb as $value) {
                switch ($value['n_url']) {
                    case 'product':
                        $NavigationHtml .= '
                        <li>
                        <a href="' . $this->helper->url($value['n_url']) . '">' . $value['n_name'] . '</a><i></i><ul>' . $productlist . '</ul>
                    </li>';
                        break;
                    case 'news':
                        $NavigationHtml .= '
                        <li>
                        <a href="' . $this->helper->url($value['n_url']) . '">' . $value['n_name'] . '</a><i></i><ul>' . $newslist . '</ul>
                    </li>';
                        break;
                    case '/':
                        $NavigationHtml .= '
                        <li>
                        <a href="' . $this->helper->to('/') . '">' . $value['n_name'] . '</a>
                    </li>';
                        break;
                    default:
                        $NavigationHtml .=
                            '<li>
                        <a href="' . $this->helper->url($value['n_url']) . '">' . $value['n_name'] . '</a>
                    </li>';
                }
            }
        }
        $GetAll['NavigationHtml'] = $NavigationHtml;

        /*邮箱订阅*/
        if ($this->request->post('f_form')) {
            if (!(bool)preg_match('/[\w-_]+@[\w-_][\.\w]+/', $_POST['f_form'])) {
                echo '<script>alert(\'Email is illegal\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
            } else {
                $email = $this->db->table('mail')->find('id')->where('m_mail=\'' . $_POST['f_form'] . '\'')->one();
                if ($email == false) {
                    $_POST['m_mail'] = $_POST['f_form'];
                    unset($_POST['f_form']);
                    $_POST['m_time'] = $GetAll['time'];
                    $_POST['m_ip'] = ip2long($GetAll['ip']);
                    $message = $this->db->table('mail')->insert($_POST)->row();
                    if ($message==1) {
                        echo '<script>alert(\'Subscribe to the success\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
                    } else {
                        echo '<script>alert(\'Subscribe to the failure\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
                    }
                } else {
                    echo '<script>alert(\'You are already subscribed\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
                }
            }
        }


        /*参数设置*/
        $ConfigOb = $this->db->table('conf')->find('c_logo,c_shares,c_phone,c_name,c_email,c_local,c_copy,c_icon,c_whats')->one();
        $GetAll['ConfigOb'] = $ConfigOb;

        return $GetAll;

    }

    /*语种管理*/
    protected
    function setLang()
    {
        $html = [];
        $helper = new Helper();
        $lang = $this->db->table('lang')->find('l_word,l_name,l_main,l_title,l_flag')->where('l_on=1')->order('l_sort')->all();

        foreach ($lang as $key => $value) {
            if ($value['l_word'] == LANG) {
                if ($value['l_main'] == 1) {
                    array_unshift($html, '<a href="' . $helper->to('/') . '"><img src="' . $helper->to($value['l_flag']) . '" alt="">'.$value['l_title'].'<i></i></a><ul>');
                } else {
                    array_unshift($html, '<a href="' . $helper->to('/') . $value['l_word'] . '"><img src="' . $helper->to($value['l_flag']).'" alt="">'.$value['l_title'].'<i></i></a><ul>');
                }
            } else {
                if ($value['l_main'] == 1) {
                    array_push($html, '<li><a href="' . $helper->to('/') . '"><img src="' . $helper->to($value['l_flag']) .'" alt="">'.$value['l_title'].'</a></li>');
                } else {
                    array_push($html, '<li><a href="' . $helper->to('/') . $value['l_word'] . '"><img src="' . $helper->to($value['l_flag']) .'" alt="">'.$value['l_title'].'</a></li>');
                }
            }
        }

        $html[] = '</ul>';

        return implode('', $html);
    }




    /*前台首页*/
    public
    function actionIndex($url = null, $page = 1)
    {
        if (empty($url)) {
            /*调用*/
            $GetAll = $this->GetAll();//导航
            $lang = $this->setLang();//语种
            $CarouselHtml = '';//轮播
            $ImageHtml = '';//首页推荐产品
            $Carousenum='';//产品轮播数字
            $servicehtml='';//首页服务项目
            $serviceNum='';//服务我们轮播数量
            $NewsHtml='';//首页新闻显示
            /*title 关键词描述*/
            $IndexTitle = $this->db->table('page')->find('h_kwd,h_des,h_til')->where('p_lang=\'' . LANG . '\'')->one();
            /*首页轮播*/
            $Carousel = $this->db->table('banner')->find('b_image,b_url,id,b_text')->where('b_type=\'home\' and b_lang=\'' . LANG . '\'')->all();
            if (!empty($Carousel)) {
                $m=0;
                foreach ($Carousel as $value) {
                    if ($value['b_image'] !== '') {
                        if($m==0){
                            $CarouselHtml.='<div class="item active">
                                                <a href="">
                                                    <img src="'.$this->helper->to($value['b_image']).'">
                                                </a>
                                            </div>';
                            $Carousenum='<li data-target="#banner" data-slide-to="'.$m.'" class="active"></li>';
                        }else{
                            $CarouselHtml.='<div class="item">
                                                <a href="">
                                                    <img src="'.$this->helper->to($value['b_image']).'">
                                                </a>
                                            </div>';
                            $Carousenum.='<li data-target="#banner" data-slide-to="'.$m.'"></li>';
                        }
                    } else {
                        $CarouselHtml .= '';
                    }
                $m++;
                }
            }else{
                $CarouselHtml = '';
            }



            /*首页关于我们*/
            $about=$this->db->table('info')->find('id,i_url,i_kwd,i_des,i_details,i_img')->where('i_on=1 and i_lang=\''.LANG.'\' and i_cate=4')->order('i_sort')->one();
            if($about!==false){
                $about['i_details'] = mb_strlen($about['i_details']) > 200 ? mb_substr($about['i_details'], 0, 1000, 'utf-8') . '...' : $about['i_details'];
            }else{
                $about['i_details']='';
            }


            /*首页服务我们*/
            $service=$this->db->table('info')->find('id,i_url,i_kwd,i_des,i_details,i_img,i_auth')->where('i_on=1 and i_lang=\''.LANG.'\' and i_cate=5')->order('i_sort')->limit(0,6)->all();
            if(!empty($service)){
                $servicenum=1;
                foreach($service as $value){
                    $value['i_details'] = mb_strlen($value['i_details']) > 500 ? mb_substr(strip_tags($value['i_details']), 0, 500, 'utf-8') . '...' : strip_tags($value['i_details']);
                    $servicehtml.='
                        <li>
                                    <div class="pic"><img src="'.$this->helper->to($value['i_img']).'" /></div>
                                    <div >
                                        <p>
                                            '.$value['i_details'].'
                                        </p>
                                        <p><strong>'.$value['i_auth'].'</strong></p>
                                    </div>
                                </li>
                    ';
                    $serviceNum.='<li>$servicenum</li>';
                    $servicenum++;
                }
            }else{
                $servicehtml='';
                $serviceNum='';
            }
            /*首页推荐产品*/
            $IndexImage = $this->db->table('product')->find('p_img,p_url,id,p_name')->where('p_on=1 and p_lang=\'' . LANG . '\' and p_re=1')->order('p_sort')->limit(0, 4)->all();
            if ($IndexImage != false) {
                foreach ($IndexImage as $value) {
                    $value['p_img'] = explode(',', $value['p_img'])[0];
                    if ($value['p_url'] !== '') {
                        $ImageUrl = $this->helper->url($value['p_url'], false);
                    } else {
                        $ImageUrl = $this->helper->url( $value['id'], false);
                    }
                        $ImageHtml .= '
                             <div class="col-md-3 col-xs-6">
                                 <dl>
                                     <dt >
                                         <a href="'.$ImageUrl.'">
                                             <img src="'.$value['p_img'].'" alt="'.$value['p_name'].'">
                                         </a>
                                     </dt>
                                     <dd class="p_title">
                                         <a href="'.$ImageUrl.'">'.$value['p_name'].'</a>
                                     </dd>
                                     <dd class="p_inquiry">
                                         <a href="'.$ImageUrl.'">'.ucwords($GetAll['translates']['inquiry']).'</a>
                                     </dd>
                                 </dl>
                             </div>
                       ';
                }
            }else{
                $ImageHtml='';
            }
            /*首页新闻显示*/
            $News = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), 2);
            if (!empty($News)) {
                $AllId = $this->getProduct($News);;
            } else {
                $AllId = '';
            }
            if($AllId!=''){
                $AllId = explode(',', trim($AllId, ','));
                $i_cate = '';
                foreach ($AllId as $value) {
                    $i_cate .= 'i_cate LIKE \'%' . $value . '%\' OR ';
                }
                $i_cate = substr($i_cate, 0, -4);
                $news = $this->db->table('info')->find('id,i_name,i_url,i_img,i_time,i_details,i_time')->where('i_on=? and i_lang=? and (' . $i_cate . ')', [1, LANG])->order('i_sort')->limit(0,3)->all();
                if(!empty($news)){
                    foreach($news as $value){
                        if($value['i_url']!=''){
                            $NewsUrl=$this->helper->url('news-details/'.$value['i_url'],false);
                        }else{
                            $NewsUrl=$this->helper->url('news-details/'.$value['i_url'],false);
                        }
                        $value['i_time']=explode(' ',$value['i_time'])[0];
                        $NewsHtml.='
                        <div class="col-md-4 col-sm-6">
                    <dl>
                        <dt>
                            <a href="'.$NewsUrl.'">
                                <img src="'.$this->helper->to($value['i_img']).'" alt="">
                            </a>
                        </dt>
                        <dd class="in_name">
                            <a href="'.$NewsUrl.'">
                                '.$value['i_name'].'
                            </a>
                        </dd>
                        <dd class="in_date">
                            '.$value['i_time'].'
                        </dd>
                    </dl>
                </div>';   
                    }
                }
            }
            

            /*发送*/
            $this->render('index', [
                'helper' => new Helper,
                'IndexTitle' => $IndexTitle,//关键词描述
                'GetAll' => $GetAll,//公用的信息
                'lang' => $lang,//语种
                'CarouselHtml' => $CarouselHtml,//轮播
                'ImageHtml' => $ImageHtml,//首页两张图片
                'Carousenum'=>$Carousenum,//banner数字显示
                'about'=>$about,//首页关于我们
                'servicehtml'=>$servicehtml,//首页服务我们
                'serviceNum'=>$serviceNum,//服务我们轮播数量
                'NewsHtml'=>$NewsHtml,//首页新闻显示
            ]);
        } else {
            if ('/' != SUFFIX) {
                $this->actionProductDetails($url);
            } else {
                $this->actionProduct($url, $page);
            }
        }

    }

    /*关于我们*/
    public
    function actionAbout($url = null)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $aboutHtml = '';//关于我们
        /*banner*/
        $banner=$this->db->table('banner')->find('b_image')->where('b_lang=\''.LANG.'\' and b_type=\'info\'')->order('b_sort')->one();
        if($banner!==false){
            $bannerimage='<img src="'.$this->helper->to($banner['b_image']).'" alt="">';
        }else{
            $bannerimage='';
        }
        /*显示*/
        $about=$this->db->table('info')->find('id,i_url,i_kwd,i_des,i_details,i_img,i_name')->where('i_on=1 and i_lang=\''.LANG.'\' and i_cate=4')->order('i_sort')->one();
        $this->render('about', [
            'helper' => new Helper,
            'GetAll' => $GetAll,
            'lang' => $lang,
            'bannerimage'=>$bannerimage,//banner
            'about' => $about,
        ]);
    }


    /*搜索*/
    public function actionSearch($page = 1)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $ProductHtml = '';//产品显示
        /*商品没页显示数量*/
        $pagenum = $this->db->table('conf')->find('c_p_list')->one();
        /*title 关键词描述*/
        $ProductTitle = $this->db->table('page')->find('p_kwd,p_des')->where('p_lang=\'' . LANG . '\'')->one();
        /*标题和关键字搜索*/
        if ('' != $search = $this->request->get('top_input')) {

            $search = str_replace('%', '?', $search);
            $counts = $this->db->table('product')->count('p_on=1 and (p_name LIKE \'%' . $search . '%\' or p_kwd LIKE \'%' . $search . '%\') and p_lang=\'' . LANG . '\'');
            $ProductAll = $this->db->table('product')->find('id,p_name,p_url,p_img,p_price,p_sales')->where('p_on =1 and (p_name LIKE \'%' . $search . '%\' or p_kwd LIKE \'%' . $search . '%\') and p_lang=\'' . LANG . '\'')->limit(($page - 1) * $pagenum['c_p_list'], $pagenum['c_p_list'])->all();
            $u = $this->helper->url('search', true, ['top_input' => $search]);
            if (0 < $counts && $counts>$pagenum['c_p_list']) {
                $pager = $this->helper->pageNumber($u, $counts, $pagenum['c_p_list'], $page)['html'];
            } else {
                $pager = '';
            }
            if (!empty($ProductAll)) {
                foreach ($ProductAll as $value) {
                    /*显示*/
                    $value['p_img'] = explode(',', $value['p_img'])[0];
                    if ($value['p_url'] != '') {
                        $searchurl = $this->helper->url($value['p_url'], false);
                    } else {
                        $searchurl = $this->helper->url($value['id'], false);
                    }
                    $ProductHtml .= '
                            <div class="col-md-3 col-xs-6">
                        <dl>
                            <dt >
                                <a href="'.$searchurl.'">
                                    <img src="'.$this->helper->to($value['p_img']).'" alt="'.$value['p_name'].'">
                                </a>
                            </dt>
                            <dd class="p_title">
                                <a href="'.$searchurl.'">'.$value['p_name'].'</a>
                            </dd>
                            <dd class="p_inquiry">
                                <a href="'.$searchurl.'">'.$GetAll['translates']['inquiry'].'</a>
                            </dd>
                        </dl>
                    </div>
                    ';
                }
            } else {
                $pager = '';
                $ProductHtml = '<p class="sc_no_f">' . $GetAll['translates']['No-relevant-products-have-been-found'] . '</p>';
            }
        } else {
            $pager = '';
            $ProductHtml = '<p class="sc_no_f">' . $GetAll['translates']['No-relevant-products-have-been-found'] . '</p>';
        }


        $this->render('search', [
            'helper' => new Helper,
            'GetAll' => $GetAll,
            'lang' => $lang,
            'ProductHtml' => $ProductHtml,
            'ProductTitle' => $ProductTitle,
            'pager' => $pager,
        ]);
    }


    /*联系我们*/
    public
    function actionContact($url = null)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $queryHtml = '';//留言显示
        /*title 关键词描述*/
        $ContactTitle = $this->db->table('page')->find('i_kwd,i_des')->where('p_lang=\'' . LANG . '\'')->one();
        /*留言*/
        if ($this->request->post('c_fname') && $this->request->post('c_lname') && $this->request->post('c_email')&& $this->request->post('c_phone')&& $this->request->post('c_mes')) {

            if (!(bool)preg_match('/[\w-_]+@[\w-_][\.\w]+/', $_POST['c_email'])) {
                echo '<script>alert(\'Email is illegal\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
            } else {
                $contact['q_email'] = $this->request->post('c_email');
                $contact['q_cont'] = $this->request->post('c_mes');
                $contact['q_phone']=$this->request->post('c_phone');
                $contact['q_time'] = $GetAll['time'];
                $contact['q_ip'] = ip2long($GetAll['ip']);
                $message = $this->db->table('query')->insert($contact)->row();
                if ($message) {
                        $params = $this->db->table('conf')->find('c_name, c_account,c_consult,c_ciphers, c_smtp, c_port, c_address')->where('id = ?', ['sem-cms'])->one();
                        if ($params != false) {
                            foreach ($params as $index => $param) {
                                $params[substr($index, 2)] = $param;
                            }
                            $params['subject'] ='留言通知';
                            $content = '
                                <table>
                                    <tr>
                                        <td align="right">邮箱：</td>
                                        <td>'.$contact['q_email'].'</td>
                                    </tr>
                                    <tr>
                                        <td align="right">电话：</td>
                                        <td>'.$contact['q_phone'].'</td>
                                    </tr>
                                    <tr>
                                        <td align="right">留言内容：</td>
                                        <td>'.$contact['q_cont'].'</td>
                                    </tr>
                                </table>
                            ';
                            $this->helper->mail($params, $params['c_consult'], $content);
                        }
                    echo '<script>alert(\'Subscribe to the success\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
                } else {
                    echo '<script>alert(\'Subscribe to the failure\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
                }

            }
        }
        /*留言显示*/
        $query = $this->db->table('page')->find('c_des')->where('p_lang=\'' . LANG . '\'')->one();

        if ($query !== false) {
            $queryHtml = $query['c_des'];
        } else {
            $queryHtml = '';
        }
        if ($url) {
            header('location:' . $this->helper->url('no-found') . '');
        }
        $this->render('contact', [
            'helper' => new Helper,
            'GetAll' => $GetAll,
            'lang' => $lang,
            'ContactTitle' => $ContactTitle,
            'queryHtml' => $queryHtml,
        ]);
    }
    public
    function actionProduct($url = null, $page = 1)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $producthtml = '';//产品显示
            /*商品没页显示数量*/
            $pagenum = $this->db->table('conf')->find('c_p_list')->one();
            /*产品显示*/
            //查出所有该点击项下面的分类ID
            if (is_numeric($url)) {
                $count = ceil($this->db->table('product')->count('p_on = 1 AND p_lang = ?', [LANG]) / $pagenum['c_p_list']);

                $id = $this->db->table('cate')->find('c_name,id')->where('c_on=1 and id=\'' . $url . '\' and c_lang=\'' . LANG . '\'')->one();
                $show_name = $id['c_name'];
                if ($url <= $count) {
                    /*title 关键词描述*/
                    $ProductTitle = $this->db->table('page')->find('p_kwd,p_des,p_til')->where('p_lang=\'' . LANG . '\'')->one();
                    if ($count <= 0 || $url < 1 || $url > $count) {
                       header('location:' . $this->helper->url('no-found') . '');
                    }
                    $show_name = $ProductTitle['p_til'];
                    $AllId = '';
                    $page = $url;
                } else {
                    $id = $this->db->table('cate')->find('c_name,id')->where('c_on=1 and id=\'' . $url . '\' and c_lang=\'' . LANG . '\'')->one();
                    if($id!=false){
                        /*title 关键词描述*/
                        $ProductTitle = $this->db->table('cate')->find('c_kwd,c_des')->where('id = ?', [$id['id']])->one();
                        $ProductTitle['p_kwd'] = $ProductTitle['c_kwd'];
                        $ProductTitle['p_des'] = $ProductTitle['c_des'];
                        unset($ProductTitle['c_kwd'], $ProductTitle['c_des']);
                        $Products = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), $url);
                        if (!empty($Products)) {
                            $AllId = $url . ',' . $this->getProduct($Products);;
                        } else {
                            $AllId = $url;
                        }
                    }else{
                        header('location:' . $this->helper->url('no-found') . '');
                    }


                }
            } else {
                if ($url != null) {

                    $id = $this->db->table('cate')->find('c_name,id')->where('c_on=1 and c_url=\'' . $url . '\' and c_lang=\'' . LANG . '\'')->one();
                    $show_name = $id['c_name'];
                    if ($id == false) {
                            header('location:' . $this->helper->url('no-found') . '');
                    } else {
                        /*title 关键词描述*/
                        $ProductTitle = $this->db->table('cate')->find('c_kwd,c_des')->where('id = ?', [$id['id']])->one();
                        $ProductTitle['p_kwd'] = $ProductTitle['c_kwd'];
                        $ProductTitle['p_des'] = $ProductTitle['c_des'];
                        unset($ProductTitle['c_kwd'], $ProductTitle['c_des']);
                        $Products = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), $id['id']);
                        if (!empty($Products)) {
                            $AllId = $id['id'] . ',' . $this->getProduct($Products);
                        } else {
                            $AllId = $id['id'];
                        }
                    }
                } else {
                    /*title 关键词描述*/
                    $ProductTitle = $this->db->table('page')->find('p_kwd,p_des,p_til')->where('p_lang=\'' . LANG . '\'')->one();
                    $show_name = $ProductTitle['p_til'];
                    $AllId = '';
                }
            }
            //查出商品
            if ($AllId != '') {
                $AllId = explode(',', trim($AllId, ','));
                $p_cate = '';
                foreach ($AllId as $value) {
                    $p_cate .= 'P_cate LIKE \'%,' . $value . ',%\' OR ';
                }
                $p_cate = substr($p_cate, 0, -4);
                $count = $this->db->table('product')->count('p_on=? and p_lang=? and (' . $p_cate . ')', [1, LANG]);
                $product = $this->db->table('product')->find('id,p_name,p_url,p_img,p_price,p_sales')->where('p_on=? and p_lang=? and (' . $p_cate . ')', [1, LANG])->order('p_sort')->limit(($page - 1) * $pagenum['c_p_list'], $pagenum['c_p_list'])->all();
                $u = $this->helper->url($url);
                if (0 < $count && $count>$pagenum['c_p_list']) {
                    $pager = $this->helper->pageNumber($u, $count, $pagenum['c_p_list'], $page)['html'];
                } else {
                    $pager = '';
                }
            } else {
                $count = $this->db->table('product')->count('p_on=? and p_lang=? ', [1, LANG]);
                $product = $this->db->table('product')->find('id,p_name,p_url,p_img,p_price,p_sales')->where('p_on=? and p_lang=? ', [1, LANG])->order('p_sort')->limit(($page - 1) * $pagenum['c_p_list'], $pagenum['c_p_list'])->all();
                $u = $this->helper->url('product');
                if (0 < $count && $count>$pagenum['c_p_list']) {
                    $pager = $this->helper->pageNumber($u, $count, $pagenum['c_p_list'], $page)['html'];
                } else {
                    $pager = '';
                }

            }
            if (!empty($product)) {
                foreach ($product as $value) {
                    if ($value['p_url'] != '') {
                        $producturl = $this->helper->url($value['p_url'], false);
                    } else {
                        $producturl = $this->helper->url($value['id'], false);
                    }

                    $value['p_img'] = explode(',', $value['p_img'])[0];
                    $producthtml .= '
                            <div class="col-md-3 col-xs-6">
                        <dl>
                            <dt >
                                <a href="'.$producturl.'">
                                    <img src="'.$this->helper->to($value['p_img']).'" alt="'.$value['p_name'].'">
                                </a>
                            </dt>
                            <dd class="p_title">
                                <a href="'.$producturl.'">'.$value['p_name'].'</a>
                            </dd>
                            <dd class="p_inquiry">
                                <a href="'.$producturl.'">'.$GetAll['translates']['inquiry'].'</a>
                            </dd>
                        </dl>
                    </div>
                    ';

                }
            } else {
                $producthtml .= '';
            }
            $this->render('product', [
                'helper' => new Helper,
                'GetAll' => $GetAll,
                'lang' => $lang,
                'producthtml' => $producthtml,
                'pager' => $pager,
                'ProductTitle' => $ProductTitle,//关键词描述
                'show_name' => $show_name,//title



            ]);
        }



    /*新闻*/
    public
    function actionNews($url = null, $page = 1)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $NewsHtml = '';//新闻显示
        $CrumbHtml = '';//新闻面包屑
        /*商品没页显示数量*/
        $pagenum = $this->db->table('conf')->find('c_i_list')->one();
        /*title 关键词描述*/
        $NewsTitle = $this->db->table('page')->find('i_kwd,i_des')->where('p_lang=\'' . LANG . '\'')->one();
        /*新闻显示*/
        //查出所有该点击项下面的分类ID
        if (is_numeric($url)) {
            $id = $this->db->table('cate')->find('c_name,id')->where('c_on=1 and id=\'' . $url . '\' and c_lang=\'' . LANG . '\'')->one();
            $newtitle = $this->db->table('cate')->find('c_kwd,c_des')->where('id=\'' . $id . '\'')->one();
            if ($newtitle != false) {
                $newtitle['i_kwd'] = $newtitle['c_kwd'];
                $newtitle['i_des'] = $newtitle['c_des'];
            } else {
                $newtitle = $this->db->table('page')->find('i_kwd,i_des,i_til')->where('p_lang=\'' . LANG . '\'')->one();
            }
            $show_name = $id['c_name'];
            if ($id == false) {
                $count = ceil($this->db->table('info')->count('i_on = 1 AND i_lang = ?', [LANG]) / $pagenum['c_i_list']);
                if ($count <= 0 || $url < 1 || $url > $count) {
                    header('location:' . $this->helper->url('no-found') . '');
                }
                $show_name = $newtitle['i_til'];
                $News = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), 2);
                if (!empty($News)) {
                    $AllId = $this->getProduct($News);
                } else {
                    header('location:' . $this->helper->url('no-found') . '');
                }
                $page = $url;
                $url = '';
            } else {
                $News = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), $url);
                if (!empty($News)) {
                    $AllId = $url . ',' . $this->getProduct($News);
                } else {
                    $AllId = $url;
                }
            }
        } else {
            if ($url != null) {
                $id = $this->db->table('cate')->find('c_name,id')->where('c_on=1 and c_url=\'' . $url . '\' and c_lang=\'' . LANG . '\'')->one();
                $newtitle = $this->db->table('cate')->find('c_kwd,c_des')->where('c_url=\'' . $url . '\' and c_lang=\''.LANG.'\'  and c_on=1')->one();
                $newtitle['i_kwd'] = $newtitle['c_kwd'];
                $newtitle['i_des'] = $newtitle['c_des'];
                $show_name = $id['c_name'];
                if ($id == false) {
                    header('location:' . $this->helper->url('no-found') . '');
                } else {
                    $News = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), $id['id']);
                    if (!empty($News)) {
                        $AllId = $id['id'] . ',' . $this->getProduct($News);
                    } else {
                        $AllId = $id['id'];
                    }
                }
            } else {
                $newtitle = $this->db->table('page')->find('i_kwd,i_des,i_til')->where('p_lang=\'' . LANG . '\'')->one();
                $News = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), 2);
                $show_name = $newtitle['i_til'];
                if (!empty($News)) {
                    $AllId = $url . ',' . $this->getProduct($News);;
                } else {
                    $AllId = $url;
                }
            }
        }


        //查出新闻
        if ($AllId != '') {
            $AllId = explode(',', trim($AllId, ','));
            $i_cate = '';
            foreach ($AllId as $value) {
                $i_cate .= 'i_cate LIKE \'%' . $value . '%\' OR ';
            }
            $i_cate = substr($i_cate, 0, -4);
            $count = $this->db->table('info')->count('i_on=? and i_lang=? and (' . $i_cate . ')', [1, LANG]);

            $news = $this->db->table('info')->find('id,i_name,i_url,i_img,i_time,i_details')->where('i_on=? and i_lang=? and (' . $i_cate . ')', [1, LANG])->order('i_sort')->limit(($page - 1) * $pagenum['c_i_list'], $pagenum['c_i_list'])->all();
            $u = $this->helper->url('news/' . $url);
            if (0 < $count && $count>$pagenum['c_i_list']) {
                $pager = $this->helper->pageNumber($u, $count, $pagenum['c_i_list'], $page)['html'];
            } else {
                $pager = '';
            }


        } else {
            $count = $this->db->table('info')->count('i_on=? and i_lang=? ', [1, LANG]);
        }
        $month = ['01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun ', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec'];

        /*显示所有新闻*/
        if (!empty($news)) {
            $i = 0;
            foreach ($news as $value) {
                $time=explode('-',(explode(' ',$value['i_time'])[0]));
                if ($value['i_img'] != '') {
                    $i++;
                    if ($value['i_url'] != '') {
                        $NewsUrl = $this->helper->url('news-details/' . $value['i_url'], false);
                    } else {
                        $NewsUrl = $this->helper->url('news-details/' . $value['id'], false);
                    }
                    $NewsHtml .= '
                        <div class="col-sm-6">
                <div class="row">
                    <div class="n_time col-sm-2">
                        <span class="n_date">'.$time[2].'</span>
                        <span class="n_year">'.$time[0].'</span>
                        <span class="n_month">'.$month[$time[1]].'</span>
                    </div>
                    <dl class="n_right col-sm-10">
                        <dt>
                            <a href="'.$NewsUrl.'">
                                <img src="'.$this->helper->to($value['i_img']).'" alt="" class="img-responsive">
                                <span><b>+</b></span>
                            </a>
                        </dt>
                        <dd class="n_title">
                            <a href="'.$NewsUrl.'">'.$value['i_name'].'</a>
                        </dd>
                        <dd class="n_text">
                            '.$value['i_details'].'
                        </dd>
                    </dl>
                </div>
            </div>
                    ';
                } else {
                    $NewsHtml .= '';
                }
            }
        }

        $this->render('news', [
            'helper' => new Helper,
            'GetAll' => $GetAll,
            'lang' => $lang,
            'CrumbHtml' => $CrumbHtml,//面包屑
            'show_name' => $show_name,//标题
            'NewsHtml' => $NewsHtml,//新闻显示
            'pager' => $pager,//分页
            'newtitle' => $newtitle,//关键词描述
        ]);
    }


    /*新闻详细页*/
    public
    function actionNewsDetails($url = null)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $NewsHtml='';//最新新闻
        /*新闻显示*/
        if (is_numeric($url)) {
            $Newsdetails = $this->db->table('info')->find('i_name,i_url,id,i_img,i_cate,i_details,i_time,i_kwd,i_des,i_auth')->where('i_on=1 and id=\'' . $url . '\' and i_lang=\'' . LANG . '\'')->one();
            $Newsdetails['i_time']=explode(' ',$Newsdetails['i_time'])[0];
        } else {
            if ($url != null) {
                $Newsdetails = $this->db->table('info')->find('i_name,i_cate,i_url,id,i_img,i_details,i_time,i_kwd,i_des,i_auth')->where('i_on=1  and i_url=\'' . $url . '\' and i_lang=\'' . LANG . '\'')->one();
                $Newsdetails['i_time']=explode(' ',$Newsdetails['i_time'])[0];
            } else {
                $Newsdetails = null;
                header('location:'.$this->helper-url('news').'');
            }

        }
        if ($Newsdetails == false && $Newsdetails != null) {
            header('location:' . $this->helper->url('no-found') . '');
        }else{
           $catename=$this->db->table('cate')->find('c_name')->where('c_on=1 and c_lang=\''.LANG.'\' and id=\''.$Newsdetails['i_cate'].'\'')->one();
        }
        /*分类*/
        $newslist = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->order('c_sort')->all(), 2);
        $NewHtml=$this->getNews($newslist);
        /*最新新闻*/
        $newtitle = $this->db->table('page')->find('i_kwd,i_des')->where('p_lang=\'' . LANG . '\'')->one();
        $News = $this->helper->subTree($this->db->table('cate')->find('c_name,c_url,pid,id')->where('c_on=1 and c_lang=\'' . LANG . '\'')->all(), 2);
        if (!empty($News)) {
            $AllId = $url . ',' . $this->getProduct($News);;
        } else {
            $AllId = $url;
        }
        if ($AllId != '') {
            $AllId = explode(',', trim($AllId, ','));
            $i_cate = '';
            foreach ($AllId as $value) {
                $i_cate .= 'i_cate LIKE \'%' . $value . '%\' OR ';
            }
            $i_cate = substr($i_cate, 0, -4);
            $news = $this->db->table('info')->find('id,i_name,i_url,i_img,i_time,i_details')->where('i_on=? and i_lang=? and (' . $i_cate . ')', [1, LANG])->order('i_time desc')->limit(0,4)->all();
        }
        /*显示所有新闻*/
        if (!empty($news)) {
            foreach ($news as $value) {
                $time=explode(' ',$value['i_time']);
                if ($value['i_img'] != '') {
                    if ($value['i_url'] != '') {
                        $NewsUrl = $this->helper->url('news-details/' . $value['i_url'], false);
                    } else {
                        $NewsUrl = $this->helper->url('news-details/' . $value['id'], false);
                    }
                    $NewsHtml .= '
                        <div class="media">
                        <div class="media-left">
                            <a href="'.$NewsUrl.'">
                                <img class="media-object" src="'.$this->helper->to($value['i_img']).'" alt="">
                            </a>
                        </div>
                        <div class="media-body">
                            <h4 class="media-heading">
                                <a href="'.$NewsUrl.'">
                                    '.$value['i_name'].'
                                </a>
                            </h4>
                            <p>
                                '.ucwords($GetAll['translates']['time']).' : '.$time[0].'
                            </p>
                        </div>
                    </div>
                    ';
                } else {
                    $NewsHtml .= '';
                }
            }
        }
        $this->render('news_details', [
            'helper' => new Helper,
            'GetAll' => $GetAll,
            'lang' => $lang,
            'NewsHtml'=>$NewsHtml,//最新新闻
            'NewHtml'=>$NewHtml,//新闻分类,
            'Newsdetails' => $Newsdetails,//显示新闻
            'catename'=>$catename,//分类
        ]);
    }


    /*产品详细页*/
    public
    function actionProductDetails($url = null)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $CrumbHtml = '';//面包屑
        $attr='';//产品属性
        $relatedproduct = '';//相关产品
        $relatedHtml = '';//相关产品展示
        $reviewHtml = '';//评论显示
        $images='';//图片显示
        $p_cate = '';


            //产品显示
            if (is_numeric($url)) {
                $ProductOne = $this->db->table('product')->find('id,p_name,p_img,p_type,p_url,p_details,p_price,p_metatitle,p_kwd,p_des,p_sales,p_attr,p_sale,p_stock,p_sku')->where('p_on=1 and id=\'' . $url . '\' and p_lang=\'' . LANG . '\'')->one();


            } else {
                if ($url != null) {
                    $ProductOne = $this->db->table('product')->find('id,p_name,p_img,p_type,p_url,p_details,p_price,p_metatitle,p_kwd,p_des,p_sales,p_attr,p_sale,p_stock,p_sku')->where('p_on=1 and p_url=\'' . $url . '\' and p_lang=\'' . LANG . '\'')->one();
                } else {
                    header('location:' . $this->helper->url('product'));
                }
            }

            if ($ProductOne == false) {
                
                header('location:' . $this->helper->url('no-found') . '');
            } else {
                
              if(!empty($ProductOne['p_metatitle'])){
                    $ProductOne['p_metatitle']=$ProductOne['p_metatitle'];
                }else{
                    $ProductOne['p_metatitle']=$ProductOne['p_name'];
                }
                if ($ProductOne['p_img'] != '') {
                    $i = 0;
                    $p_img = explode(',', $ProductOne['p_img'])[0];
                    foreach (explode(',', $ProductOne['p_img']) as $value) {
                        if ($i = 0) {
                            $images .= '<li class="item item-cur" data-src="' . $this->helper->to($value) . '"><img src="' . $this->helper->to($value) . '" alt=""></li>';
                        } else {
                            $images .= '<li class="item" data-src="' . $this->helper->to($value) . '"><img src="' . $this->helper->to($value) . '" alt=""></li>';

                        }
                    }

                    /*产品属性*/

                    foreach(json_decode($ProductOne['p_attr'],true) as $key=>$value){
                        $attr.=' <li>
                        <stong>'.$key.':</stong>'.$value[1]['text'].'
                    </li>';
                    }
                } else {
                    $attr='';
                    $p_img = '';
                }
            }

            /*相关产品*/

            if (is_numeric($url)) {
                $related = $this->db->table('product')->find('id,p_url,p_related,p_sales,p_img,p_name,p_cate,p_price')->where('p_on=1 and id=\'' . $url . '\' and p_lang=\'' . LANG . '\'')->one();
            } else {
                $related = $this->db->table('product')->find('id,p_url,p_related,p_img,p_sales,p_name,p_cate,p_price')->where('p_on=1 and p_url=\'' . $url . '\' and p_lang=\'' . LANG . '\'')->one();
            }
            if ($related['p_related'] != '') {
                $related['id'] = explode(',', $related['p_related']);
                foreach ($related['id'] as $value) {
                    $relatedproduct[] = $this->db->table('product')->find('id,p_url,p_related,p_sales,p_price,p_img,p_name,p_cate')->where('p_on=1 and id=\'' . $value . '\' and p_lang=\'' . LANG . '\'')->one();
                }
            } else {

                if (is_numeric($url)) {

                    $cate = $this->db->table('product')->find('p_cate')->where('p_on=1 and id=\'' . $related['id'] . '\' and p_lang=\'' . LANG . '\'')->one();
                    $cateid = explode(',', trim($cate['p_cate'], ','));
                } else {
                    $cate = $this->db->table('product')->find('p_cate')->where('p_on=1 and p_url=\'' . $related['p_url'] . '\' and p_lang=\'' . LANG . '\'')->one();
                    $cateid = explode(',', trim($cate['p_cate'], ','));
                }
                foreach ($cateid as $value) {
                    $p_cate .= 'P_cate LIKE \'%,' . $value . ',%\' OR ';

                }
                $p_cate = substr($p_cate, 0, -4);
                $relateds = $this->db->table('product')->find('id')->where('p_on=? and p_lang=? and (' . $p_cate . ')', [1, LANG])->all();


                foreach ($relateds as $value) {
                    $v = join(',', $value);
                    $stmp[] = $v;
                    $stmp = array_unique($stmp);
                }

                foreach ($stmp as $value) {
                    $relatedproduct[] = $this->db->table('product')->find('id,p_url,p_related,p_img,p_name,p_cate,p_sales,p_price')->where('p_on=1 and id=\'' . $value . '\' and p_lang=\'' . LANG . '\'')->one();
                }

            }

            /*相关产品显示*/
            foreach ($relatedproduct as $value) {
                if ($value['p_img'] != '') {
                    if ($value['p_url'] != '') {
                        $relatedurl = $this->helper->url($value['p_url'], false);
                    } else {
                        $relatedurl = $this->helper->url($value['id'], false);
                    }
                    $value['p_img'] = explode(',', $value['p_img'])[0];
                    $relatedHtml.='
                        <li class="col-md-3 col-xs-6">
                        <dl>
                            <dt >
                                <a href="'.$relatedurl.'">
                                    <img src="'.$this->helper->to($value['p_img']).'" alt="'.$value['p_name'].'">
                                </a>
                            </dt>
                            <dd class="p_title">
                                <a href="'.$relatedurl.'">'.$value['p_name'].'</a>
                            </dd>
                            <dd class="p_inquiry">
                                <a href="'.$relatedurl.'">'.ucwords($GetAll['translates']['inquiry']).'</a>
                            </dd>
                        </dl>
                    </li>
                    ';
                } else {
                    $relatedHtml .= '';
                }


            }
            /*询盘*/
        if ($this->request->post('c_fname') && $this->request->post('c_lname') && $this->request->post('c_email')&& $this->request->post('c_phone')&& $this->request->post('c_mes')) {

            if (!(bool)preg_match('/[\w-_]+@[\w-_][\.\w]+/', $_POST['c_email'])) {
                echo '<script>alert(\'Email is illegal\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
            } else {
                $contact['q_name'] = $ProductOne['p_name'];
                $contact['q_email'] = $this->request->post('c_email');
                $contact['q_cont'] = $this->request->post('c_mes');
                $contact['q_phone']=$this->request->post('c_phone');
                $contact['q_time'] = $GetAll['time'];
                $contact['q_ip'] = ip2long($GetAll['ip']);
                $contact['q_id']=$ProductOne['id'];
                $contact['q_sku']=$ProductOne['p_sku'];
                $message = $this->db->table('query')->insert($contact)->row();
                if ($message) {
                    $params = $this->db->table('conf')->find('c_name, c_account,c_consult,c_ciphers, c_smtp, c_port, c_address')->where('id = ?', ['sem-cms'])->one();
                    if ($params != false) {
                        foreach ($params as $index => $param) {
                            $params[substr($index, 2)] = $param;
                        }
                        $params['subject'] = '留言通知';
                        $content = '
                                <table>
                                    <tr>
                                        <td align="right">邮箱：</td>
                                        <td>' . $contact['q_email'] . '</td>
                                    </tr>
                                    <tr>
                                        <td align="right">产品名称：</td>
                                        <td>' . $contact['q_name'] . '</td>
                                    </tr>
                                    <tr>
                                        <td align="right">sku：</td>
                                        <td>' . $contact['q_sku'] . '</td>
                                    </tr>
                                    <tr>
                                        <td align="right">电话：</td>
                                        <td>' . $contact['q_phone'] . '</td>
                                    </tr>
                                    <tr>
                                        <td align="right">留言内容：</td>
                                        <td>' . $contact['q_cont'] . '</td>
                                    </tr>
                                </table>
                            ';
                        $this->helper->mail($params, $params['c_consult'], $content);
                    }
                    echo '<script>alert(\'Subscribe to the success\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
                } else {
                    echo '<script>alert(\'Subscribe to the failure\');window.location.href=\'' . $_SERVER['HTTP_REFERER'] . '\';</script>';
                }

            }
        }





            $this->render('product_details', [
                'helper' => new Helper,
                'GetAll' => $GetAll,
                'lang' => $lang,
                'ProductOne' => $ProductOne,
                'CrumbHtml' => $CrumbHtml,
                'relatedHtml' => $relatedHtml,
                'attr' => $attr,
                'reviewHtml' => $reviewHtml,//评论显示
                'images'=>$images,//多图显示
                'p_img'=>$p_img,//单图显示
            ]);
        }



    /*服务*/
    public
    function actionService($url = null)
    {
        /*调用*/
        $GetAll = $this->GetAll();//导航
        $lang = $this->setlang();//语种
        $serviceHtml='';//服务我们
        $service=$this->db->table('info')->find('i_name,i_details,i_auth')->where('i_on=1 and i_lang=\''.LANG.'\'  and i_cate=5')->order('i_sort')->all();
        if(!empty($service)){
            foreach($service as $value){
                $serviceHtml.='
            <div class="ser_o_title">'.$value['i_name'].'</div>
                    <ul>
                        <li >'.$value['i_auth'].'</li>
                        <li class="ser_t">
                           '.$value['i_details'].'
                        </li>
                    </ul>
            ';
            }

        }else{
            $serviceHtml='';
        }
        /*关键词描述*/
        $kwd=$this->db->table('page')->find('i_kwd,i_des')->where('p_lang=\''.LANG.'\'')->one();



        $this->render('service', [
            'helper' => new Helper,
            'GetAll' => $GetAll,
            'lang' => $lang,
            'serviceHtml'=>$serviceHtml,//服务我们
            'kwd'=>$kwd,//关键词
        ]);
    }
    public
    function actionNoFound()
    {
        $this->render('no_found', [
            'helper' => new Helper(),
        ]);
    }

    public
    function actionError()
    {
        header('location:' . $this->helper->url('no-found') . '');
    }
}