<?php
/***
 *----------------------------------------------------------------------------*
 * 版权所有 2010-2016 HuCart.COM，并保留所有权利。
 * 此程序是HuCart的一部分。  
 * 根据MIT许可证授权(在软件和软件的所有副本中都必须包含版权声明和许可声明。)
 * 官方网址:http://www.hucart.com
 *
 * 对于完整的版权和许可证信息，请参阅MIT-LICENSE.TXT
 * 程序的再发布必须保留以上版权声明。
 *
 *@author pgmk<pgmk@hucart.com>
 *@copyright pgmk<pgmk@hucart.com>
 *@link http://www.hucart.com
 *@license The MIT License.
 *----------------------------------------------------------------------------*
**/
if (!defined('HUCART_COM')) exit('HuCart.COM No direct script access allowed');
class Item  extends HC_Controller
{
	private $prs_key_val = array();
	function __construct()
	{
		parent::__construct();
		$this -> load_db();
		$this -> load_lang('www/item');
		$this -> load('helper');     	 	//加载辅助类
		$this -> load_model('ads'); 		//加载模型
		$this -> load_model('web_config'); 	//加载模型
		$web_config = $this -> web_config_mod -> get_sys_config();
		$this -> add_style_dir( $web_config['temp'] -> dir );
		$this -> view -> assign('web_config', $web_config);


		$this -> view -> assign('menu_info',$this -> web_config_mod -> get_web_menu());
		$this -> view -> assign('ads_info', $this -> ads_mod -> get_ads( '1,2,3,4,5,6,7,8,9,10,11'  ));
		$this -> view -> assign('user_link',$this -> session -> get_user_link( $this->lang['user_link'] ));

		$this -> load_model('personal'); //加载模型
		
		$this -> load_model('pro_sort'); //加载产品分类模型
		//只能查询一次分类数据
		$prs_info  		= $this -> pro_sort_mod -> get_sort();

		//生成分类ID对应值
		$this -> prs_key_val 	= $this -> helper -> mapped_key_value( $prs_info , $key_index = 'prs_id');
	
		//生成分类选择控件
		$prs_list_str = $this -> helper -> build_list_str( $prs_info , $object_name = 'prs_id', $object_id = 'prs_id' , $object_val_str = 'prs_id', $object_txt_str = 'prs_name', $prs_id  ,$lang_txt = $this-> lang['prs_sort_list'] );
		
		$this -> view -> assign('prs_list_str',$prs_list_str);

		$contact_arr =  $this -> helper -> build_contact( $web_config );
		$this -> view -> assign('contact_arr',$contact_arr);

	}
	

	function info_list()
	{
	
		$id 		= $this -> input -> get["id"];
		$page_num 	= $this -> input -> get["page"];
		$keyword 	= $this -> input -> req["keyword"];

		$page_size = 16 ;

		if( $page_num > 1 )
		{
			$page_num  = $page_num;
			$limit_num = ceil( ( $page_num -1 ) * $page_size );
		}else{
			$page_num  = 1;
			$limit_num = 0 ;
		}

		$addsql = '';
		$webtitle = '商品中心';
		//处理你现在的位置
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/item.html">商品中心</a></li>';
		//左则自定义内容
		$sql_query 	= " SELECT per_id,per_column,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'prolist' ORDER BY `per_id`  ";	
		$infoper 	= $this -> db ->  select_one($sql_query);
		$this -> personal_mod -> get_column($infoper["per_column"]);



		if( $id !='' ){
		
			$prs_son_id = $this -> pro_sort_mod -> get_prs_son_id( $id ,$this -> prs_key_val );
			$addsql 			.= " AND (  prs_id IN ( ".implode(",",$prs_son_id )." ) )";
		}
		
		if($this -> input -> req["keyword"] !='')
		{   
			$keywordval 		 = $this -> input -> req["keyword"];
			$keywordval  		 = urldecode($keywordval); 
			$this -> helper -> addKeyword( $keywordval , $type = 'item');
		}
		
		if($keywordval!='')
		{ 	
			$addsql .= " AND ( pro_name LIKE  '%".$keywordval."%' )";  
		}

		$sql_query 	= " SELECT pro_id, pro_name ,pro_img, pro_sell_price, pro_up_time   FROM  ".$this -> db -> prefix."product   WHERE pro_enabled = 1 and pro_delete = 0 $addsql  GROUP BY  pro_id ORDER BY  `pro_id` LIMIT  $limit_num , $page_size ";
		$info 		= $this -> db ->  select_info( $sql_query );
		
		
		foreach((array)$info as $pkey => $pval )
		{
			 $info[$pkey]["pro_img"] = $this -> helper -> build_img( $pval["pro_img"] ) ;
			 $info[$pkey]["get_url"]= $this -> helper  -> build_url( $valid = $pval["pro_id"],'pro');
		}

		
		$sql_query 	= " SELECT count(1) as CNUM  FROM  ".$this -> db -> prefix."product  WHERE pro_enabled = 1  and pro_delete = 0 $addsql ORDER BY `pro_id`  ";
		$infocount 	= $this -> db ->  select_one( $sql_query );
		
		if($id){
			$sql_query 	= " SELECT prs_name FROM  ".$this -> db -> prefix."pro_sort  WHERE prs_id = $id ";
			$prs_info 	= $this -> db ->  select_one( $sql_query );
			$now_address = $now_address.'<li class="active">'.$prs_info["prs_name"].'</li>';
		}
		

		$url = BASE_WEBURL.'/index.php?/item.html';
		$this -> load('page',$this->lang['page']);
		
		$page_str 	= $this -> page -> buildpage_str( $url , $page_num  , $page_size  , $result_count = $infocount["CNUM"] ,$endArray );
		
		$this -> view -> assign('keyword',$keywordval);
		
		$this -> view -> assign('webtitle',$webtitle);

		$this -> view -> assign('now_address',$now_address);
		$this -> view -> assign('page_str',$page_str);
		$this -> view -> assign('info',$info);
		if($sid !='' or $page_num!='' or  $newkeyword !='')
		{
			$cache_id = $sid.'p'.$page_num.'k'.$keyid;
		}
		$this -> view -> display('pro_list.tpl',$cache_id);
		
	}
	
	function show()
	{
		$id 		= $this -> input -> get["id"];
		$page_num 	= $this -> input -> get["page"];

		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/item.html">商品中心</a></li>';
		//左则自定义内容
		$sql_query 	= " SELECT per_id,per_column,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'pro' ORDER BY `per_id`  " ;	
		$infoper 	= $this -> db -> select_one($sql_query);
		$this -> personal_mod -> get_column($infoper["per_column"]) ;

		if($id > 0 )
		{
			$sql_query 	= " SELECT p.* ,s.prs_name  FROM  ".$this -> db -> prefix."product as p  left join  ".$this -> db -> prefix."pro_sort  as s on p.prs_id = s.prs_id   WHERE  p.pro_delete = 0 and p.pro_enabled = 1  and p.pro_id = ".$id." ORDER BY p.`pro_id`  ";
			
			$infodetail 	= $this -> db ->  select_one($sql_query);

			$webtitle = $infodetail["pro_name"];
			
			if($infodetail["pro_id"]>0 )
			{
			
				$sqlup = " UPDATE ".$this -> db -> prefix."product set pro_view = pro_view +1 WHERE pro_id = ".$infodetail["pro_id"] ; 
				
				$this -> db -> query_sql($sqlup);
				
				//查询图片资料
				$sql_query 	= " SELECT * FROM  ".$this -> db -> prefix."pro_img    WHERE  pro_id  = ".$infodetail["pro_id"]." ORDER BY  `pri_id`  ";
				
				$infoimg 	= $this -> db ->  select_info($sql_query);
				
				$infoimgArray[0]["big_img"] = $infodetail["pro_img"];
				$infoimgArray[0]["pro_img"] =  $this -> helper -> build_img( $infodetail["pro_img"] );
				
				foreach($infoimg as $ikey => $ival )
				{
					$infoimgArray[$ikey+1]["big_img"] = $ival["pri_url"];
					$infoimgArray[$ikey+1]["pro_img"] = $this -> helper -> build_img( $ival["pri_url"]);
				}
			$this -> load_model('comemt'); 	//加载模型	
				
			//获得评论
			$commentInfo = $this -> comemt_mod  -> get_comemt( $infodetail["pro_id"] , $Num = 10 , $type = 'item');
			$this -> view -> assign('commentInfo',$commentInfo);
			
			$sort_url = BASE_WEBURL.'/index.php?/item-info_list-'.$infodetail["prs_id"].'.html';
 
			$this -> view -> assign('sort_url',$sort_url);

			}
			
		
			$now_address = $now_address.'<li><a href="'.$sort_url.'">'.$infodetail["prs_name"].'</a></li>';
			$now_address = $now_address.'<li class="active">'.$infodetail["pro_name"].'</li>';
			
			//查询上一篇
			$prosql = " SELECT pro_id, pro_name  FROM ".$this -> db -> prefix."product WHERE  pro_id < ".$id." GROUP BY pro_id   ORDER BY pro_id  DESC ";
			$Prodetail 	= $this -> db ->  select_one($prosql);
			$Prodetail["get_url"]= $this -> helper  -> build_url( $valid = $Prodetail["pro_id"],'pro');
			//查询下一篇
			$nextsql = " SELECT pro_id, pro_name  FROM ".$this -> db -> prefix."product WHERE  pro_id > ".$id." GROUP BY pro_id  ORDER BY pro_id  ";
			$Nextdetail 	= $this -> db ->  select_one($nextsql);
			$Nextdetail["get_url"]= $this -> helper  -> build_url( $valid = $Nextdetail["pro_id"],'pro');
			
			$cache_id = $id.'d'.$page_num;
			
			$this -> view -> assign('Prodetail',$Prodetail);
			$this -> view -> assign('Nextdetail',$Nextdetail);

			$this -> view -> assign('now_address',$now_address);
			$this -> view -> assign('webtitle',$webtitle);
			$this -> view -> assign('infodetail',$infodetail);
			$this -> view -> assign('infoimgArray',$infoimgArray);
			$this -> view -> display('item.tpl', $cache_id);
			
		}else{
			$this -> error('404');
		}
		
		
	
	}
	
	function act_default()
	{
		$webtitle = '商品中心';
		
		//处理你现在的位置
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/item.html">商品中心</a></li>';

		$pro_sort = $this -> personal_mod -> get_prosort('top');
		//查询一级菜单分类数量
		foreach((array)$pro_sort as $akey=> $aval)
		{
		
			if($akey > 0 )
			{
				$seletsort = " SELECT prs_id,prs_name  FROM ".$this -> db -> prefix."pro_sort WHERE prs_id = ".$akey." or  prs_parent_id = ".$akey ;
				$sortInfo  = $this -> db ->  select_info($seletsort);

				foreach( (array)$sortInfo as $skey => $sval )
				{
 					if($akey==$sval["prs_id"])
					{
						$info[$akey]["title"] 	= $sortval = $sval["prs_name"];
						$info[$akey]["url"] 	= BASE_WEBURL.'/index.php?/item-info_list-'.$sval["prs_id"].'.html';
					}
					if($skey==0)
					{
						$sinid = $sval["prs_id"];
					}else{
						$sinid .= ','.$sval["prs_id"];
					}
				}
				
			    $sql_query = " SELECT pro_id, pro_name , pro_img,pro_sell_price, pro_up_time   FROM  ".$this -> db -> prefix."product   WHERE   pro_enabled = 1 and pro_delete = 0 and  prs_id in ( ".$sinid." )  GROUP BY  pro_id ORDER BY pro_up_time DESC, `pro_id` LIMIT  0 , 8 ";
				$info[$akey]["Arr"] = $this -> db -> select_info($sql_query);
			}
		}
		
		$this -> view -> assign('web_title',$this->lang['web_title_index']);
		$this -> view -> assign('now_address',$now_address);
		
		$this -> view -> assign('info',$info); 
		
		$this -> view -> display('pro_index.tpl',$cache_id);
	}	
        function check_stock()
        {
            echo 'error';
            
        }
}
