<?php
/***
 *----------------------------------------------------------------------------*
 * 版权所有 2010-2016 HuCart.COM，并保留所有权利。
 * 此程序是HuCart的一部分。  
 * 根据MIT许可证授权(在软件和软件的所有副本中都必须包含版权声明和许可声明。)
 * 官方网址:http://www.hucart.com
 *
 * 对于完整的版权和许可证信息，请参阅MIT-LICENSE.TXT
 * 程序的再发布必须保留以上版权声明。
 *
 *@author pgmk<pgmk@hucart.com>
 *@copyright pgmk<pgmk@hucart.com>
 *@link http://www.hucart.com
 *@license The MIT License.
 *----------------------------------------------------------------------------*
**/
if (!defined('HUCART_COM')) exit('HuCart.COM No direct script access allowed');
class Map  extends HC_Controller
{
	function __construct()
	{
		parent::__construct();
		$this -> load_lang('www/map');
		$this -> load_db();
		$this -> load('helper');     	 	//加载辅助类
		$this -> load_model('ads'); 		//加载模型
		$this -> load_model('web_config'); 	//加载模型
		$web_config = $this -> web_config_mod -> get_sys_config();
		$this -> add_style_dir( $web_config['temp'] -> dir );
		$this -> view -> assign('web_config', $web_config);

		$this -> view -> assign('menu_info',$this -> web_config_mod -> get_web_menu());
		$this -> view -> assign('ads_info', $this -> ads_mod -> get_ads(  $instr = '1,2,3,4,5,6,7,8,9,10,11' ) );
		$this -> view -> assign('user_link',$this -> session -> get_user_link( $this->lang['user_link'] ));
		
		$this -> load_model('personal'); //加载模型
		
	}
	
	
	function act_default()
	{
		//缓存
		if($GLOBALS["WebConfig"]["webtmp"]==1)
		{
			$this -> view -> caching = true;
			if($GLOBALS["WebConfig"]["webtmptime"] > 0 ){
				$this -> view -> cache_lifetime = $GLOBALS["WebConfig"]["webtmptime"] ;  //60 *  60 * 24
			}else{
				$this -> view -> cache_lifetime = 3600 ;  //60 *  60 * 24
			}
			$this -> view -> cache_dir = ROOT_PATH.$GLOBALS['cache_path'];
		}


				
		$getartsort = $this -> personal_mod  -> get_sort('art_sort');
		$this -> view -> assign('getartsort',$getartsort);
		
		$getprosort = $this -> personal_mod -> get_prosort();
		$this -> view -> assign('getprosort',$getprosort);
		
		//$getlink = $this -> helper -> get_link();
		//$this -> view -> assign('getlink',$getlink);
 
		
		$getpicsort = $this -> personal_mod  -> get_sort('pic_sort');
		$this -> view -> assign('getpicsort',$getpicsort);
		
		$getvidsort = $this -> personal_mod  -> get_sort('vid_sort');
		$this -> view -> assign('getvidsort',$getvidsort);
		
		$webtitle = '网站地图';
		
		//处理你现在的位置
		$now_address = '您的位置：<a href="'.BASE_WEBURL.'/">首页</a> > <a href="'.BASE_WEBURL.'?/map.html">网站地图</a>';
		
		$this -> view -> assign('webtitle',$webtitle);
		
		$this -> view -> assign('now_address',$now_address);
		
		$this -> view -> display('map.tpl');	
	}
	
}
 
