<?php
/***
 *----------------------------------------------------------------------------*
 * 版权所有 2010-2016 HuCart.COM，并保留所有权利。
 * 此程序是HuCart的一部分。  
 * 根据MIT许可证授权(在软件和软件的所有副本中都必须包含版权声明和许可声明。)
 * 官方网址:http://www.hucart.com
 *
 * 对于完整的版权和许可证信息，请参阅MIT-LICENSE.TXT
 * 程序的再发布必须保留以上版权声明。
 *
 *@author pgmk<pgmk@hucart.com>
 *@copyright pgmk<pgmk@hucart.com>
 *@link http://www.hucart.com
 *@license The MIT License.
 *----------------------------------------------------------------------------*
**/
if (!defined('HUCART_COM')) exit('HuCart.COM No direct script access allowed');
class Picture  extends HC_Controller
{
	function __construct()
	{
		parent::__construct();
		$this -> load_db();
		$this -> load_lang('www/picture');
		$this -> load('helper');     	 	//加载辅助类
		$this -> load_model('ads'); 		//加载模型
		$this -> load_model('web_config'); 	//加载模型
		$web_config = $this -> web_config_mod -> get_sys_config();
		$this -> add_style_dir( $web_config['temp'] -> dir );
		$this -> view -> assign('web_config', $web_config);


		$this -> view -> assign('menu_info',$this -> web_config_mod -> get_web_menu());
		$this -> view -> assign('ads_info', $this -> ads_mod -> get_ads( '1,2,3,4,5,6,7,8,9,10,11'  ));
		$this -> view -> assign('user_link',$this -> session -> get_user_link( $this->lang['user_link'] ));
		
 
		$this -> load_model('personal'); //加载模型
		$pic_sort = $this -> personal_mod  -> get_sort('pic_sort');

		$this -> view -> assign('pic_sort',$pic_sort);
		
		$contact_arr =  $this -> helper -> build_contact( $web_config );
		$this -> view -> assign('contact_arr',$contact_arr);
		
	}
	
	
	function info_list()
	{
	
		$id 		= $this -> input -> get["id"];
		$page_num 	= $this -> input -> get["page"];
		$keyword 	= $this -> input -> req["keyword"];
		
		$page_size = 16;

		if( $page_num > 1 )
		{
			$page_num  = $page_num;
			$limit_num = ceil( ( $page_num -1 ) * $page_size );
		}else{
			$page_num  = 1;
			$limit_num = 0 ;
		}
		
		$newkeywordval  = $this -> input -> req["newkeyword"];
		
		if( $newkeywordval=='' and $this -> input -> req["keyword"] )
		{  
			$newkeywordval  = $this -> input -> req["keyword"]; 
			
		}
		
		if($newkeywordval != '')
		{ 	
			$newkeywordval  = urldecode($newkeywordval); 
			$addurl 	   .= '&newkeywordval='.urlencode($newkeywordval);
			$whereadd 	   .= " AND ( art_title  LIKE  '%".$newkeywordval."%' )";
			//关键字入库处理
			$keyid = $this -> helper -> addKeyword($newkeywordval);

		}


		$addsql = '';

		
		$webtitle = $this->lang['web_title'];
		//处理你现在的位置
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/picture.html">图片中心</a></li>';

		
		//左则自定义内容
		$sql_query 	= " SELECT per_id,per_column,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'piclist' ORDER BY `per_id` ";	
		$infoper 	= $this -> db ->  select_one($sql_query);
		$this -> personal_mod -> get_column( $infoper["per_column"] );


		if( $id > 0 )
		{
			$addsql = " and sort_id = ".$sid;
			//$endArray["sid"] = $sid;
		}
		if( $id != '' )
		{
			$seletsort = " SELECT sort_id,sort_name  FROM ".$this -> db -> prefix."pic_sort WHERE sort_id = ".$id." or  sort_parent_id = ".$id ;
			$sortInfo  = $this -> db ->  select_info($seletsort);
			$sinid 	   = '';
			$addpage   = '&id='.$id;
			if($sortInfo!='')
			{
				foreach( $sortInfo as $skey => $sval )
				{
					if( $sval["sort_id"]== $id )
					{
						$webtitle = $sortval = $sval["sort_name"];

						//$now_address = $now_address. ' > <a href="'.BASE_WEBURL.'/index.php?/picture-info_list-'.$sid.'.html">'.$sval["sort_name"].'</a>';
						$now_address = $now_address. '<li><a href="'.BASE_WEBURL.'/index.php?/picture-info_list-'.$sid.'.html">'.$sval["sort_name"].'</a></li>';
					}
					if($skey==0)
					{
						$sinid = $sval["sort_id"];
					}else{
						$sinid .= ','.$sval["sort_id"];
					}
				}
			}
			$addsql = " AND sort_id in ( ".$sinid." ) ";
		}
		
		
		if($this -> input -> req["keyword"] !='')
		{   
			$keywordval 	= $this -> input -> req["keyword"];
			$keywordval  	= urldecode($keywordval); 
		}
		if($keywordval!='')
		{ 	
			//$endArray["keyword"] =$keywordval;
			$endurl 	   .= '&keyword='.urlencode($keywordval);
			$addsql .= " AND ( pic_title LIKE  '%".$keywordval."%' )";  
		}


		$sql_query 	= " SELECT pic_id, pic_title ,pic_url, pic_up_time   FROM  ".$this -> db -> prefix."picture   WHERE pic_delete = 0 AND pic_enabled= 1 $addsql  GROUP BY  pic_id ORDER BY  `pic_id` LIMIT  $limit_num , $page_size ";
		$info 		= $this -> db ->  select_info( $sql_query );
		
		

		foreach((array)$info as $pkey => $pval )
		{
			$info[$pkey]["pic_url"] = $this -> helper -> build_img( $pval["pic_url"] ) ;  
			$info[$pkey]["get_url"] = $this -> helper  -> build_url( $valid = $pval["pic_id"],'pic');	
		}
		

		$sql_query 	= " SELECT count(1) as CNUM  FROM  ".$this -> db -> prefix."picture  WHERE pic_delete = 0 AND pic_enabled = 1 $addsql ORDER BY `pic_id`  ";
		$infocount 	= $this -> db ->  select_one( $sql_query );
		

		$url = BASE_WEBURL.'/index.php?/picture-info_list-'.$sid.".html";
		////$endArray["sid"] = $sid;
		$this -> load('page',$this->lang['page']);
		
		$page_str 	=  $this -> page -> buildpage_str( $url , $page_num  , $page_size  , $result_count = $infocount["CNUM"] ,$endArray);
		
		$this -> view -> assign('keyword',$keywordval);
		
		$this -> view -> assign('webtitle',$webtitle);
		$this -> view -> assign('now_address',$now_address);
		$this -> view -> assign('page_str',$page_str);
		$this -> view -> assign('info',$info);
		
		if($sid !='' or $page_num!='' or  $newkeyword !='')
		{
			$cache_id = $sid.'p'.$page_num.'k'.$keyid;
		}
		$this -> view -> display('pic_list.tpl',$cache_id);
	}
	
	function show()
	{
		$id 		= $this -> input -> get["id"];
		$page_num 	= $this -> input -> get["page"];
		
		if($page_num !='' and $iid =='' ){ $iid = $page_num ;  }
		

		$webtitle = $this->lang['web_title'];
		//处理你现在的位置
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/picture.html">图片中心</a></li>';
		
		//左则自定义内容
		$sql_query 	= " SELECT per_id,per_column,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'pic' ORDER BY `per_id` ";	
		$infoper 	= $this -> db ->  select_one($sql_query);
		$this -> personal_mod -> get_column( $infoper["per_column"] );

		
		if($id > 0 )
		{
			$infoItemval = array();
			$sql_query 	= " SELECT p.* ,s.sort_name  FROM  ".$this -> db -> prefix."picture as p , ".$this -> db -> prefix."pic_sort  as s   WHERE pic_delete = 0 AND  p.sort_id = s.sort_id and p.pic_enabled = 1  and p.pic_id = ".$id." ORDER BY p.`pic_id`  ";
			
			$infodetail 	= $this -> db ->  select_one( $sql_query );

			$infoItemval[0]["pii_url"] = $this -> helper -> build_img( $infodetail["pic_url"] ) ;
			$infoItemval[0]["piibig_url"] = $infodetail["pic_url"]  ;
			$infoItemval[0]["pii_desc"]  =  strip_tags($infodetail["pic_content"]);

			if($infodetail['sort_name']!=''){
				$now_address = $now_address .'<li><a href="'.BASE_WEBURL.'/index.php?/picture-info_list-'.$infodetail['sort_id'].'.html">'.$infodetail['sort_name'].'</a></li>';
			}
					
			//查询其他图片信息
			$sql_queryitem 	= " SELECT  pii_id, pic_id , pii_desc, pii_url    FROM  ".$this -> db -> prefix."pic_item WHERE  pii_enabled = 1  and  pic_id = ".$id."  ORDER BY  `pii_id`  LIMIT 0,200";
			$infoItem 	= $this -> db ->  select_info( $sql_queryitem );
			
			$this -> load_model('comemt'); 	//加载模型	
			//获得评论
			$commentInfo = $this -> comemt_mod  -> get_comemt( $id , $Num = 10 , $type = 'picture');
			$this -> view -> assign('commentInfo',$commentInfo);
			
			
			//$fkey = 0 ;
			$picnum = count($infoItem);
			

			foreach((array)$infoItem as $itemkey => $itemval )
			{
						
					$infoItemval[$itemval["pii_id"]]["pii_url"] = $this -> helper -> build_img( $itemval["pii_url"] ) ;
					$infoItemval[$itemval["pii_id"]]["piibig_url"] = $itemval["pii_url"]  ;
					$infoItemval[$itemval["pii_id"]]["pii_desc"]  =  strip_tags($itemval["pii_desc"]);
			}

			
 
			if($iid > 0)
			{

				$infodetail["pic_url"] 		= $infoItemval[$iid]["pii_urlbig"];
				$infodetail["pii_id"] 		= $infoItemval[$iid]["pii_id"];
				$infodetail["pic_content"]  = $infoItemval[$iid]["pii_desc"];
				
				$sqlupitem = " UPDATE ".$this -> db -> prefix."pic_item set pii_view = pii_view +1 WHERE pii_id = ".$iid ; 
			
				$this -> db -> query_sql($sqlupitem);
				
				$sqlup = " UPDATE ".$this -> db -> prefix."picture set pic_view = pic_view +1 WHERE pic_id = ".$id ; 
			
				$this -> db -> query_sql($sqlup);
			}else{
				$sqlup = " UPDATE ".$this -> db -> prefix."picture set pic_view = pic_view +1 WHERE pic_id = ".$id ; 
			
				$this -> db -> query_sql($sqlup);
			}
			
			if($infodetail["pic_id"])
			{
				//查询上一组
				$prosql = " SELECT pic_id, pic_title  FROM ".$this -> db -> prefix."picture WHERE  pic_id < ".$infodetail["pic_id"]." GROUP BY pic_id   ORDER BY pic_id  DESC ";
				$Prodetail 	= $this -> db ->  select_one($prosql);

				$Prodetail["get_url"]= $this -> helper  -> build_url( $valid = $Prodetail["pic_id"],'pic');

				//查询下一组
				$nextsql = " SELECT pic_id, pic_title  FROM ".$this -> db -> prefix."picture WHERE  pic_id > ".$infodetail["pic_id"]." GROUP BY pic_id  ORDER BY pic_id  ";
				$Nextdetail 	= $this -> db ->  select_one($nextsql);
				$Nextdetail["get_url"]= $this -> helper  -> build_url( $valid = $Nextdetail["pic_id"],'pic');
				
			}
			$this -> view -> assign('Prodetail',$Prodetail);
			$this -> view -> assign('Nextdetail',$Nextdetail);
			
			$now_address = $now_address.'<li>'. $infodetail["pic_title"].'</li>';
			
			$webtitle = $infodetail["pic_title"];
			

			
			$this -> view -> assign('infoItemval',$infoItemval);
			$this -> view -> assign('picnum',$picnum);
			$this -> view -> assign('now_address',$now_address);
			$this -> view -> assign('webtitle',$webtitle);
			$this -> view -> assign('infodetail',$infodetail);
			$cache_id = $id.'d'.$page_num;
			$this -> view -> display('pic.tpl',$cache_id );
			
		}else{
			$this -> error('404');
		}
	
	}

	function act_default()
	{
		$webtitle = $this->lang['web_title'];
		//处理你现在的位置
		$now_address = $this->lang['u_address'].'<a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a> > <a href="'.BASE_WEBURL.'/index.php?/picture.html">'.$this->lang['web_title'].'</a>';
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/picture.html">图片中心</a></li>';
		//查询一级菜单分类数量
 
		$seletsort = " SELECT sort_id,sort_name  FROM ".$this -> db -> prefix."pic_sort WHERE   sort_parent_id = 0 " ;
		$sortInfo  = $this -> db ->  select_info($seletsort);

				foreach( (array)$sortInfo as $skey => $sval )
				{
 
					$info[$skey]["title"] 	= $sortval = $sval["sort_name"];
					$info[$skey]["url"] 	= BASE_WEBURL.'/index.php?/picture-info_list-'.$sval["sort_id"].'.html';
 
					$sinid = $sval["sort_id"];

			   		$sql_query = " SELECT pic_id, pic_title , pic_url, pic_up_time   FROM  ".$this -> db -> prefix."picture   WHERE pic_delete = 0 AND  pic_enabled = 1 and  sort_id in ( ".$sinid." )  GROUP BY  pic_id ORDER BY pic_up_time DESC, `pic_id` LIMIT  0 , 8 ";
					$info[$skey]["Arr"] = $this -> db -> select_info($sql_query);
					foreach($info[$skey]["Arr"] as $pkey => $pval)
					{
						$info[$skey]["Arr"][$pkey]["pic_url"] = $this -> helper -> build_img( $pval["pic_url"] ) ;
					}
 				}
		
		$this -> view -> assign('webtitle',$webtitle);
		$this -> view -> assign('now_address',$now_address);
		$this -> view -> assign('info',$info); 
		$this -> view -> display('pic_index.tpl',$cache_id);
	}
	
	
	

}

