<?php

/**
 * Description 	Admin Module
 * N0.			M1114
 * Name			Mr.Box
 * E-mail 		414368080qq.com
 * Time			2015/05/20
 * */
defined('IN_MET') or exit('No permission');
load::sys_class('admin.class.php');
load::sys_class('nav.class.php');
load::sys_func('file');
load::sys_func('array');

class index extends admin {

    public function __construct() {
        global $_M;
        parent::__construct();
        nav::set_nav(1, $_M['word']['test_img'], $_M[url][own_form] . 'a=doindex');
        nav::set_nav(2, $_M['word']['ex_tip0'], $_M[url][own_form] . 'a=doextension');
        nav::set_nav(3, $_M['word']['contact_developer'], $_M[url][own_form] . 'a=docontact');
    }

    /*
     * 2015年8月26日00:18:19
     * 功能增加	图片后缀检测工具 //extension 拓展名
     */

    function doextension() {
        global $_M;
        nav::select_nav(2);

        $table = $_M[table][delimg_set];
        $key = 'ex_img_count';
        $img_num = $this->doget_value_db($table, $key);
        if ($img_num) {
            $img_num_html = $_M['word']['ex_tip6'] . $img_num . $_M['word']['zhang'];
        } else {
            $img_num_html = $_M['word']['ex_tip5'];
        }

        $key = 'ex_change_count';
        $changed = $this->doget_value_db($table, $key);
        if ($changed) {
            $count_html = $_M['word']['ex_tip7'] . $changed . $_M['word']['zhang'];
        } else {
            $count_html = $_M['word']['ex_tip5'];
        }

        $action = "doscanimg_ex";  //方法名传递
        $button = $_M['word']['scan_img'];

        require $this->template('own/extension');
    }

    function doindex() {
        global $_M;
        nav::select_nav(1);
        //上一次执行图片扫描的时间
        $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'updatetime'";
        $result = DB::get_one($query);
        if ($result) {
            $updatetime = $result[value];
        } else {
            $updatetime = $_M['word']['never_scan'];
        }

        //上一次执行图片扫描后删除的图片数量
        $delimgnum = $_M['form']['delimgnum'];
        $delimg_img = $_M['word']['delet_this'];
        if ($delimgnum == '') {
            $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'delimgnum'";
            $result = DB::get_one($query);
            if ($result) {
                $delimgnum = $result[value];
            } else {
                $delimgnum = "0 ";
            }
            $delimg_img = $_M['word']['delet_img'];
        }

        require $this->template('own/index');
    }

    /*
     * 功能		执行系统文件UPDATE文件夹的扫描
     */

    function doscanimg() { //无效图片检测
        global $_M;
        nav::select_nav(1);

        $dir = PATH_WEB . "upload";
        $arr_table_list = $this->dotablelist();   //初始化数据库表，基础数据自动填充，
        $arr_img = $this->doscandir($dir);   //遍历文件夹，获取文件名数组（带路径），返回数组
        $arr_img = $this->doarrimgone($arr_img); //多维数组转换为一维数组
        $img_num = count($arr_img);     //计算转换后的一维数组中有多少元素，即所获取的文件夹下共计多少文件
        $str_json = jsonencode($arr_img);    //一维数组转为JSON		
        //获取扫描起始位置
        $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'scan_start'";
        $result = DB::get_one($query);
        if (is_strempty($result['value'])) {
            $start = $result['value'];
        } else {
            $start = 0;
        }

        date_default_timezone_set('Etc/GMT-8');    //设置时区
        $date = date('Y-m-d H:i:s');
        $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'updatetime'";
        $result = DB::get_one($query);
        if ($result) {
            $query = "UPDATE {$_M['table']['delimg_set']} SET value = '{$date}' WHERE name = 'updatetime'";
            DB::query($query);
        } else {
            $query = "INSERT INTO {$_M['table']['delimg_set']} SET name = 'updatetime',value= '{$date}'";
            DB::query($query);
        }

        require $this->template('own/scan');
    }

    /*
     * 2015年8月26日00:17:04
     * 功能增加	统计当前站点UPDATE文件夹中的图片数量
     */

    function doscanimg_ex() {
        global $_M;
        nav::select_nav(2);

        $dir = PATH_WEB . "upload";
        $arr_table_list = $this->dotablelist();   //初始化数据库表，基础数据自动填充，
        $arr_img = $this->doscandir($dir);   //遍历文件夹，获取文件名数组（带路径），返回数组
        $arr_img = $this->doarrimgone($arr_img); //多维数组转换为一维数组
        $img_num = count($arr_img);     //计算转换后的一维数组中有多少元素，即所获取的文件夹下共计多少文件
        //将扫描到的图片总数存入数据库
        $value = $img_num;
        $table = $_M[table][delimg_set];
        $key = 'ex_img_count';
        $this->doex_count_save($value, $table, $key);

        //图片数量总数统计输出
        $img_num_html = "{$_M['word']['count']} <span style=\"color: red;\">{$img_num}</span> {$_M['word']['zhang']}";

        $ex_list = $this->doget_ex_num($arr_img); //获取所有图片的后缀（不去重）
        $ex_count = array_count_values($ex_list);  //统计数组中所有值出现的次数
        $ex_array = $this->dosort_ex_list($arr_img); //图片（带路径）后缀大小写分组
        $ex_array = $ex_array[2];      //获取含有至少一个大写字母后缀的文件名
        //输出统计数据 strtolower()	将字符串转换成小写 strtoupper()	将字符转成大写
        $str_upper_count = 0;        //初始化统计变量：大写后缀数量；
        foreach ($ex_count as $key => $value) {
            $str_lower = strtolower($key);     //字符串转为小写
            if ($str_lower != $key) {      //判断原字符串是否存在大写，若不相等则原字符串存在至少一个大写字母；
                $str_upper_count = $str_upper_count + $value;
            }
            $count_html .= "{$key}&nbsp;{$_M['word']['count']} <span style=\"color: red;\">{$value}</span> {$_M['word']['zhang']};&nbsp;&nbsp;&nbsp;&nbsp;";
        }

        if ($str_upper_count > 0) {
            $count_html_0 = "<strong>{$_M['word']['ex_tip8']}&nbsp;<span style=\"color: red;\">{$str_upper_count}</span> {$_M['word']['zhang']};&nbsp;&nbsp;&nbsp;&nbsp;</strong>";
            $this->doex_change_db($ex_array);    //存入扫描结果
            $action = "doex_change";     //方法名传递
            $button = $_M['word']['ex_tip9'];
        } else {
            $count_html_0 = "<strong style=\"color:#333;\">{$_M['word']['ex_tip10']}&nbsp;&nbsp;&nbsp;&nbsp;</strong>";
            $action = "doextension";     //方法名传递
            $button = $_M['word']['ex_tip11'];
        }

        require $this->template('own/extension');
    }

    /*
     * 2015年8月23日20:56:34
     * 功能增加：	循环数组获取所有文件后缀（区别大小写）；
     * 扩展名参考：	bmp、gif、jpg、pic、png、tif
     */

    function doget_ex_num($arr_img) {
        global $_M;
        foreach ($arr_img as $val) {       //循环传递数组，截取文件扩展名
            $str = $val;
            if (is_strempty($str)) {
                $str = getfileable($str);     //系统函数：文件后缀名获取				
                $result_array[] = $str;      //获取后缀，放入数组
            }
        }
        return $result_array;
    }

    /*
     * 2015年8月24日20:08:28
     * 功能增加：删选数组，大小写分组;
     */

    function dosort_ex_list($array) {
        global $_M;
        foreach ($array as $val) {
            $str = $val;

            if (is_strempty($str)) {
                $str_ex = getfileable($str);    //系统函数：文件后缀名获取
                $str_lower = strtolower($str_ex);   //字符串转为小写
                if ($str_lower == $str_ex) {     //转换为全小写字符串与原字符串比较
                    $result_array[1][] = $str;    //完全匹配时（即原后缀为小写）放入数组【1】
                } else {
                    $result_array[2][] = $str;    //否则放入数组【2】(后缀中含有至少一个大写字母)
                }
            }
        }
        return $result_array;
    }

    /*
     * 2015年8月24日21:35:30
     * 功能增加  将存在大写字母后缀的图片名数组存入数据库
     */

    function doex_change_db($array) {
        global $_M;
        if (is_arrempty($array)) {    //判断传入数组是否为空
            foreach ($array as $val) {   //循环处理传入数组
                $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'ex_change'";
                $result = DB::get_one($query);
                if ($result) {
                    if (is_strinclude($value, $val) == false) {
                        if ($result['value'] == '') {
                            $value = $val;
                        } else {
                            $value = $result['value'] . "," . $val;
                        }
                        $query = "UPDATE {$_M['table']['delimg_set']} SET value = '{$value}' WHERE name = 'ex_change'";
                        DB::query($query);
                    }
                } else {
                    $value = $val;
                    $query = "INSERT INTO {$_M['table']['delimg_set']} SET name = 'ex_change',value= '{$value}'";
                    DB::query($query);
                }
            }
        }
    }

    /*
     * 2015年8月24日20:02:55
     * 功能增加：文件后缀名更改：
     * rename(oldname,newname) 函数重命名文件或目录。
     */

    function doex_change() {
        global $_M;
        $web_path = PATH_WEB;
        $query = "SELECT * FROM {$_M['table']['delimg_set']} WHERE name = 'ex_change'"; //查询记录是否存在
        $stall = DB::get_one($query);
        if (is_strempty($stall['value'])) {
            $str_list = $stall['value'];     //获取记录
            $str_array = stringto_array($str_list, ","); //转为数组
            if (is_arrempty($str_array)) {
                foreach ($str_array as $key => $str_chang) {
                    $system = php_uname('s');
                    if (is_strinclude($system, 'win')) {
                        //$str_chang = str_replace('/', '\\', $str_chang);
                        $str_chang = iconv("UTF-8", "GBK", $str_chang);
                    }
                    $chang_url = $web_path . $str_chang;       //原图片名称（带连接）
                    $str_ex = getfileable($str_chang);       //系统函数：文件后缀名获取
                    $str_lower = strtolower($str_ex);        //字符串转为小写
                    $changed_url = str_replace($str_ex, $str_lower, $str_chang); //原替换转为小写后缀的URL
                    $changed_url = $web_path . $changed_url;
                    $result = rename($chang_url, $changed_url);
                    if (!$result) {
                        $str_result = 0;
                    }
                }
                $query = "DELETE FROM {$_M['table']['delimg_set']} WHERE name = 'ex_change'";
                DB::query($query);
            }
        }

        if ($str_result) {
            $str_result = $_M['word']['ex_tip12'];
        } else {
            $str_result = $_M['word']['success'];
        }

        //将需要变更扩展名图片的数量存入数据库
        $value = count($str_array);
        $table = $_M[table][delimg_set];
        $key = 'ex_change_count';
        $this->doex_count_save($value, $table, $key);

        turnover("{$_M[url][own_form]}a=doextension", $str_result);
    }

    /*
     * 2015年8月25日23:31:09
     * 功能增加	统计数据存储
     * $value	传入参数
     * $table	存入表名
     * $key		表名键值即存入依据，入where name=$key
     */

    function doex_count_save($value, $table, $key) {
        global $_M;
        $query = "SELECT * FROM {$table} WHERE name = '{$key}'";
        $result = DB::get_one($query);
        if ($result) {
            $query = "UPDATE {$table} SET value = '{$value}' WHERE name = '{$key}'";
            DB::query($query);
        } else {
            $query = "INSERT INTO {$table} SET name = '{$key}',value= '{$value}'";
            DB::query($query);
        }
    }

    /*
     * 2015年8月25日23:50:24
     * 功能增加	根据条件获取指定记录value值；
     * $table	存入表名
     * $key		表名键值即存入依据，入where name=$key
     */

    function doget_value_db($table, $key) {
        global $_M;
        $query = "SELECT * FROM {$table} WHERE name = '{$key}'";
        $result = DB::get_one($query);
        if ($result) {
            $value = $result['value'];
        } else {
            $value = 0;
        }
        return $value;
    }

    /*
     * 功能		根据数据库记录删除无效文件
     */

    function doimgdel() {
        global $_M;
        nav::select_nav(1);
        $this->dodelimg();
        //获取扫描时间
        $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'updatetime'";
        $result = DB::get_one($query);
        if ($result) {
            $updatetime = $result[value];
        } else {
            $updatetime = $_M['word']['never_scan'];
        }
        //获取历史清理记录
        $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'delimgthis'";
        $result = DB::get_one($query);
        if ($result) {
            $delimgnum = $result[value];
        } else {
            $delimgnum = "0 ";
        }

        turnover("{$_M[url][own_form]}a=doindex&delimgnum={$delimgnum}", $_M['word']['success']);
    }

    /*
     * 功能:           扫描指定文件夹下的文件，并以数组形式返回
     * $pathname:      文件夹名称
     * $arr_img:       数组，扫描后的文件名存储数组
     * $filename:      文件/文件夹名
     */

    function doscandir($pathname) {
        global $_M;
        $arr_img = array();
        foreach (glob($pathname) as $filename) {
            if (is_dir($filename)) {
                $filename = iconv("gbk", "utf-8", $filename);
                //增加文件夹名判断 thumb_src和_thumbs 缓存文件夹
                if (is_strinclude($filename, '/thumb_src') || is_strinclude($filename, '/_thumbs')) {
                    // deldir($filename); //删除整个文件夹
                    // mkdir($filename);  //重新创建该文件夹
                } else {
                    $dir_name = str_replace(PATH_WEB, '', $filename);
                    $arr_img[$dir_name] = $this->doscandir($filename . '/*');
                }
            } else {
                if (is_strempty($filename)) {
                    if (is_strinclude($filename, '/file/') || is_strinclude($filename, '/files/') || is_strinclude($filename, '/flash/') || is_strinclude($filename, '/image/') || is_strinclude($filename, '/thumb_dis/') || is_strinclude($filename, '/watermark/')) {
                        //排除指定目录文件夹（系统目录）
                    } else {
                        $system = php_uname('s');
                        if (is_strinclude($system, 'win')) {
                            $filename = iconv("gbk", "utf-8", $filename); //window 文件名转码，解决中文名乱码问题，
                        }
                        $img_name = str_replace(PATH_WEB, '', $filename);
                        $arr_img[] = $img_name;
                    }
                }
            }
        }
        return $arr_img;
    }

    /*
     * 功能  	  ajax将传入的图片名称数组foreach 循环遍历数据库表，匹配包含图片名称的字段，能够匹配到则丢弃，
     * $arr_img    文件名数组
     * $tablelist  表字段数组
     * $type       数据库扫描类型
     */

    function dogetimg() {
        global $_M;
        $out = array(); //初始化数组-清空数组
        $tablelist = $_M[table];
        $amsg = $_M['form']['amsg'];
        $totals = $_M['form']['total']; //图片总数量
        $start = $_M['form']['key'];
        $total = $start + 1; //第几条数据，用于计算百分比及进度条宽度
        $img = $_M['form']['img']; //图片名称
        //初步匹配扫描
        $wait_del_img = $this->doscandb($img);

        //二次判断，处理水印图片，缩略图片
        if (in_array($img, $wait_del_img) == false) {
            $dir = $this->doimgdir($img);     //拆分带路径文件名为：所在目录+文件名
            $img_dir = $dir[0];         //文件所在目录
            $img_name = $dir[1];         //文件名
            $watermark = $img_dir . 'watermark/' . $img_name;   //重组路径的文件名
            // $s_url	   = str_replace('/', '\\', $watermark);
            $wm_url = $this->dostrtypechange($watermark);  //文件名转码
            $wm_url = PATH_WEB . $wm_url;       //文件绝对路径
            $wm_check = file_exists($wm_url);      //检查文件是否存在
            if ($wm_check) {           //水印文件判断处理 图片对应水印图片是否存在
                $wait_del_wm = $this->doscandb($watermark);  //水印图片有效性扫描
                if (in_array($watermark, $wait_del_wm) == false) { //水印图片存在时判定有效性 无效加入待删除队列
                    $this->doimgdeal($img);      //原图加入待删除队列
                    $wm_img = '/' . $watermark;      //水印图片完整路径
                    $this->doimgdeal($wm_img);     //水印图片加入待删除队列

                    $thumb_dis = $img_dir . 'thumb_dis/' . $img_name;
                    $td_url = $this->dostrtypechange($thumb_dis); //文件名转码
                    $td_url = PATH_WEB . $td_url;
                    $td_check = file_exists($td_url);
                    if ($td_check) {
                        $td_img = '/' . $thumb_dis;     //缩略图完整路径
                        $this->doimgdeal($td_img);    //缩略图加入待删除队列
                    }
                }
            } else {
                $thumb_dis = $img_dir . 'thumb_dis/' . $img_name;
                $td_url = $this->dostrtypechange($thumb_dis); //文件名转码
                $td_url = PATH_WEB . $td_url;
                $td_check = file_exists($td_url);
                if ($td_check) {          //缩略图文件处理 图片是无效图片的话 删除原文件及thumb_dis文件夹下对应的缩略图
                    $this->doimgdeal($img);      //原图加入待删除队列
                    $td_img = '/' . $thumb_dis;      //缩略图完整路径
                    $this->doimgdeal($td_img);     //缩略图加入待删除队列
                } else {
                    $this->doimgdeal($img);      //不存在缩略图，且图片无效 图片直接加入待删除队列
                }
            }
        }

        if ($total == $totals) {
            $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'scan_out'";
            $result = DB::get_one($query);
            if (is_strempty($result['value'])) {
                $value = $result['value'];
                $array = stringto_array($value, ",");
                $count = count($array);
                $amsg = $_M['word']['tip_4'] . $count . $_M['word']['zhang'];
            } else {
                $amsg = $_M['word']['tip_5'];
            }
            $tip = $_M['word']['tip_6'] . "，" . $amsg;
            $width = "500px";
            $percent = "100%";
            $button = "<input type=\"submit\" name=\"submit\" value=\"{$_M['word']['clean']}\" class=\"submit\" id=\"sub_clean\">";

            //存储扫描位置重置
            $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'scan_start'";
            $result = DB::get_one($query);
            if ($result) {
                $query = "UPDATE {$_M['table']['delimg_set']} SET value = '0' WHERE name = 'scan_start'";
                DB::query($query);
            }
        } else {
            $tip = $_M['word']['processing'] . $img;
            $width = intval($total / $totals * 500) . "px";  //intval() 获取计算值的整数部分，舍去小数点之后的数字，避免异常中断
            $percent = intval($total / $totals * 100) . "%";
            $button = "<input type=\"button\" name=\"button\" value=\"{$_M['word']['stop']}\" class=\"submit\" id=\"sub_stop\" onclick=\"window.stop();\" style=\"float: left; margin-right: 35px;\">
				<input type=\"button\" name=\"button\" value=\"{$_M['word']['restart']}\" class=\"submit\" id=\"sub_restart\" onclick=\"location.reload()\" style=\"float: left;\">";
            //存储扫描位置记录
            $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'scan_start'";
            $result = DB::get_one($query);
            if ($result) {
                $query = "UPDATE {$_M['table']['delimg_set']} SET value = '{$total}' WHERE name = 'scan_start'";
                DB::query($query);
            } else {
                $query = "INSERT {$_M['table']['delimg_set']} SET value = '{$total}',name = 'scan_start'";
                DB::query($query);
            }
        }

        $out[tip][] .= $tip;    //1、动态显示提示语；
        $out[width][] .= $width;    //2、进度条宽度；
        $out[percent][] .= $percent;   //3、进度条百分比
        $out[button][] .= $button;    //4、按钮
        $str_json = jsonencode($out); //一维数组转为JSON

        echo $str_json;
    }

    /*
     * 根据带路径的文件名 处理文件目录 返回文件所在的当前目录及文件名
     */

    function doimgdir($img) {
        global $_M;
        $arr_url = explode('/', $img);
        $length = count($arr_url) - 1;
        $dir_url = '';
        for ($i = 0; $i < $length; $i++) {
            $dir_url .= $arr_url[$i] . '/';
        }
        $dir[0] = $dir_url;
        $dir[1] = $arr_url[$length];
        return $dir;
    }

    /*
     * 功能 图片数据库匹配 能够匹配到则存入数据，并返回数组
     */

    function doscandb($img) {
        global $_M;
        $tablelist = $_M[table];
        $wait_del_img = array();
        foreach ($tablelist as $key => $tm) {
            $query = "SELECT * FROM {$_M['table']['delimg_table']} WHERE name='{$tm}'";  //获取表对应id
            $value = DB::get_one($query);
            $tid = $value['id'];
            $query = "SELECT * FROM {$_M['table']['delimg_table_field']} WHERE tid={$tid}";  //获取对应表的字段字符串
            $array = DB::get_all($query); //获取数据
            foreach ($array as $key => $field) {
                $field = $field['field']; //获取字段名称
                $query = "SELECT * FROM {$tm} WHERE {$field} LIKE '%{$img}%'";
                $result = DB::get_one($query);
                if ($result) {
                    $wait_del_img[] = $img;
                }
            }
        }
        return $wait_del_img;
    }

    /*
     * 无法匹配到的图片名称数组转为json后存进数据库
     */

    function doimgdeal($img) {
        global $_M;
        $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'scan_out'";
        $result = DB::get_one($query);
        if ($result) {
            $value = $result['value'];
            if (is_strinclude($value, $img) == false) {
                if ($result['value'] == '') {
                    $value = $img;
                }
                $value = $result['value'] . "," . $img;
                $query = "UPDATE {$_M['table']['delimg_set']} SET value = '{$value}' WHERE name = 'scan_out'";
                DB::query($query);
            }
        } else {
            $value = $img;
            $query = "INSERT INTO {$_M['table']['delimg_set']} SET name = 'scan_out',value= '{$value}'";
            DB::query($query);
        }
    }

    /*
     * 功能：	获取所有表名及对应文本或字符串类型字段，存入数据库,排除应用自身产生的表
     */

    function dotablelist() {
        global $_M;
        $table_array = $_M[table];
        foreach ($table_array as $key => $table) {
            if (is_strinclude($table, 'delimg') == false) {
                $query = "SELECT * FROM {$_M['table']['delimg_table']} WHERE name = '{$table}'"; //查询记录是否存在
                $stall = DB::get_one($query);
                if (!$stall) {
                    $query = "INSERT INTO {$_M['table']['delimg_table']} SET name='{$table}'";
                    DB::query($query);
                    $tid = DB::insert_id();    //获取上一步INSERT操作产生的ID
                    $query = "DESC " . "{$table}";
                    $fields = DB::get_all($query);   //获取表字段装进数组
                    $value = '';        //清空变量 
                    foreach ($fields as $key => $field) { //将所有字段循环出来组成字符串
                        $type = $field['Type'];
                        $field = $field['Field'];
                        if (is_strinclude($type, 'char') || is_strinclude($type, 'text')) {
                            $query = "INSERT INTO {$_M['table']['delimg_table_field']} SET tid='{$tid}',field='{$field}'";
                            DB::query($query);
                        }
                    }
                }
            }
        }
    }

    /*
     * 功能:           将多维数组合并为一位数组
     * $array:         需要合并的数组
     * $clearRepeated: 是否清除并后的数组中得重复值
     */

    function doarrimgone($array, $clearRepeated = false) {
        if (!isset($array) || !is_array($array) || empty($array)) {
            return false;
        }
        if (!in_array($clearRepeated, array('true', 'false', ''))) {
            return false;
        }
        static $result_array = array();
        foreach ($array as $value) {
            if (is_array($value)) {
                $this->doarrimgone($value);
            } else {
                $result_array[] = $value;
            }
        }
        if ($clearRepeated) {
            $result_array = array_unique($result_array);
        }
        return $result_array;
    }

    /*
     * 功能   根据服务器系统类型判断更改字符串编码类型
     */

    function dostrtypechange($str) {
        global $_M;
        $system = php_uname('s');
        if (is_strinclude($system, 'win')) {
            $str = str_replace('/', '\\', $str);
            $str = iconv("UTF-8", "GBK", $str); //WINDOWS系统下 文件名转码，解决中文名UTF-8编码无法删除的问题
        }
        return $str;
    }

    /*
     * 功能 删除指定数组内的图片文件
     *
     */

    function dodelimg() {
        global $_M;

        $web_path = PATH_WEB;
        //清理缓存文件夹 _thumbs  thumb_src
        $_thumbs = $web_path . 'upload/_thumbs';
        if (is_dir($_thumbs)) {  //判断是否存在，是否为目录
            deldir($_thumbs);   //删除整个文件夹
            mkdir($_thumbs);   //重新创建该文件夹
        }
        $thumb_src = $web_path . 'upload/thumb_src';
        if (is_dir($thumb_src)) { //判断是否存在，是否为目录
            deldir($thumb_src);  //删除整个文件夹
            mkdir($thumb_src);  //重新创建该文件夹
        }

        $query = "SELECT * FROM {$_M['table']['delimg_set']} WHERE name = 'scan_out'"; //查询记录是否存在
        $stall = DB::get_one($query);
        if (is_strempty($stall['value'])) {
            $str_delimg = $stall['value'];     //获取记录
            $arr_delimg = stringto_array($str_delimg, ","); //转为数组
            $delimg_num = count($arr_delimg);    //删除数量
            if (is_arrempty($arr_delimg)) {
                foreach ($arr_delimg as $key => $delimg) { //循环删除
                    $system = php_uname('s');
                    if (is_strinclude($system, 'win')) {
                        $delimg = str_replace('/', '\\', $delimg);
                        $delimg = iconv("UTF-8", "GBK", $delimg);
                    }
                    $delimg_url = $web_path . $delimg;
                    delfile($delimg_url);
                }
                $query = "DELETE FROM {$_M['table']['delimg_set']} WHERE name = 'scan_out'";
                DB::query($query);
            }

            //更新或插入删除记录
            $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'delimgnum'";
            $result = DB::get_one($query);
            if ($result) {
                $query = "UPDATE {$_M['table']['delimg_set']} SET value = '{$delimg_num}' WHERE name = 'delimgnum'";
                DB::query($query);
            } else {
                $query = "INSERT INTO {$_M['table']['delimg_set']} SET name = 'delimgnum',value= '{$delimg_num}'";
                DB::query($query);
            }
            //本次扫描记录更新
            $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'delimgthis'";
            $result = DB::get_one($query);
            if ($result) {
                $query = "UPDATE {$_M['table']['delimg_set']} SET value = '{$delimg_num}' WHERE name = 'delimgthis'";
                DB::query($query);
            } else {
                $query = "INSERT INTO {$_M['table']['delimg_set']} SET name = 'delimgthis',value= '{$delimg_num}'";
                DB::query($query);
            }
        } else {
            //没有清除任何文件时清空记录
            $query = "SELECT * FROM {$_M[table][delimg_set]} WHERE name = 'delimgthis'";
            $result = DB::get_one($query);
            if ($result) {
                $query = "UPDATE {$_M['table']['delimg_set']} SET value = '0' WHERE name = 'delimgthis'";
                DB::query($query);
            } else {
                $query = "INSERT INTO {$_M['table']['delimg_set']} SET name = 'delimgthis',value= '0'";
                DB::query($query);
            }
        }
    }

    /*
     * 功能 AD信息
     *
     */

    function docontact() {
        global $_M;
        nav::select_nav(3);
        require $this->template('own/contact');
    }

}

?>