<?php

class LinkAction extends CommonAction {
	
	public function index() {
					
		//分页
		import('Class.Page', APP_PATH);
		$count = M('link')->count();

		$page = new Page($count, 30);
		$limit = $page->firstRow. ',' .$page->listRows;
		$list = M('link')->order('sort')->limit($limit)->select();

		$this->page = $page->show();
		$this->vlist = $list;
		$this->type = '友情连接列表';

		$this->display();
	}
	//添加
	public function add() {
		//当前控制器名称		
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			$this->addHandle();
			exit();
		}
		$this->display();
	}

	//
	public function addHandle() {

		$name = I('name', '', 'trim');
		$url = I('url', '', 'trim');
		$pic = I('logo', '', 'trim');
		if (empty($name) || empty($url)) {
			$this->error('网站名称或网址不能为空');
		}

		$data = array(
			'name'		=> $name,
			'url'		=> $url,
			'logo'		=> $pic,
			'description' => I('description', ''),
			'ischeck'	=> I('ischeck', 0, 'intval'),
			'sort'		=> I('sort', 0, 'intval'),
			'posttime'	=> time(),

		);

		if($id = M('link')->add($data)) {
			//更新上传附件表
			if (!empty($pic)) {
				$attid = M('attachment')->where(array('filepath' => $pic))->getField('id');
				if($attid){
					M('attachmentindex')->add(array('attid' => $attid,'arcid' => $id, 'modelid' => 0, 'desc' => 'link'));
				}
			}
	

			$this->success('添加成功',U(GROUP_NAME. '/Link/index'));
		}else {
			$this->error('添加失败');
		}
	}

	//编辑文章
	public function edit() {
		//当前控制器名称
		$id = I('id', 0, 'intval');
		$actionName = strtolower($this->getActionName());
		if (IS_POST) {
			$this->editHandle();
			exit();
		}
		$this->vo = M($actionName)->find($id);
		$this->display();
	}


	//修改文章处理
	public function editHandle() {

		$name = I('name', '', 'trim');
		$url = I('url', '', 'trim');
		$pic = I('logo', '', 'trim');
		$id = I('id', 0, 'intval');
		if (empty($name) || empty($url)) {
			$this->error('网站名称或网址不能为空');
		}
		

		if (false !== M('link')->save($_POST)) {
			M('attachmentindex')->where(array('arcid' => $id, 'modelid' => 0, 'desc' => 'link'))->delete();
			//更新上传附件表
			if (!empty($pic)) {
				$attid = M('attachment')->where(array('filepath' => $pic))->getField('id');
				if($attid){
					M('attachmentindex')->add(array('attid' => $attid,'arcid' => $id, 'modelid' => 0, 'desc' => 'link'));
				}
			}


			$this->success('修改成功', U(GROUP_NAME. '/Link/index', array('pid' => $pid)));
		}else {

			$this->error('修改失败');
		}
		
	}

	//彻底删除文章
	public function del() {
		$id = I('id',0 , 'intval');
		$batchFlag = isset($_GET['batchFlag'])? intval($_GET['batchFlag']) : 0;
		//批量删除
		if ($batchFlag) {
			$this->delBatch();
			return;
		}
		if (M('link')->delete($id)) {			
			M('attachmentindex')->where(array('arcid' => $id, 'modelid' => 0, 'desc' => 'link'))->delete();
			$this->ajaxReturn(1, "彻底删除成功！", 1);
		}else {
			$this->ajaxReturn(0, "彻底删除失败！", 0);
		}
	}
	//批量彻底删除文章
	public function delBatch() {
		$idArr = I('key',0 , 'intval');		
		if (!is_array($idArr)) {
			$this->ajaxReturn(0, "请选择要彻底删除的项！", 0);
		}
		$where = array('id' => array('in', $idArr));
		if (M('link')->where($where)->delete()) {
			M('attachmentindex')->where(array('arcid' => array('in', $idArr), 'modelid' => 0, 'desc' => 'link'))->delete();
			$this->ajaxReturn(1, "彻底删除成功！", 1);
		}else {
			$this->ajaxReturn(0, "彻底删除失败！", 0);
		}
	}
}
?>