<?php 
class ChanpinModel extends RelationModel {
	private $chanpin_id;
	//自动验证
	protected $_validate = array(
	    array('chanpin_cid','number','请选择分类！',1,'',3),
		array('chanpin_cid','getlistson','请选择当前子类栏目！',1,'function',3),
		array('chanpin_name','require','影片名称必须填写！',1,'',3),
	);
	//自动完成
	protected $_auto = array(
		array('chanpin_letter','chanpin_letter',3,'callback'),
		array('chanpin_gold','chanpin_gold',3,'callback'),
		array('chanpin_pic','chanpin_pic',3,'callback'),
		array('chanpin_addtime','chanpin_addtime',3,'callback'),
		array('chanpin_filmtime','chanpin_filmtime',3,'callback'),
		array('chanpin_year','chanpin_year',3,'callback'),
	);
	//关联定义
	protected $_link = array(
		'Tag'=>array(
			'mapping_type' => HAS_MANY,
			'class_name'=> 'Tag',
			'mapping_name'=>'Tag',//数据对像映射名称
			'foreign_key' => 'tag_id',
			'parent_key' => 'chanpin_id',
			'mapping_fields' => 'tag_id,tag_sid,tag_name',
			'condition' => 'tag_sid = 1',
			//'mapping_limit' => 5,
			//'mapping_order' => 'create_time desc',
		)
	);
	//字母处理
	public function chanpin_letter(){
		return ff_letter_first(trim($_POST["chanpin_name"]));
	}
	//图片处理
	public function chanpin_pic(){
		$img = D('Img');
		return $img->down_load(trim($_POST["chanpin_pic"]));
	}		
	//积分处理
	public function chanpin_gold(){
		if($_POST["chanpin_gold"] > 10){
			$_POST["chanpin_gold"] = 10;
		}	
		return 	$_POST["chanpin_gold"];
	}			
	//是否更新时间
	public function chanpin_addtime(){
		if ($_POST['checktime']) {
			return time();
		}else{
			return strtotime($_POST['chanpin_addtime']);
		}
	}
	//处理上映日期
	public function chanpin_filmtime(){
		if ($_POST['chanpin_filmtime']) {
			return strtotime($_POST['chanpin_filmtime'].' 0:0:0');
		}else{
			return '';
		}
	}
	//处理年代
	public function chanpin_year(){
		if ($_POST['chanpin_filmtime']) {
			return date('Y',strtotime($_POST['chanpin_filmtime'].' 0:0:0'));
		}else{
			return $_POST['chanpin_year'];
		}
	}		
}
?>