<?php
class XmlModel extends Model {
    private $ffdb;
    public function __construct(){
		$this->ffdb = M('Chanpin');
    }			
	//采集入库
    public function xml_insert($chanpin, $mustup){
	    if(empty($chanpin['chanpin_name']) || empty($chanpin['chanpin_url'])){
			return '影片名称或播放地址为空，不做处理!';
		}
		if(!$chanpin['chanpin_cid']){
			return '未匹配到对应栏目分类，不做处理!';
		}
		// 格式化常规字符
		$chanpin['chanpin_name'] = ff_xml_chanpinname($chanpin['chanpin_name']);
		$chanpin['chanpin_actor'] = ff_xml_chanpinactor($chanpin['chanpin_actor']);
		$chanpin['chanpin_director'] = ff_xml_chanpinactor($chanpin['chanpin_director']);	
		// 检测来源是否完全相同
		$array = $this->ffdb->field('chanpin_id,chanpin_name,chanpin_inputer,chanpin_play,chanpin_url')->where('chanpin_reurl="'.$chanpin['chanpin_reurl'].'"')->find();
		if($array){
			return $this->xml_update($chanpin, $array, $mustup);
		}
		// 检测影片名称是否相等(需防止同名的电影与电视冲突)
		$array = $this->ffdb->field('chanpin_id,chanpin_name,chanpin_actor,chanpin_title,chanpin_inputer,chanpin_play,chanpin_url')->where('chanpin_name="'.$chanpin['chanpin_name'].'" ')->find();
		if($array){
			//无主演 或 演员完全相等时 更新该影片
			if(empty($chanpin['chanpin_actor']) || ($array['chanpin_actor'] == $chanpin['chanpinactor'])){
				return $this->xml_update($chanpin,$array,$mustup);
			}
			//有相同演员时更新该影片
			$arr_actor_1 = explode(',', ff_xml_chanpinactor($chanpin['chanpin_actor']));
			$arr_actor_2 = explode(',', ff_xml_chanpinactor($array['chanpin_actor']));
			if(array_intersect($arr_actor_1,$arr_actor_2)){
				return $this->xml_update($chanpin,$array,$mustup);
			}
		}
		//  相似条件判断
		if(C('play_collect_name')){
			$length = ceil(strlen($chanpin['chanpin_name'])/3) - intval(C('play_collect_name'));
			if($length > 1){
				$where = array();
				$where['chanpin_name'] = array('like',msubstr($chanpin['chanpin_name'],0,$length).'%');
				$array = $this->ffdb->field('chanpin_id,chanpin_name,chanpin_actor,chanpin_title,chanpin_inputer,chanpin_play,chanpin_url')->where($where)->order('chanpin_id desc')->find();
				if($array){
					// 主演完全相同 则检查是否需要更新
					if(!empty($array['chanpin_actor']) && !empty($chanpin['chanpin_actor']) ){
						$arr_actor_1 = explode(',', ff_xml_chanpinactor($chanpin['chanpin_actor']));
						$arr_actor_2 = explode(',', ff_xml_chanpinactor($array['chanpin_actor']));
						if(!array_diff($arr_actor_1,$arr_actor_2) && !array_diff($arr_actor_2,$arr_actor_1)){//若差集为空
							return $this->xml_update($chanpin,$array,$mustup);
						}
					}
					// 不是同一资源库 则标识为相似待审核
					if(!in_array($chanpin['chanpin_inputer'],$array)){
						$chanpin['chanpin_status'] = -1;
					}
				}
			}
		}
		// 添加影片开始
		unset($chanpin['chanpin_id']);
		$img = D('Img');
		$chanpin['chanpin_pic'] = $img->down_load($chanpin['chanpin_pic']);
		$chanpin['chanpin_gold']    = mt_rand(1,C('rand_gold'));
		$chanpin['chanpin_golder']  = mt_rand(1,C('rand_golder'));
		$chanpin['chanpin_up']      = mt_rand(1,C('rand_updown'));
		$chanpin['chanpin_down']    = mt_rand(1,C('rand_updown'));
		$chanpin['chanpin_hits']    = mt_rand(0,C('rand_hits'));
		$chanpin['chanpin_letter'] = ff_letter_first($chanpin['chanpin_name']);
		// 随机伪原创
		if(C('play_collect')){
			$chanpin['chanpin_content'] = ff_rand_str($chanpin['chanpin_content']);
		}		
		$chanpin['chanpin_stars'] = 1;
		$chanpin['chanpin_addtime'] = time();
		$id = $this->ffdb->data($chanpin)->add();
		// 增加关联tag
		if( $chanpin['chanpin_keywords'] ){
			$data = array();
			$data['tag_id'] = $id;
			$data['tag_sid'] = 1;
			$rstag = M("Tag");
			$rstag->where($data)->delete();
			$tags = array_unique(explode(',',trim($chanpin['chanpin_keywords'])));
			foreach($tags as $key=>$val){
				$data['tag_name'] = $val;
				$rstag->data($data)->add();
			}
		}
		if($id){
			return '添加成功('.$id.')。';
		}
		return '添加失败。';
    }	
	// 更新数据
	public function xml_update($chanpin, $chanpin_old, $mustup=false){	
		// 检测是否站长手动锁定更新
		if('ppchanpin' == $chanpin_old['chanpin_inputer']){
			return '站长手动设置，不更新。';
		}
		// 是否为强制更新资料图片等参数
		$edit = array();
		if( $mustup ){
			$img = D('Img');
			$edit['chanpin_pic'] = $img->down_load($chanpin['chanpin_pic']);
			$edit['chanpin_actor'] = $chanpin['chanpin_actor'];
			$edit['chanpin_director'] = $chanpin['chanpin_director'];
			$edit['chanpin_area'] = $chanpin['chanpin_area'];
			$edit['chanpin_language'] = $chanpin['chanpin_language'];
			$edit['chanpin_total'] = $chanpin['chanpin_total'];
			$edit['chanpin_isend'] = $chanpin['chanpin_isend'];
			$edit['chanpin_isfilm'] = $chanpin['chanpin_isfilm'];
			$edit['chanpin_filmtime'] = $chanpin['chanpin_filmtime'];
		}else{
			//if($chanpin['chanpin_title']){ $edit['chanpin_title'] = $chanpin['chanpin_title']; }
			if($chanpin['chanpin_area']){ $edit['chanpin_area'] = $chanpin['chanpin_area']; }
			if($chanpin['chanpin_year']){ $edit['chanpin_year'] = $chanpin['chanpin_year']; }
			if($chanpin['chanpin_language']){ $edit['chanpin_language'] = $chanpin['chanpin_language']; }
			if($chanpin['chanpin_total']){ $edit['chanpin_total'] = $chanpin['chanpin_total']; }
			if($chanpin['chanpin_isend']){ $edit['chanpin_isend'] = $chanpin['chanpin_isend']; }
			if($chanpin['chanpin_isfilm']){ $edit['chanpin_isfilm'] = $chanpin['chanpin_isfilm']; }
			if($chanpin['chanpin_filmtime']){ $edit['chanpin_filmtime'] = $chanpin['chanpin_filmtime']; }			
		}
		// 分解原服务器组
		$array_play_old = explode('$$$', $chanpin_old['chanpin_play']);
		$play_key = array_search($chanpin['chanpin_play'], $array_play_old);
		// 检测是否已存在相同播放器组的播放地址
		if($play_key !== false){
			$array_url_old = explode('$$$',$chanpin_old['chanpin_url']);
			$chanpin_old['chanpin_url_key_old'] = $array_url_old[$play_key];
			$chanpin_old['chanpin_url_key_new'] = $this->xml_update_urlone($chanpin_old['chanpin_url_key_old'], $chanpin['chanpin_url']);
			// 检测当组的新播放地址与原数据库里的是否相同
			if($chanpin_old['chanpin_url_key_old'] == $chanpin_old['chanpin_url_key_new']){
				return strtoupper($chanpin['chanpin_play']).' 对应的地址未变化，不更新。';
			}else{
				$array_url_old[$play_key] = $chanpin_old['chanpin_url_key_new'];
				$edit['chanpin_url'] = implode('$$$',$array_url_old);
				$edit['chanpin_update_info'] = strtoupper($chanpin['chanpin_play']).' 对应更新。';
			}
		}else{
			$edit['chanpin_play'] = $chanpin_old['chanpin_play'].'$$$'.$chanpin['chanpin_play'];
			$edit['chanpin_url'] = trim($chanpin_old['chanpin_url']).'$$$'.$chanpin['chanpin_url'];
			$edit['chanpin_update_info'] = strtoupper($chanpin['chanpin_play']).' 新添加地址。';			
		}
		// 组合更新条件及内容(以最后一次更新的库为检测依据)
		$edit['chanpin_id'] = $chanpin_old['chanpin_id'];
		$edit['chanpin_name'] = $chanpin['chanpin_name'];
		$edit['chanpin_continu'] = $chanpin['chanpin_continu'];	
		$edit['chanpin_inputer'] = $chanpin['chanpin_inputer'];
		$edit['chanpin_reurl'] = $chanpin['chanpin_reurl'];
		$edit['chanpin_addtime'] = time();
		$this->ffdb->data($edit)->save();
		//删除数据缓存
		if(C('data_cache_chanpin')){
			S('data_cache_chanpin_'.$chanpin_old['chanpin_id'],NULL);
		}			
		return $edit['chanpin_update_info'];
	}	
	// 重生成某一组的播放地址 返回新的地址(string)
	public function xml_update_urlone($chanpinurlold, $chanpinurlnew){
		$arrayold = explode(chr(13),trim($chanpinurlold));
		$arraynew = explode(chr(13),trim($chanpinurlnew));
		foreach($arraynew as $key=>$value){
			unset($arrayold[$key]);
		}
		if($arrayold){
			return implode(chr(13),array_merge($arraynew,$arrayold));
		}else{
			return implode(chr(13),$arraynew);
		}
	}					
}
?>