<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class adminbase extends X {
    protected $cpfile; 
    protected $cptpl; 
    protected $pagesize = 30;
    protected $page = 1;
    protected $gb_c = "";
    protected $gb_a = "";

    
    public function __construct() {
        $this->gb_c = GB_OECMS_C;
        $this->gb_a = GB_OECMS_A;
        if ($this->gb_c != "login") {
            $this->checkLogin(); 
        }
        $this->cpfile = __ADMIN_FILE__;
        $this->cptpl = 'tpl/'.__ADMIN_TPLDIR__.'/';
        $this->page = intval(XRequest::getArgs('page'));
        if ($this->page<1) {
            $this->page = 1;
        }
        $_var_array = array(
            "c"=>$this->gb_c,
            "a"=>$this->gb_a,
            "time"=>time(),
            "cpfile"=>$this->cpfile,
        );
        TPL::assign($_var_array);
        if (isset($_GET['oecms'])) {
            X::poweredBy();
        }
    }
    
    public function checkLogin() {
        if(false === parent::model('login', 'am')->checkLogin()){
            XHandle::redirect($this->cpfile.'?c=login');
        }
    }

    
    public function checkAuth($value) {
        $auth = parent::model('login', 'am');
        $auth->checkAuth($value);
        unset($auth);
    }
    
    public function log($em, $oplog = '', $result = 1) {
        
        require_once BASE_ROOT.'source/include/elements.php';
        $emarray = array();
        $emarray = auth_get_em_array();

        
        $log_string = '';
        if (!empty($em)) {
            $log_string = $emarray[$em];
        }
        if (!empty($oplog)) {
            $log_string .= !empty($log_string) ? '-'.$oplog : $oplog;
        }

        
        if (!empty($log_string)) {
            $logid = parent::$obj->fetch_newid("SELECT MAX(logid) FROM ".DB_PREFIX."log", 1);
            $log_array = array(
                'logid'=>$logid,
                'username'=>parent::$wrap_admin['adminname'],
                'ip'=>XRequest::getip(),
                'content'=>$log_string,
                'logtype'=>1,
                'timeline'=>time(),
                'success'=>$result,
            );
            parent::$obj->insert(DB_PREFIX.'log', $log_array);
            unset($log_array);
        }
    }

    
    public function saveLoginLog($username, $content, $success=0) {
        $logid = parent::$obj->fetch_newid("SELECT MAX(logid) FROM ".DB_PREFIX."log", 1);
        $log_array = array(
            'logid'=>$logid,
            'username'=>$username,
            'ip'=>XRequest::getip(),
            'content'=>$content,
            'logtype'=>1,
            'timeline'=>time(),
            'success'=>$success,
        );
        parent::$obj->insert(DB_PREFIX.'log', $log_array);
        unset($username, $content, $success, $logid, $log_array);
    }

    protected function c() { 
        return $this->gb_c;
    }
    protected function url($url_items=null) { 
        $_url = $this->cpfile."?c=".$this->c();
        if (!empty($url_items)) {
            $_url .= "&".$url_items;
        }
        return $_url;
    }
}
?>
