<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends adminbase {
    private $modname = "quecomment";
    private $_urlitem = null;
    private $_comeurl = null;
    private $stopicname = null;
    private $scontent = null;
    private $sflag = 0;
    private $sisreply = 0;

    private function _getItems() {
        $this->scatid = XRequest::getInt("scatid");
        $this->stopicname = XRequest::getArgs("stopicname");
        $this->scontent = XRequest::getGpc("scontent");
        $this->sflag = XRequest::getInt("sflag");
        $this->sisreply = XRequest::getInt("sisreply");
        $this->_urlitem = "stopicname=".urlencode($this->stopicname)."&scontent=".urlencode($this->scontent).
                            "&sflag=".$this->sflag."&sisreply=".$this->sisreply;
        $this->_comeurl = $this->_urlitem."&page=".$this->page."";
    }

    
    public function action_run() {
        $this->_getItems();
        $searchsql = "";
        if (!empty($this->stopicname)) {
            $searchsql .= " AND t.topicname LIKE '%{$this->stopicname}%'";
        }
        if (!empty($this->scontent)) {
            $searchsql .= " AND v.content LIKE '%{$this->scontent}%'";
        }
        if ($this->sflag == 1) { 
            $searchsql .= " AND v.flag='0'";
        }
        elseif ($this->sflag == 2) { 
            $searchsql .= " AND v.flag='1'";
        }
        if ($this->sisreply == 1) { 
            $searchsql .= " AND v.isreply='0'";
        }
        elseif ($this->sisreply == 2) { 
            $searchsql .= " AND v.isreply='1'";
        }

        $model = parent::model($this->modname, "am");
        list($total, $data) = $model->getList(array(
            'page'=>$this->page,
            'pagesize'=>$this->pagesize,
            'searchsql'=>$searchsql,
        ));
        unset($model);
        
        $url = XRequest::getPhpSelf()."?c=".$this->gb_c;
        $var_array = array(
            'page'=>$this->page,
            'nextpage'=>$this->page+1,
            'prepage'=>$this->page-1,
            'pagecount'=>ceil($total/$this->pagesize),
            'pagesize'=>$this->pagesize,
            'total'=>$total,
            'showpage'=>XPage::admin($total, $this->pagesize, $this->page, $url, 10),
            'quecomment'=>$data,
            'scontent'=>$this->scontent,
            'stopicname'=>$this->stopicname,
            'sflag'=>$this->sflag,
            'sisreply'=>$this->sisreply,
            'urlitem'=>$this->_urlitem,
            'comeurl'=>$this->_comeurl,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl."{$this->gb_c}.tpl");
    }

    
    public function action_edit() {
        $this->_getItems();
        $id = $this->_validID();
        
        $model = parent::model($this->modname, "am");
        $data = $model->getData($id);
        unset($model);
        if (empty($data)) {
            XHandle::halt("读取数据不存在", "", 1);
        }
        
        $var_array = array(
            'quecomment'=>$data,
            'id'=>$id,
            'comeurl'=>$this->_comeurl,
            'urlitem'=>$this->_urlitem,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl."{$this->gb_c}.tpl");
    }

    
    public function action_saveedit() {
        $this->_getItems();
        list($id, $args) = $this->_validEdit();
        $result = parent::model($this->modname, "am")->doEdit($id, $args);
        unset($model);
        if (true === $result) {
            $this->log("quecomment_edit", "id={$id}", 1);
            XHandle::halt("编辑成功", $this->cpfile."?c={$this->gb_c}&".$this->_comeurl, 0);
        }
        else {
            $this->log("quecomment_edit", "id={$id}", 0);
            XHandle::halt("编辑失败", "", 1);
        }
    }

    
    public function action_del() {
        $this->_getItems();
        $array_id = $this->_validArrayID();
        $model = parent::model($this->modname, "am");
        for($ii=0; $ii<count($array_id); $ii++){
            $id = intval($array_id[$ii]);
            $result = $model->doDel($id);
        }
        unset($model);
        if (true === $result) {
            $this->log("quecomment_del", "id={$array_id}", 1);
            XHandle::halt("删除成功", $this->cpfile."?c={$this->gb_c}&".$this->_comeurl, 0);
        }
        else {
            $this->log("quecomment_del", "id={$array_id}", 0);
            XHandle::halt("删除失败", "", 1);
        }
    }

    
    public function action_update() {
        $args = XRequest::getGpc(array('id', 'type'));
        parent::model($this->modname, "am")->doUpdate(intval($args['id']), trim($args['type']));
    }

    private function _validEdit() {
        $id = $this->_validID();
        $args = XRequest::getGpc(array(
            "user", "content", "flag", "reply", "replytime",
        ));
        if (empty($args['user'])) {
            XHandle::halt("评论人不能为空", "", 1);
        }
        if (empty($args['content'])) {
            XHandle::halt("评论内容不能为空", "", 1);
        }
        if (!empty($args['replytime'])) {
            $args['replytime'] = strtotime(trim(str_replace('&nbsp;', ' ', $args['replytime'])));
        }
        if (!empty($args['reply'])) {
            $args['isreply'] = 1;
            if (empty($args['replytime'])) {
                $args['replytime'] = time();
            }
        }
        return array($id, $args);
    }

    private function _validID() {
        $id = XRequest::getInt('id');
        if ($id < 1) {
            XHandle::halt("ID错误", "", 1);
        }
        return $id;
    }

    private function _validArrayID() {
        $ids = XRequest::getArray('id');
        if (empty($ids)) {
            XHandle::halt("ID错误", "", 1);
        }
        return $ids;
    }
}
?>
