<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends adminbase {
    private $modname = "question";
    private $_urlitem = null;
    private $_comeurl = null;
    private $stopicid = 0;
    private $stitle = null;
    private function _getItems() {
        $this->stopicid = XRequest::getInt("stopicid");
        $this->stitle = XRequest::getArgs("stitle");
        $this->_urlitem = "stitle=".urlencode($this->stitle)."&stopicid=".$this->stopicid;
        $this->_comeurl = $this->_urlitem."&page=".$this->page;
    }

    
    public function action_run() {
        $this->_getItems();
        $searchsql = "";
        if ($this->stopicid > 0) {
            $searchsql .= " AND v.topicid='{$this->stopicid}'";
        }
        if (!empty($this->stitle)) {
            $searchsql .= " AND v.title LIKE '%".$this->stitle."%'";
        }
        $model = parent::model($this->modname, "am");
        list($total, $data) = $model->getList(array(
            'page'=>$this->page,
            'pagesize'=>$this->pagesize,
            'searchsql'=>$searchsql,
        ));
        unset($model);
        
        $url = XRequest::getPhpSelf()."?c={$this->gb_c}";
        $var_array = array(
            'page'=>$this->page,
            'nextpage'=>$this->page+1,
            'prepage'=>$this->page-1,
            'pagecount'=>ceil($total/$this->pagesize),
            'pagesize'=>$this->pagesize,
            'total'=>$total,
            'showpage'=>XPage::admin($total, $this->pagesize, $this->page, $url, 10),
            'question'=>$data,
            'stitle'=>$this->stitle,
            'stopicid'=>$this->stopicid,
            'urlitem'=>$this->_urlitem,
            'comeurl'=>$this->_comeurl,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl."question.tpl");
    }

    
    public function action_add() {
        $this->_getItems();
        $var_array = array(
            "stopicid"=>$this->stopicid,
            "stitle"=>$this->stitle,
            "comeurl"=>$this->_comeurl,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl."question.tpl");
    }

    
    public function action_edit() {
        $this->_getItems();
        $id = $this->_validID();
        
        $model = parent::model($this->modname, "am");
        $data = $model->getData($id);
        unset($model);
        if (empty($data)) {
            XHandle::halt("读取数据不存在", "", 1);
        }
        
        $var_array = array(
            'question'=>$data,
            'id'=>$id,
            'comeurl'=>$this->_comeurl,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl."question.tpl");
    }

    
    public function action_saveadd() {
        $this->_getItems();
        $args = $this->_validAdd();
        $result = parent::model($this->modname, "am")->doAdd($args);
        if (true === $result) {
            $this->log("question_add", "", 1);
            XHandle::halt("添加成功", $this->cpfile."?c=question&".$this->_comeurl, 0);
        }
        else {
            $this->log("question_add", "", 0);
            XHandle::halt("添加失败", "", 1);
        }
    }

    
    public function action_saveedit() {
        $this->_getItems();
        list($id, $args) = $this->_validEdit();
        $result = parent::model($this->modname, "am")->doEdit($id, $args);
        unset($model);
        if (true === $result) {
            $this->log("question_edit", "id={$id}", 1);
            XHandle::halt("编辑成功", $this->cpfile."?c=question&".$this->_comeurl, 0);
        }
        else {
            $this->log("question_edit", "id={$id}", 0);
            XHandle::halt("编辑失败", "", 1);
        }
    }

    
    public function action_del() {
        $this->_getItems();
        $array_id = $this->_validArrayID();
        $model = parent::model($this->modname, "am");
        for($ii=0; $ii<count($array_id); $ii++){
            $id = intval($array_id[$ii]);
            $result = $model->doDel($id);
        }
        unset($model);
        if (true === $result) {
            $this->log("question_del", "id={$array_id}", 1);
            XHandle::halt("删除成功", $this->cpfile."?c=question&".$this->_comeurl, 0);
        }
        else {
            $this->log("question_del", "id={$array_id}", 0);
            XHandle::halt("删除失败", "", 1);
        }
    }

    private function _validAdd() {
        $args = XRequest::getGpc(array(
            "topicid", "title", "orders",
        ));
        $args['topicid'] = intval($args['topicid']);
        $args['orders'] = intval($args['orders']);
        if ($args['topicid'] < 1) {
            XHandle::halt("请选择问卷主题", "", 1);
        }
        if (empty($args['title'])) {
            XHandle::halt("请填写题目标题", "", 1);
        }
        return $args;
    }

    private function _validEdit() {
        $id = $this->_validID();
        $args = $this->_validAdd();
        return array($id, $args);
    }

    private function _validID() {
        $id = XRequest::getInt('id');
        if ($id < 1) {
            XHandle::halt("ID错误", "", 1);
        }
        return $id;
    }

    private function _validArrayID() {
        $ids = XRequest::getArray('id');
        if (empty($ids)) {
            XHandle::halt("ID错误", "", 1);
        }
        return $ids;
    }
}
?>
