<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends adminbase {
    private $modname = "quetopic";
    private $_urlitem = null;
    private $_comeurl = null;
    private $stopicname = null;
    private function _getItems() {
        $this->stopicname = XRequest::getArgs("stopicname");
        $this->_urlitem = "stopicname=".urlencode($this->stopicname);
        $this->_comeurl = $this->_urlitem."&page=".$this->page;
    }

    
    public function action_run() {
        $this->_getItems();
        $searchsql = "";
        if (!empty($this->stopicname)) {
            $searchsql .= " AND v.topicname LIKE '%".$this->stopicname."%'";
        }
        $model = parent::model($this->modname, "am");
        list($total, $data) = $model->getList(array(
            'page'=>$this->page,
            'pagesize'=>$this->pagesize,
            'searchsql'=>$searchsql,
        ));
        unset($model);
        
        $url = XRequest::getPhpSelf()."?c={$this->gb_c}";
        $var_array = array(
            'page'=>$this->page,
            'nextpage'=>$this->page+1,
            'prepage'=>$this->page-1,
            'pagecount'=>ceil($total/$this->pagesize),
            'pagesize'=>$this->pagesize,
            'total'=>$total,
            'showpage'=>XPage::admin($total, $this->pagesize, $this->page, $url, 10),
            'quetopic'=>$data,
            'stopicname'=>$this->stopicname,
            'urlitem'=>$this->_urlitem,
            'comeurl'=>$this->_comeurl,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl."quetopic.tpl");
	}

    
    public function action_add() {
        TPL::display($this->cptpl."quetopic.tpl");
    }

    
    public function action_edit() {
        $this->_getItems();
        $id = $this->_validID();
        
        $model = parent::model($this->modname, "am");
        $data = $model->getData($id);
        unset($model);
        if (empty($data)) {
            XHandle::halt("读取数据不存在", "", 1);
        }
        
        $var_array = array(
            'quetopic'=>$data,
            'id'=>$id,
            'comeurl'=>$this->_comeurl,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl."quetopic.tpl");
    }

    
    public function action_saveadd() {
        $args = $this->_validAdd();
        $result = parent::model($this->modname, "am")->doAdd($args);
        if (true === $result) {
            $this->log("quetopic_add", "", 1);
            XHandle::halt("添加成功", $this->cpfile."?c=quetopic", 0);
        }
        else {
            $this->log("quetopic_add", "", 0);
            XHandle::halt("添加失败", "", 1);
        }
	}

    
    public function action_saveedit() {
        $this->_getItems();
        list($id, $args) = $this->_validEdit();
        $result = parent::model($this->modname, "am")->doEdit($id, $args);
        unset($model);
        if (true === $result) {
            $this->log("quetopic_edit", "id={$id}", 1);
            XHandle::halt("编辑成功", $this->cpfile."?c=quetopic&".$this->_comeurl, 0);
        }
        else {
            $this->log("quetopic_edit", "id={$id}", 0);
            XHandle::halt("编辑失败", "", 1);
        }
    }

    
    public function action_del() {
        $this->_getItems();
        $array_id = $this->_validArrayID();
        $model = parent::model($this->modname, "am");
        for($ii=0; $ii<count($array_id); $ii++){
            $id = intval($array_id[$ii]);
            $result = $model->doDel($id);            
        }
        unset($model);
        if (true === $result) {
            $this->log("quetopic_del", "id={$array_id}", 1);
            XHandle::halt("删除成功", $this->cpfile."?c=quetopic&".$this->_comeurl, 0);
        }
        else {
            $this->log("quetopic_del", "id={$array_id}", 0);
            XHandle::halt("删除失败", "", 1);
        }  
    }

    private function _validAdd() {
        $args = XRequest::getGpc(array(
            "topicname", "intro", "endtime", "flag",
        ));
        if (empty($args['topicname'])) {
            XHandle::halt("请填写问卷标题", "", 1);
        }
        if (empty($args['endtime'])) {
            XHandle::halt("请填写投票截止时间", "", 1);
        }
        else {
            $args['endtime'] = strtotime(trim(str_replace('&nbsp;', ' ', $args['endtime'])));
        }
        $args['flag'] = intval($args['flag']);
        return $args;
    }

    private function _validEdit() {
        $id = $this->_validID();
        $args = $this->_validAdd();
        return array($id, $args);
    }

    private function _validID() {
        $id = XRequest::getInt('id');
        if ($id < 1) {
            XHandle::halt("ID错误", "", 1);
        }
        return $id;
    }

    private function _validArrayID() {
        $ids = XRequest::getArray('id');
        if (empty($ids)) {
            XHandle::halt("ID错误", "", 1);
        }
        return $ids;
    }
}
?>
