<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends adminbase {
    
    private $dir = NULL;
    private $nowdir = NULL;
    
    private $id = NULL;
    
    private $fromtype = NULL;

    public function __construct() {
        $this->control();
    }

    private function control() {
        parent::__construct();
        $this->checkLogin();
    }
    private function _getItems() {
        $this->dir = XRequest::getArgs('dir');
        $this->nowdir = $this->_filterBadDir($this->dir);
        $this->id = XRequest::getArgs('id');
        $this->fromtype = XRequest::getArgs('fromtype');
    }

    
    public function action_run() {
        $this->checkAuth('templet_volist');
        $this->_getItems();
        $model = parent::model('templet', 'am');
        list($total, $templets, $usingskin) = $model->getList($this->nowdir);
        unset($model);
        $var_array = array(
            'total'=>$total,
            'templets'=>$templets,
            'usingskin'=>$usingskin,
            'dir'=>$this->dir,
            'now_dir'=>$this->nowdir,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl.'templet.tpl');
    }

    
    public function action_select() {
        $this->_getItems();
        $inputid = XRequest::getArgs('inputid');
        $model =  parent::model('templet', 'am');
        list($total, $template, $usingskin) = $model->getList('');
        unset($model);
        
        $i = 0;
        $templets = array();
        if (!empty($template)) {
            foreach($template as $key=>$value) {
                if ($value['extension'] == 'tpl' && $value['type'] == 2) {
                    $templets[] = array(
                        'i'=>$i+1,
                        'size'=>$value['size'],
                        'timeline'=>$value['timeline'],
                        'filename'=>$value['filename'],
                        'tplname'=>$value['tplname'],
                    );
                    $i = ($i+1);
                }
            }
        }
        $var_array = array(
            'total'=>$total,
            'templets'=>$templets,
            'usingskin'=>$usingskin,
            'fromtype'=>$this->fromtype,
            'inputid'=>$inputid,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl.'templet.tpl');
    }

    
    public function action_edit() {
        $this->checkAuth('templet_edit');
        $this->_getItems();
        
        $id = $this->_getIdArgs();
        $model = parent::model('templet', 'am');
        list($content, $usingskin, $dir) = $model->getData($id);
        unset($model);

        
        $dir = str_replace(array('/'), array('@'), $dir);
        $filename  = str_replace(array('/'), array('@'), $id);
        $var_array = array(
            'content'=>$content,
            'usingskin'=>$usingskin,
            'dir'=>$dir,
            'id'=>$id,
            'filename'=>$filename,
        );
        TPL::assign($var_array);
        TPL::display($this->cptpl.'templet.tpl');
    }

    
    public function action_saveedit() {
        $this->checkAuth('templet_edit');
        $this->_getItems();
        $id = $this->_getIdArgs();
        $content = $this->_validEdit();

        $model = parent::model('templet', 'am');
        $result = $model->doEdit($id, $content);
        unset($model);
        if (true === $result) {
            $this->log('templet_edit', 'id='.$id.'', 1);
            if (!empty($this->dir)) {
                XHandle::halt('模板文件修改成功', $this->cpfile.'?c=templet&dir='.urlencode($this->dir).'', 0);
            }
            else {
                XHandle::halt('模板文件修改成功', $this->cpfile.'?c=templet', 0);
            }
        }
        else {
            $this->log('templet_edit', 'id='.$id.'', 0);
            XHandle::halt('对不起，修改模板文件失败，请检查模板目录是否有写入权限。', '', 1);
        }
    }

    
    private function _getIdArgs() {
        $id = XRequest::getArgs("id");
        if (empty($id)){
            XHandle::halt('对不起，参数错误！', '', 1);
        }
        if (strlen($id) < 4) {
            XHandle::halt('对不起，参数错误！', '', 1);
        }
        $fix = @substr($id, -3);
        if (!in_array($fix, array("css", "tpl"))) {
            XHandle::halt('对不起，文件格式有错！', '', 1);
        }
        $name = @substr($id, 0, strlen($id)-3);
        $name = @str_ireplace(
            array('.', '/', '%', '\\', '%5c'),
            array('', '', '', '', ''),
            $name
        );
        $name = @str_ireplace("@", "/", $name);
        $filename = $name.".".$fix;
        parent::loadLib('option');
        $nonce_templet = XOption::get('nonce_templet');
        if (false === file_exists(BASE_ROOT.'tpl/templets/'.$nonce_templet.$filename)) {
            XHandle::halt('对不起，文件不存在！', '', 1);
        }
        return $filename;
    }

    
    private function _validEdit() {
        $content = XRequest::getArgs('content', '', false);
        if (empty($content)) {
            XHandle::halt('对不起，模板内容不能为空。', '', 1);
        }
        return $content;
    }

    
    private function _filterBadDir($string) {
        parent::loadLib('option');
        $nonce_templet = XOption::get('nonce_templet');
        $now_string = $string;
        if (!empty($now_string)) { 
            $now_string = str_ireplace(
                array('.', '/', '%', '\\', '%5c'),
                array('', '', '', '', ''),
                $now_string
            );
            $now_string = @str_ireplace("@", "/", $now_string);
            if (!empty($now_string)) {
                $now_dir = BASE_ROOT.'tpl/templets/'.$nonce_templet.$now_string;
                if (!is_dir($now_dir)) {
                    XHandle::halt("目录不存在", "", 1);
                }
            }
        }
        return $now_string;
    }
}
?>
