<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
    exit('OECMS Access Denied');
}
class control extends indexbase {
    
    public function control_run() {
        list($page_title, $page_description, $page_keyword) = XSeo::buildSeo("ch_guestbook");
        $var_array = array(
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
        );
        $this->view($var_array, "guestbook");
    }
    
    
    public function control_saveadd() {
        $args = $this->_validAdd();
        $model = parent::model('guestbook','im');
        $result = $model->doAdd($args);
        unset($model);
        if (true === $result) {
            if (parent::$cfg['urlsuffix'] == 'php') {
                XHandle::halt('留言成功', parent::$urlpath.'index.php?c=guestbook', 0);
            }
            else {
                XHandle::halt('留言成功', parent::$urlpath.'guestbook/', 0);
            }
        }
        else {
            XHandle::halt('留言失败', '', 1);
        }
    }
    
    private function _validAdd() {
        $args = XRequest::getGpc(array(
            'title', 'username', 'email', 'content',
            'qq', 'msn', 'address', 'telephone', 'mobile',
            'checkcode', 
        ));
        if (empty($args['title'])) {
            XHandle::halt('请填写标题', '', 1);
        }
        if (empty($args['username'])) {
            XHandle::halt('请填写姓名', '', 1);
        }
        if (empty($args['email'])) {
            XHandle::halt('请填写邮箱', '', 1);
        }
		else {
			if (false === XValid::isEmail($args['email'])) {
				XHandle::halt('邮箱格式不正确', '', 1);
			}
		}
        if (empty($args['content'])) {
            XHandle::halt('请填写留言内容', '', 1);
        }
        parent::loadUtil('session');
        if ($args['checkcode'] != XSession::get('verifycode')) {
            XHandle::halt('验证码不正确', '', 1);
        }
        unset($args['checkcode']);
        return $args;
    }
}
?>
