<?php
/**
 * Copyright (C) OECMS All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 * Update 2016.03.19
 */
if(!defined('IN_OECMS')) {
	exit('OECMS Access Denied');
}
class control extends indexbase {
    public function control_run() {
        $this->control_list();
    }

    
    public function control_list() {
        $id = XRequest::getInt("topicid");
        if ($id < 1) {
            XHandle::halt("参数错误", "", 1);
        }
        $this->pagesize = intval(parent::$cfg['quecommentpagesize']) > 0 ? intval(parent::$cfg['quecommentpagesize']) : 10;
        $searchsql = "";
        if ($id > 0) {
            $searchsql .= " AND v.topicid='{$id}'";
        }

        $question = parent::model("quetopic", "im")->getOneData($id);
        
        $model = parent::model("quecomment", "im");
        list($total, $data) = $model->getList(
            array(
                "page"=>$this->page,
                "pagesize"=>$this->pagesize,
                "searchsql"=>$searchsql,
                "orderby"=>"",
            )
        );
        unset($model);

        
        $this->getMeta('ch_quecomment_list');
        $page_title = $this->metawrap['title'];
        $page_description = $this->metawrap['description'];
        $page_keyword = $this->metawrap['keyword'];
        $url = XRequest::getPhpSelf()."?c=quecomment&a=list&topicid=".$id;
        $showpage = XPage::index($total, $this->pagesize, $this->page, $url, 10);
        $var_array = array(
            'page'=>$this->page,
            'nextpage'=>$this->page+1,
            'prepage'=>$this->page-1,
            'pagecount'=>ceil($total/$this->pagesize),
            'pagesize'=>$this->pagesize,
            'total'=>$total,
            'showpage'=>$showpage,
            'quecomment'=>$data,
            'page_title'=>$page_title,
            'page_keyword'=>$page_keyword,
            'page_description'=>$page_description,
            'topicid'=>$id,
            "question"=>$question,
        );
		TPL::assign($var_array);
		TPL::display($this->getTPLFile("quecomment_list"));
    }

    
    public function control_savecomment() {
        $from = XRequest::getArgs("from");
        $args = XRequest::getGpc(array(
            "topicid", "user", "content",
        ));
        $args['topicid'] = intval($args['topicid']);
        if ($args['topicid'] < 1) {
            XHandle::halt("参数错误", "", 1);
        }
        if (empty($args['user'])) {
            XHandle::halt("请填写评论人", "", 1);
        }
        if (empty($args['content'])) {
            XHandle::halt("请填写评论内容", "", 1);
        }

        
        $model = parent::model("quecomment", "im");
        $result = $model->addtoComment($args);
        if (true === $result) {
            if ($from == "detail") {
                $return_url = parent::$urlpath."index.php?c=question&a=detail&id=".$args['topicid'];
            }
            else {
                $return_url = parent::$urlpath."index.php?c=quecomment&a=list&topicid=".$args['topicid'];
            }
            if (intval(parent::$cfg['auditcomment']) == 1) {
                XHandle::halt("评论成功，请等待审核", $return_url, 0);
            }
            else {
                XHandle::halt("评论成功", $return_url, 0);
            }
        }
        else {
            XHandle::halt("评论失败", "", 1);
        }
    }
}
?>
